/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import com.oceanprotocol.secretstore.auth.ConsumerWorker;
import com.oceanprotocol.secretstore.auth.PublisherWorker;
import com.oceanprotocol.secretstore.core.EvmDto;
import com.oceanprotocol.secretstore.core.SecretStoreDto;
import io.keyko.nevermined.exceptions.EncryptionException;
import java.io.IOException;

public class SecretStoreManager {
    private PublisherWorker publisherWorker;
    private ConsumerWorker consumerWorker;

    private SecretStoreManager(SecretStoreDto ssDto, EvmDto evmDto) {
        this.publisherWorker = new PublisherWorker(ssDto, evmDto);
        this.consumerWorker = new ConsumerWorker(ssDto, evmDto);
    }

    public static SecretStoreManager getInstance(SecretStoreDto ssDto, EvmDto evmDto) {
        return new SecretStoreManager(ssDto, evmDto);
    }

    public String encryptDocument(String resourceId, String content, int threshold) throws EncryptionException {
        try {
            return this.publisherWorker.encryptDocument(resourceId, content, threshold);
        }
        catch (IOException e) {
            throw new EncryptionException("Error encrypting Document", e);
        }
    }

    public String decryptDocument(String resourceId, String encryptedContent) throws EncryptionException {
        try {
            return this.consumerWorker.decryptDocument(resourceId, encryptedContent);
        }
        catch (IOException e) {
            throw new EncryptionException("Error decrypting Document", e);
        }
    }
}

