/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.common.helpers.EthereumHelper;
import io.keyko.common.helpers.UrlHelper;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.core.sla.functions.FulfillEscrowReward;
import io.keyko.nevermined.core.sla.functions.FulfillLockReward;
import io.keyko.nevermined.core.sla.handlers.ServiceAccessAgreementHandler;
import io.keyko.nevermined.core.sla.handlers.ServiceAgreementHandler;
import io.keyko.nevermined.core.sla.handlers.ServiceComputingAgreementHandler;
import io.keyko.nevermined.exceptions.ConsumeServiceException;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.DIDFormatException;
import io.keyko.nevermined.exceptions.DIDRegisterException;
import io.keyko.nevermined.exceptions.EscrowRewardException;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.exceptions.InitializeConditionsException;
import io.keyko.nevermined.exceptions.LockRewardFulfillException;
import io.keyko.nevermined.exceptions.OrderException;
import io.keyko.nevermined.exceptions.ServiceAgreementException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.exceptions.TokenApproveException;
import io.keyko.nevermined.external.GatewayService;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.AgreementsManager;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.manager.TemplatesManager;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.Order;
import io.keyko.nevermined.models.asset.AssetMetadata;
import io.keyko.nevermined.models.asset.OrderResult;
import io.keyko.nevermined.models.gateway.ComputeLogs;
import io.keyko.nevermined.models.gateway.ComputeStatus;
import io.keyko.nevermined.models.gateway.ExecuteService;
import io.keyko.nevermined.models.service.Agreement;
import io.keyko.nevermined.models.service.AgreementStatus;
import io.keyko.nevermined.models.service.AuthConfig;
import io.keyko.nevermined.models.service.Condition;
import io.keyko.nevermined.models.service.ProviderConfig;
import io.keyko.nevermined.models.service.Service;
import io.keyko.nevermined.models.service.ServiceBuilder;
import io.keyko.nevermined.models.service.types.AccessService;
import io.keyko.nevermined.models.service.types.AuthorizationService;
import io.keyko.nevermined.models.service.types.ComputingService;
import io.keyko.nevermined.models.service.types.MetadataService;
import io.keyko.nevermined.models.service.types.ProvenanceService;
import io.reactivex.Flowable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class NeverminedManager
extends BaseManager {
    private static final Logger log = LogManager.getLogger(NeverminedManager.class);
    private AgreementsManager agreementsManager;
    private TemplatesManager templatesManager;

    protected NeverminedManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static NeverminedManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new NeverminedManager(keeperService, metadataApiService);
    }

    public NeverminedManager setAgreementManager(AgreementsManager agreementManager) {
        this.agreementsManager = agreementManager;
        return this;
    }

    public NeverminedManager setTemplatesManager(TemplatesManager templatesManager) {
        this.templatesManager = templatesManager;
        return this;
    }

    public DID generateDID(DDO ddo) throws DIDFormatException {
        return DID.builder();
    }

    public boolean registerDID(DID did, String url, String checksum, List<String> providers) throws DIDRegisterException {
        log.debug("Registering DID " + did.getHash() + " into Registry " + this.didRegistry.getContractAddress());
        try {
            TransactionReceipt receipt = (TransactionReceipt)this.didRegistry.registerAttribute(EncodingHelper.hexStringToBytes((String)did.getHash()), EncodingHelper.hexStringToBytes((String)checksum.replace("0x", "")), providers, url).send();
            return receipt.getStatus().equals("0x1");
        }
        catch (Exception e) {
            throw new DIDRegisterException("Error registering DID " + did.getHash(), e);
        }
    }

    private Map<String, Object> buildBasicAccessServiceConfiguration(ProviderConfig providerConfig, String price, String creatorAddress) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("providerConfig", providerConfig);
        configuration.put("accessServiceTemplateId", this.escrowAccessSecretStoreTemplate.getContractAddress());
        configuration.put("accessSecretStoreConditionAddress", this.accessSecretStoreCondition.getContractAddress());
        configuration.put("price", price);
        configuration.put("creator", creatorAddress);
        return configuration;
    }

    private Map<String, Object> buildBasicComputingServiceConfiguration(ProviderConfig providerConfig, ComputingService.Provider computingProvider, String price, String creatorAddress) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("providerConfig", providerConfig);
        configuration.put("computingProvider", computingProvider);
        configuration.put("computingServiceTemplateId", this.escrowComputeExecutionTemplate.getContractAddress());
        configuration.put("execComputeConditionAddress", this.computeExecutionCondition.getContractAddress());
        configuration.put("price", price);
        configuration.put("creator", creatorAddress);
        return configuration;
    }

    public DDO registerAccessServiceAsset(AssetMetadata metadata, ProviderConfig providerConfig) throws DDOException {
        return this.registerAccessServiceAsset(metadata, providerConfig, new AuthConfig(providerConfig.getGatewayUrl(), AuthorizationService.AuthTypes.PSK_RSA));
    }

    public DDO registerAccessServiceAsset(AssetMetadata metadata, ProviderConfig providerConfig, AuthConfig authConfig) throws DDOException {
        try {
            Map<String, Object> configuration = this.buildBasicAccessServiceConfiguration(providerConfig, metadata.attributes.main.price, this.getMainAccount().address);
            Service accessService = ServiceBuilder.getServiceBuilder(Service.ServiceTypes.ACCESS).buildService(configuration);
            return this.registerAsset(metadata, providerConfig, accessService, authConfig);
        }
        catch (ServiceException e) {
            throw new DDOException("Error registering Asset.", e);
        }
    }

    public DDO registerComputeService(AssetMetadata metadata, ProviderConfig providerConfig, ComputingService.Provider computingProvider) throws DDOException {
        try {
            Map<String, Object> configuration = this.buildBasicComputingServiceConfiguration(providerConfig, computingProvider, metadata.attributes.main.price, this.getMainAccount().address);
            Service computingService = ServiceBuilder.getServiceBuilder(Service.ServiceTypes.COMPUTE).buildService(configuration);
            computingService.serviceEndpoint = providerConfig.getExecuteEndpoint();
            return this.registerAsset(metadata, providerConfig, computingService, new AuthConfig(providerConfig.getGatewayUrl()));
        }
        catch (ServiceException e) {
            throw new DDOException("Error registering Asset.", e);
        }
    }

    private DDO registerAsset(AssetMetadata metadata, ProviderConfig providerConfig, Service service, AuthConfig authConfig) throws DDOException {
        try {
            List<Condition> conditions;
            Object metadataEndpoint = providerConfig.getMetadataEndpoint() == null ? this.getMetadataApiService().getDdoEndpoint() + "/{did}" : providerConfig.getMetadataEndpoint();
            MetadataService metadataService = new MetadataService(metadata, (String)metadataEndpoint, 0);
            ProvenanceService provenanceService = new ProvenanceService(providerConfig.getMetadataEndpoint(), 1);
            AuthorizationService authorizationService = null;
            if (null != authConfig) {
                if (authConfig.getService().equals((Object)AuthorizationService.AuthTypes.SECRET_STORE)) {
                    authorizationService = AuthorizationService.buildSecretStoreAuthService(providerConfig.getSecretStoreEndpoint(), 2, authConfig.getThreshold());
                } else if (authConfig.getService().equals((Object)AuthorizationService.AuthTypes.PSK_ECDSA)) {
                    authorizationService = AuthorizationService.buildECDSAAuthService(providerConfig.getGatewayUrl(), 2);
                } else if (authConfig.getService().equals((Object)AuthorizationService.AuthTypes.PSK_RSA)) {
                    authorizationService = AuthorizationService.buildRSAAuthService(providerConfig.getGatewayUrl(), 2);
                }
            }
            DDO ddo = this.buildDDO(metadataService, this.getMainAccount().address);
            ddo.addService(service);
            ddo.addService(provenanceService);
            if (authorizationService != null) {
                ddo.addService(authorizationService);
            }
            ddo = ddo.integrityBuilder(this.getKeeperService().getCredentials());
            ddo.addAuthentication(ddo.id);
            if (service instanceof AccessService || service instanceof ComputingService) {
                if (authConfig.getService().equals((Object)AuthorizationService.AuthTypes.SECRET_STORE)) {
                    ddo.secretStoreLocalEncryptFiles(this.getSecretStoreManager(), authConfig);
                } else if (authConfig.getService().equals((Object)AuthorizationService.AuthTypes.PSK_ECDSA) || authConfig.getService().equals((Object)AuthorizationService.AuthTypes.PSK_RSA)) {
                    ddo.gatewayEncryptFiles(authConfig);
                }
            }
            ServiceAgreementHandler sla = null;
            Map<String, Object> conditionParams = null;
            if (service instanceof AccessService) {
                sla = new ServiceAccessAgreementHandler();
                conditionParams = ServiceBuilder.getAccessConditionParams(ddo.getDid().toString(), metadata.attributes.main.price, this.escrowReward.getContractAddress(), this.lockRewardCondition.getContractAddress(), this.accessSecretStoreCondition.getContractAddress());
            } else if (service instanceof ComputingService) {
                sla = new ServiceComputingAgreementHandler();
                conditionParams = ServiceBuilder.getComputingConditionParams(ddo.getDid().toString(), metadata.attributes.main.price, this.escrowReward.getContractAddress(), this.lockRewardCondition.getContractAddress(), this.computeExecutionCondition.getContractAddress());
            }
            try {
                conditions = sla.initializeConditions(conditionParams);
            }
            catch (InitializeConditionsException e) {
                throw new DDOException("Error registering Asset.", e);
            }
            Service theService = ddo.getService(service.index);
            theService.attributes.serviceAgreementTemplate.conditions = conditions;
            metadataEndpoint = UrlHelper.parseDDOUrl((String)metadataEndpoint, (String)ddo.getDid().toString());
            this.registerDID(ddo.getDid(), (String)metadataEndpoint, ddo.getDid().getHash(), providerConfig.getProviderAddresses());
            return this.getMetadataApiService().createDDO(ddo);
        }
        catch (DDOException | DIDRegisterException | ServiceException | IOException | CipherException e) {
            throw new DDOException("Error registering Asset.", e);
        }
    }

    public boolean isConditionFulfilled(String serviceAgreementId, Condition.ConditionTypes conditionType) throws Exception {
        int maxRetries = 5;
        long sleepTime = 500L;
        for (int iteration = 0; iteration < 5; ++iteration) {
            AgreementStatus status = this.agreementsManager.getStatus(serviceAgreementId);
            BigInteger conditionStatus = status.conditions.get((int)0).conditions.get(conditionType.toString());
            log.debug("Condition check[" + conditionType.toString() + "] :" + conditionStatus);
            if (conditionStatus.equals(BigInteger.TWO)) {
                return true;
            }
            Thread.sleep(500L);
        }
        return false;
    }

    public OrderResult purchaseAssetDirect(DID did) throws OrderException, ServiceException, EscrowRewardException {
        return this.purchaseAssetDirect(did, -1, Service.ServiceTypes.ACCESS);
    }

    public OrderResult purchaseAssetDirect(DID did, int serviceIndex) throws OrderException, ServiceException, EscrowRewardException {
        return this.purchaseAssetDirect(did, serviceIndex, null);
    }

    public OrderResult purchaseAssetDirect(DID did, Service.ServiceTypes serviceType) throws OrderException, ServiceException, EscrowRewardException {
        return this.purchaseAssetDirect(did, -1, serviceType);
    }

    public OrderResult purchaseAssetDirect(DID did, int serviceIndex, Service.ServiceTypes serviceType) throws OrderException, ServiceException, EscrowRewardException {
        OrderResult orderResult;
        DDO ddo;
        String serviceAgreementId = ServiceAgreementHandler.generateSlaId();
        try {
            ddo = this.resolveDID(did);
        }
        catch (DDOException e) {
            log.error("Error resolving did[" + did.getHash() + "]: " + e.getMessage());
            throw new OrderException("Error processing Order with DID " + did.getDid(), e);
        }
        if (serviceIndex >= 0) {
            Service service = ddo.getService(serviceIndex);
        } else if (serviceType.toString().equalsIgnoreCase(Service.ServiceTypes.COMPUTE.toString())) {
            ComputingService service = ddo.getComputeService();
            serviceIndex = service.index;
        } else {
            AccessService service = ddo.getAccessService();
            serviceIndex = service.index;
        }
        try {
            boolean isInitialized = this.initializeServiceAgreementDirect(ddo, serviceIndex, serviceAgreementId);
            if (!isInitialized) {
                throw new ServiceAgreementException(serviceAgreementId, "Service Agreement not Initialized");
            }
        }
        catch (ServiceAgreementException e) {
            String msg = "Error processing Order with DID " + did.getDid() + "and ServiceAgreementID " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new OrderException(msg, e);
        }
        String eventServiceAgreementId = EthereumHelper.add0x((String)serviceAgreementId);
        try {
            log.debug("Service Agreement " + serviceAgreementId + " initialized successfully");
            String price = ddo.getMetadataService().attributes.main.price;
            this.tokenApprove(this.tokenContract, this.lockRewardCondition.getContractAddress(), price);
            BigInteger balance = (BigInteger)this.tokenContract.balanceOf(this.getMainAccount().address).send();
            if (balance.compareTo(new BigInteger(price)) < 0) {
                log.warn("Consumer account does not have sufficient token balance to fulfill the LockRewardCondition. Do `requestTokens` using the `dispenser` contract then try this again.");
                log.warn("token balance is: " + balance + " price is: " + price);
                throw new LockRewardFulfillException("LockRewardCondition.fulfill will fail due to insufficient token balance in the consumer account.");
            }
        }
        catch (LockRewardFulfillException | TokenApproveException e) {
            String msg = "Error approving token";
            log.error(msg + ": " + e.getMessage());
            throw new OrderException(msg, e);
        }
        catch (Exception e) {
            String msg = "Token Transaction error";
            log.error(msg + ": " + e.getMessage());
            throw new OrderException(msg, e);
        }
        try {
            this.fulfillLockReward(ddo, serviceIndex, eventServiceAgreementId);
            boolean isFulfilled = this.isConditionFulfilled(serviceAgreementId, Condition.ConditionTypes.lockReward);
            orderResult = new OrderResult(serviceAgreementId, isFulfilled, false, serviceIndex);
        }
        catch (LockRewardFulfillException e) {
            this.fulfillEscrowReward(ddo, serviceIndex, serviceAgreementId);
            return new OrderResult(serviceAgreementId, false, true);
        }
        catch (Exception e) {
            this.fulfillEscrowReward(ddo, serviceIndex, serviceAgreementId);
            return new OrderResult(serviceAgreementId, false, true);
        }
        return orderResult;
    }

    public Flowable<OrderResult> purchaseAssetFlowable(DID did, int serviceIndex) throws OrderException {
        DDO ddo;
        String serviceAgreementId = ServiceAgreementHandler.generateSlaId();
        try {
            ddo = this.resolveDID(did);
        }
        catch (DDOException e) {
            log.error("Error resolving did[" + did.getHash() + "]: " + e.getMessage());
            throw new OrderException("Error processing Order with DID " + did.getDid(), e);
        }
        try {
            Service service = ddo.getService(serviceIndex);
            return this.initializeServiceAgreementFlowable(ddo, serviceIndex, serviceAgreementId).firstOrError().toFlowable().switchMap(eventServiceAgreementId -> {
                if (eventServiceAgreementId.isEmpty()) {
                    return Flowable.empty();
                }
                log.debug("Received AgreementCreated Event with Id: " + eventServiceAgreementId);
                String price = ddo.getMetadataService().attributes.main.price;
                this.tokenApprove(this.tokenContract, this.lockRewardCondition.getContractAddress(), price);
                BigInteger balance = (BigInteger)this.tokenContract.balanceOf(this.getMainAccount().address).send();
                if (balance.compareTo(new BigInteger(price)) < 0) {
                    log.warn("Consumer account does not have sufficient token balance to fulfill the LockRewardCondition. Do `requestTokens` using the `dispenser` contract then try this again.");
                    log.info("token balance is: " + balance + " price is: " + price);
                    throw new Exception("LockRewardCondition.fulfill will fail due to insufficient token balance in the consumer account.");
                }
                this.fulfillLockReward(ddo, serviceIndex, (String)eventServiceAgreementId);
                Flowable<String> conditionFulilledEvent = null;
                if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
                    conditionFulilledEvent = ServiceAgreementHandler.listenForFulfilledEvent(this.accessSecretStoreCondition, serviceAgreementId);
                } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
                    conditionFulilledEvent = ServiceAgreementHandler.listenForFulfilledEvent(this.computeExecutionCondition, serviceAgreementId);
                } else {
                    throw new ServiceAgreementException(serviceAgreementId, "Service type not supported");
                }
                return conditionFulilledEvent;
            }).map(event -> new OrderResult(serviceAgreementId, true, false, serviceIndex)).timeout(120L, TimeUnit.SECONDS).onErrorReturn(throwable -> {
                if (throwable instanceof TimeoutException) {
                    this.fulfillEscrowReward(ddo, serviceIndex, serviceAgreementId);
                    return new OrderResult(serviceAgreementId, false, true);
                }
                String msg = "There was a problem executing the Service Agreement " + serviceAgreementId;
                throw new ServiceAgreementException(serviceAgreementId, msg, (Throwable)throwable);
            });
        }
        catch (ServiceAgreementException | ServiceException e) {
            String msg = "Error processing Order with DID " + did.getDid() + "and ServiceAgreementID " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new OrderException(msg, e);
        }
    }

    public boolean downloadAssetByOwner(DID did, int serviceIndex, String basePath) throws ServiceException, ConsumeServiceException {
        return this.downloadAssetByOwner(did, serviceIndex, basePath, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean downloadAssetByOwner(DID did, int serviceIndex, String basePath, int fileIndex) throws ServiceException, ConsumeServiceException {
        Service service;
        DDO ddo;
        try {
            ddo = this.resolveDID(did);
        }
        catch (DDOException e) {
            log.error("Error resolving did[" + did.getHash() + "]: " + e.getMessage());
            throw new ConsumeServiceException("Error resolving did " + did.getDid(), e);
        }
        if (serviceIndex >= 0) {
            service = ddo.getService(serviceIndex);
        } else {
            service = ddo.getAccessService();
            serviceIndex = service.index;
        }
        Map<String, Object> consumeData = this.fetchAssetDataBeforeConsume(did, serviceIndex);
        String serviceEndpoint = ((String)consumeData.get("serviceEndpoint")).replace("/access", "/download");
        List files = (List)consumeData.get("files");
        String checkConsumerAddress = Keys.toChecksumAddress((String)this.getMainAccount().address);
        try {
            String signature = this.generateSignature(did.getDid());
            log.info("Signature: " + signature);
            for (AssetMetadata.File file : files) {
                try {
                    String destinationPath = this.buildDestinationPath(basePath, did, fileIndex, file);
                    GatewayService.downloadToPathByOwner(serviceEndpoint, checkConsumerAddress, did.getDid(), file.index, signature, destinationPath, false, 0, 0);
                }
                catch (IOException e) {
                    String msg = "Error downloading asset by owner with DID " + did.getDid();
                    log.error(msg + ": " + e.getMessage());
                    throw new ConsumeServiceException(msg, e);
                    return true;
                }
            }
        }
        catch (IOException | CipherException e) {
            String msg = "Error downloading asset with DID " + did.getDid();
            log.error(msg + ": " + e.getMessage());
            throw new ConsumeServiceException(msg, e);
        }
    }

    public List<byte[]> generateServiceConditionsId(String serviceAgreementId, String consumerAddress, DDO ddo, int serviceIndex) throws ServiceAgreementException, ServiceException {
        List<byte[]> conditionsId;
        Service service = ddo.getService(serviceIndex);
        HashMap<String, String> conditionsAddresses = new HashMap<String, String>();
        conditionsAddresses.put("escrowRewardAddress", this.escrowReward.getContractAddress());
        conditionsAddresses.put("lockRewardConditionAddress", this.lockRewardCondition.getContractAddress());
        if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
            conditionsAddresses.put("accessSecretStoreConditionAddress", this.accessSecretStoreCondition.getContractAddress());
            service = (AccessService)service;
        } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
            conditionsAddresses.put("computeExecutionConditionAddress", this.computeExecutionCondition.getContractAddress());
            service = (ComputingService)service;
        } else {
            throw new ServiceAgreementException(serviceAgreementId, "Service type not supported");
        }
        try {
            conditionsId = service.generateByteConditionIds(serviceAgreementId, conditionsAddresses, ddo.proof.creator, Keys.toChecksumAddress((String)consumerAddress));
        }
        catch (Exception e) {
            throw new ServiceAgreementException(serviceAgreementId, "Exception generating conditions id", e);
        }
        return conditionsId;
    }

    private boolean initializeServiceAgreement(DDO ddo, int serviceIndex, String serviceAgreementId) throws ServiceException, ServiceAgreementException {
        Boolean isTemplateApproved;
        Service service = ddo.getService(serviceIndex);
        try {
            isTemplateApproved = this.templatesManager.isTemplateApproved(service.templateId);
        }
        catch (EthereumException e) {
            String msg = "Error creating Service Agreement: " + serviceAgreementId + ". Error verifying template " + service.templateId;
            log.error(msg + ": " + e.getMessage());
            throw new ServiceAgreementException(serviceAgreementId, msg, e);
        }
        if (!isTemplateApproved.booleanValue()) {
            throw new ServiceAgreementException(serviceAgreementId, "The template " + service.templateId + " is not approved");
        }
        Boolean result = false;
        try {
            List<byte[]> conditionsId = this.generateServiceConditionsId(serviceAgreementId, Keys.toChecksumAddress((String)this.getMainAccount().getAddress()), ddo, serviceIndex);
            if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
                result = this.agreementsManager.createAccessAgreement(serviceAgreementId, ddo, conditionsId, Keys.toChecksumAddress((String)this.getMainAccount().getAddress()), service);
            } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
                result = this.agreementsManager.createComputeAgreement(serviceAgreementId, ddo, conditionsId, Keys.toChecksumAddress((String)this.getMainAccount().getAddress()), service);
            } else {
                throw new ServiceAgreementException(serviceAgreementId, "Service type not supported");
            }
            if (!result.booleanValue()) {
                return this.checkAgreementStatus(serviceAgreementId);
            }
        }
        catch (Exception e) {
            String msg = "Error creating Service Agreement: " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new ServiceAgreementException(serviceAgreementId, msg, e);
        }
        return false;
    }

    protected boolean initializeServiceAgreementDirect(DDO ddo, int serviceIndex, String serviceAgreementId) throws ServiceException, ServiceAgreementException {
        boolean initializationStatus = this.initializeServiceAgreement(ddo, serviceIndex, serviceAgreementId);
        if (!initializationStatus) {
            return this.checkAgreementStatus(serviceAgreementId);
        }
        return false;
    }

    protected Flowable<String> initializeServiceAgreementFlowable(DDO ddo, int serviceIndex, String serviceAgreementId) throws ServiceException, ServiceAgreementException {
        boolean initializationStatus = this.initializeServiceAgreement(ddo, serviceIndex, serviceAgreementId);
        boolean isInitialized = false;
        if (!initializationStatus) {
            isInitialized = this.checkAgreementStatus(serviceAgreementId);
        }
        if (!isInitialized) {
            throw new ServiceAgreementException(serviceAgreementId, "Service Agreement not initialized correctly");
        }
        Service service = ddo.getService(serviceIndex);
        Flowable<String> executeAgreementFlowable = null;
        if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
            executeAgreementFlowable = ServiceAgreementHandler.listenExecuteAgreement(this.escrowAccessSecretStoreTemplate, serviceAgreementId);
        } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
            executeAgreementFlowable = ServiceAgreementHandler.listenExecuteAgreement(this.escrowComputeExecutionTemplate, serviceAgreementId);
        } else {
            throw new ServiceAgreementException(serviceAgreementId, "Service type not supported");
        }
        return executeAgreementFlowable;
    }

    private boolean checkAgreementStatus(String serviceAgreementId) throws ServiceAgreementException {
        Boolean result = false;
        try {
            if (!result.booleanValue()) {
                int retries = 10;
                int sleepTime = 1000;
                for (int i = 0; i < retries && !result.booleanValue(); ++i) {
                    log.debug("Checking if the agreement is on-chain...");
                    Agreement agreement = this.agreementsManager.getAgreement(serviceAgreementId);
                    if (!agreement.templateId.equals("0x0000000000000000000000000000000000000000")) {
                        return true;
                    }
                    Thread.sleep(sleepTime);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceAgreementException(serviceAgreementId, "There was a problem checking the status", e);
        }
        if (!result.booleanValue()) {
            throw new ServiceAgreementException(serviceAgreementId, "The create Agreement Transaction has failed");
        }
        return false;
    }

    private boolean fulfillLockReward(DDO ddo, int serviceIndex, String serviceAgreementId) throws ServiceException, LockRewardFulfillException {
        Service service = ddo.getService(serviceIndex);
        String price = service.attributes.main.price;
        return FulfillLockReward.executeFulfill(this.lockRewardCondition, serviceAgreementId, this.escrowReward.getContractAddress(), price);
    }

    private boolean fulfillEscrowReward(DDO ddo, int serviceIndex, String serviceAgreementId) throws ServiceException, EscrowRewardException {
        Service service = ddo.getService(serviceIndex);
        String price = service.attributes.main.price;
        String lockRewardConditionId = "";
        String releaseConditionId = "";
        try {
            String conditionName;
            String conditionAddress;
            lockRewardConditionId = service.generateLockRewardId(serviceAgreementId, this.escrowReward.getContractAddress(), this.lockRewardCondition.getContractAddress());
            if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
                conditionAddress = this.accessSecretStoreCondition.getContractAddress();
                conditionName = "accessSecretStore";
            } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
                conditionAddress = this.computeExecutionCondition.getContractAddress();
                conditionName = "computeExecution";
            } else {
                throw new ServiceException("Service type not supported");
            }
            releaseConditionId = service.generateReleaseConditionId(serviceAgreementId, this.getMainAccount().getAddress(), conditionAddress, conditionName);
        }
        catch (UnsupportedEncodingException e) {
            throw new EscrowRewardException("Error generating the condition Ids ", e);
        }
        return FulfillEscrowReward.executeFulfill(this.escrowReward, serviceAgreementId, this.lockRewardCondition.getContractAddress(), price, this.getMainAccount().address, lockRewardConditionId, releaseConditionId);
    }

    private Map<String, Object> fetchAssetDataBeforeConsume(DID did, int serviceIndex) throws ConsumeServiceException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            DDO ddo = this.resolveDID(did);
            String serviceEndpoint = ddo.getAccessService((int)serviceIndex).serviceEndpoint;
            data.put("serviceEndpoint", serviceEndpoint);
            data.put("files", ddo.getMetadataService().attributes.main.files);
        }
        catch (DDOException | ServiceException e) {
            String msg = "Error getting the data from asset with DID " + did.toString();
            log.error(msg + ": " + e.getMessage());
            throw new ConsumeServiceException(msg, e);
        }
        return data;
    }

    public boolean access(String serviceAgreementId, DID did, int serviceIndex, String basePath) throws ConsumeServiceException {
        return this.access(serviceAgreementId, did, serviceIndex, 0, basePath);
    }

    public boolean access(String serviceAgreementId, DID did, int serviceIndex, int fileIndex, String basePath) throws ConsumeServiceException {
        String signature;
        Map<String, Object> consumeData = this.fetchAssetDataBeforeConsume(did, serviceIndex);
        String serviceEndpoint = (String)consumeData.get("serviceEndpoint");
        List files = (List)consumeData.get("files");
        String checkConsumerAddress = Keys.toChecksumAddress((String)this.getMainAccount().address);
        String agreementId = EthereumHelper.add0x((String)serviceAgreementId);
        try {
            signature = this.generateSignature(agreementId);
        }
        catch (IOException | CipherException e) {
            String msg = "Unable to generate service agreement signature";
            log.error("Unable to generate service agreement signature: " + e.getMessage());
            throw new ConsumeServiceException("Unable to generate service agreement signature", e);
        }
        for (AssetMetadata.File file : files) {
            try {
                String destinationPath = this.buildDestinationPath(basePath, did, fileIndex, file);
                GatewayService.downloadToPath(serviceEndpoint, checkConsumerAddress, agreementId, did.getDid(), fileIndex, signature, destinationPath, false, 0, 0);
            }
            catch (IOException e) {
                String msg = "Error consuming asset with DID " + did.getDid() + " and Service Agreement " + serviceAgreementId;
                log.error(msg + ": " + e.getMessage());
                throw new ConsumeServiceException(msg, e);
            }
        }
        return true;
    }

    private String buildDestinationPath(String basePath, DID did, int fileIndex, AssetMetadata.File file) {
        String destinationPath = basePath + File.separator + "datafile." + did.getHash() + "." + fileIndex + File.separator;
        destinationPath = null != file.name && !file.name.isEmpty() ? destinationPath + file.name : destinationPath + fileIndex;
        return destinationPath;
    }

    public String generateSignature(String message) throws IOException, CipherException {
        return EncodingHelper.signatureToString((Sign.SignatureData)EthereumHelper.signMessage((String)message, (Credentials)this.getKeeperService().getCredentials()));
    }

    public InputStream consumeBinary(String serviceAgreementId, DID did, int serviceIndex, int fileIndex) throws ConsumeServiceException {
        return this.consumeBinary(serviceAgreementId, did, serviceIndex, fileIndex, false, 0, 0);
    }

    public InputStream consumeBinary(String serviceAgreementId, DID did, int serviceIndex, int fileIndex, Boolean isRangeRequest, Integer rangeStart, Integer rangeEnd) throws ConsumeServiceException {
        Map<String, Object> consumeData = this.fetchAssetDataBeforeConsume(did, serviceIndex);
        String serviceEndpoint = (String)consumeData.get("serviceEndpoint");
        List files = (List)consumeData.get("files");
        String checkConsumerAddress = Keys.toChecksumAddress((String)this.getMainAccount().address);
        String agreementId = EthereumHelper.add0x((String)serviceAgreementId);
        try {
            String signature = this.generateSignature(agreementId);
            log.info("Signature: " + signature);
            return GatewayService.downloadUrl(serviceEndpoint, checkConsumerAddress, agreementId, did.getDid(), fileIndex, signature, isRangeRequest, rangeStart, rangeEnd);
        }
        catch (IOException | CipherException e) {
            String msg = "Error consuming asset with DID " + did.getDid() + " and Service Agreement " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new ConsumeServiceException(msg, e);
        }
    }

    public GatewayService.ServiceExecutionResult executeComputeService(String agreementId, DID did, int index, DID workflowDID) throws ServiceException {
        try {
            String signature;
            DDO ddo = this.resolveDID(did);
            Service service = ddo.getService(index);
            String checkConsumerAddress = Keys.toChecksumAddress((String)this.getMainAccount().address);
            try {
                signature = this.generateSignature(agreementId);
            }
            catch (IOException | CipherException e) {
                String msg = "Unable to generate service agreement signature";
                log.error("Unable to generate service agreement signature: " + e.getMessage());
                throw new ServiceException("Unable to generate service agreement signature", e);
            }
            ExecuteService executeService = new ExecuteService(agreementId, workflowDID.did, checkConsumerAddress, signature);
            GatewayService.ServiceExecutionResult result = GatewayService.initializeServiceExecution(service.serviceEndpoint, executeService);
            if (!result.getOk().booleanValue()) {
                throw new ServiceException("There was a problem initializing the execution of the service. HTTP Code: " + result.getCode());
            }
            return result;
        }
        catch (DDOException e) {
            throw new ServiceException("There was an error resolving the DID ", e);
        }
    }

    public List<ComputeLogs> getComputeLogs(String serviceAgreementId, String executionId, String consumerAddress, ProviderConfig providerConfig) throws ServiceException {
        String signature;
        Object serviceEndpoint = providerConfig.getAccessEndpoint().replace("/access", "/compute/logs/");
        serviceEndpoint = (String)serviceEndpoint + serviceAgreementId + "/" + executionId;
        try {
            signature = this.generateSignature(executionId);
        }
        catch (IOException | CipherException e) {
            log.error("Exception generating signature: ", (Object)e.getMessage());
            throw new ServiceException("Unable to generate signature", e);
        }
        return GatewayService.getComputeLogs((String)serviceEndpoint, Keys.toChecksumAddress((String)consumerAddress), signature);
    }

    public ComputeStatus getComputeStatus(String serviceAgreementId, String executionId, String consumerAddress, ProviderConfig providerConfig) throws ServiceException {
        String signature;
        Object serviceEndpoint = providerConfig.getAccessEndpoint().replace("/access", "/compute/status/");
        serviceEndpoint = (String)serviceEndpoint + serviceAgreementId + "/" + executionId;
        try {
            signature = this.generateSignature(executionId);
        }
        catch (IOException | CipherException e) {
            log.error("Exception generating signature: ", (Object)e.getMessage());
            throw new ServiceException("Unable to generate signature", e);
        }
        return GatewayService.getComputeStatus((String)serviceEndpoint, Keys.toChecksumAddress((String)consumerAddress), signature);
    }

    public Order getOrder(String orderId) {
        return null;
    }

    public List<AssetMetadata> searchOrders() {
        return new ArrayList<AssetMetadata>();
    }
}

