/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.service.Agreement;
import io.keyko.nevermined.models.service.Service;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tuples.generated.Tuple2;
import org.web3j.tuples.generated.Tuple6;

public class ConditionsManager
extends BaseManager {
    private static final Logger log = LogManager.getLogger(ConditionsManager.class);

    public ConditionsManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static ConditionsManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new ConditionsManager(keeperService, metadataApiService);
    }

    public Boolean lockReward(String agreementId, BigInteger amount) throws Exception {
        try {
            this.tokenApprove(this.tokenContract, this.lockRewardCondition.getContractAddress(), amount.toString());
            TransactionReceipt txReceipt = (TransactionReceipt)this.lockRewardCondition.fulfill(EncodingHelper.hexStringToBytes((String)agreementId), Keys.toChecksumAddress((String)this.escrowReward.getContractAddress()), amount).send();
            return txReceipt.isStatusOK();
        }
        catch (TransactionException e) {
            log.error("Error looking reward for the agreement" + agreementId + e.getMessage());
            return false;
        }
    }

    public Boolean grantAccess(String agreementId, DID did, String granteeAddress) throws Exception {
        try {
            TransactionReceipt txReceipt = (TransactionReceipt)this.accessSecretStoreCondition.fulfill(EncodingHelper.hexStringToBytes((String)agreementId), EncodingHelper.hexStringToBytes((String)("0x" + did.getHash())), granteeAddress).send();
            return txReceipt.isStatusOK();
        }
        catch (TransactionException e) {
            log.error("Error granting access to address" + granteeAddress + "to did" + did + e.getMessage());
            return false;
        }
    }

    public Boolean grantCompute(String agreementId, DID did, String granteeAddress) throws Exception {
        try {
            TransactionReceipt txReceipt = (TransactionReceipt)this.computeExecutionCondition.fulfill(EncodingHelper.hexStringToBytes((String)agreementId), EncodingHelper.hexStringToBytes((String)("0x" + did.getHash())), granteeAddress).send();
            return txReceipt.isStatusOK();
        }
        catch (TransactionException e) {
            log.error("Error granting compute to address" + granteeAddress + "to did" + did + e.getMessage());
            return false;
        }
    }

    public Boolean releaseReward(String agreementId, BigInteger amount) throws Exception {
        Agreement agreement = new Agreement((Tuple6)this.agreementStoreManager.getAgreement(EncodingHelper.hexStringToBytes((String)agreementId)).send());
        DDO ddo = this.resolveDID(agreement.did);
        Service service = ddo.getServiceByTemplate(agreement.templateId);
        Tuple2 agreementData = null;
        if (service.type.equals(Service.ServiceTypes.ACCESS.toString())) {
            agreementData = (Tuple2)this.escrowAccessSecretStoreTemplate.getAgreementData(EncodingHelper.hexStringToBytes((String)agreementId)).send();
        } else if (service.type.equals(Service.ServiceTypes.COMPUTE.toString())) {
            agreementData = (Tuple2)this.escrowComputeExecutionTemplate.getAgreementData(EncodingHelper.hexStringToBytes((String)agreementId)).send();
        }
        try {
            TransactionReceipt txReceipt = (TransactionReceipt)this.escrowReward.fulfill(EncodingHelper.hexStringToBytes((String)agreementId), amount, (String)agreementData.component2(), (String)agreementData.component1(), agreement.conditions.get(1), agreement.conditions.get(0)).send();
            return txReceipt.isStatusOK();
        }
        catch (TransactionException e) {
            log.error("Error releasing reward for the agreement" + agreementId + e.getMessage());
            return false;
        }
    }

    public Boolean refundReward(String agreementId, BigInteger amount) throws Exception {
        return this.releaseReward(agreementId, amount);
    }
}

