/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import com.oceanprotocol.secretstore.core.EvmDto;
import com.oceanprotocol.secretstore.core.SecretStoreDto;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.keyko.common.helpers.UrlHelper;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.contracts.AccessSecretStoreCondition;
import io.keyko.nevermined.contracts.AgreementStoreManager;
import io.keyko.nevermined.contracts.ComputeExecutionCondition;
import io.keyko.nevermined.contracts.Condition;
import io.keyko.nevermined.contracts.ConditionStoreManager;
import io.keyko.nevermined.contracts.DIDRegistry;
import io.keyko.nevermined.contracts.Dispenser;
import io.keyko.nevermined.contracts.EscrowAccessSecretStoreTemplate;
import io.keyko.nevermined.contracts.EscrowComputeExecutionTemplate;
import io.keyko.nevermined.contracts.EscrowReward;
import io.keyko.nevermined.contracts.LockRewardCondition;
import io.keyko.nevermined.contracts.NeverminedToken;
import io.keyko.nevermined.contracts.TemplateStoreManager;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.DIDFormatException;
import io.keyko.nevermined.exceptions.EncryptionException;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.exceptions.TokenApproveException;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.SecretStoreManager;
import io.keyko.nevermined.models.Account;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.asset.AssetMetadata;
import io.keyko.nevermined.models.service.types.AuthorizationService;
import io.keyko.nevermined.models.service.types.MetadataService;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public abstract class BaseManager {
    protected static final Logger log = LogManager.getLogger(BaseManager.class);
    private static final int MAX_SS_RETRIES = 10;
    private static final long SS_DECRYPTION_SLEEP = 1000L;
    private KeeperService keeperService;
    private MetadataApiService metadataApiService;
    private SecretStoreDto secretStoreDto;
    private EvmDto evmDto;
    private SecretStoreManager secretStoreManager;
    protected NeverminedToken tokenContract;
    protected Dispenser dispenser;
    protected DIDRegistry didRegistry;
    protected LockRewardCondition lockRewardCondition;
    protected EscrowReward escrowReward;
    protected AccessSecretStoreCondition accessSecretStoreCondition;
    protected TemplateStoreManager templateStoreManager;
    protected EscrowAccessSecretStoreTemplate escrowAccessSecretStoreTemplate;
    protected AgreementStoreManager agreementStoreManager;
    protected ConditionStoreManager conditionStoreManager;
    protected ComputeExecutionCondition computeExecutionCondition;
    protected EscrowComputeExecutionTemplate escrowComputeExecutionTemplate;
    protected Condition condition;
    protected ContractAddresses contractAddresses = new ContractAddresses();
    protected Config config = ConfigFactory.load();
    protected Account mainAccount;
    protected String providerAddress;

    public BaseManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        this.keeperService = keeperService;
        this.metadataApiService = metadataApiService;
    }

    private SecretStoreManager getSecretStoreInstance(AuthorizationService authorizationService) {
        if (authorizationService == null) {
            return this.getSecretStoreManager();
        }
        return SecretStoreManager.getInstance(SecretStoreDto.builder((String)authorizationService.serviceEndpoint), this.evmDto);
    }

    protected DDO buildDDO(MetadataService metadataService, String address) throws DDOException {
        try {
            return new DDO(metadataService, address, "");
        }
        catch (DIDFormatException e) {
            throw new DDOException("Error building DDO", e);
        }
    }

    public List<AssetMetadata.File> getDecriptedSecretStoreMetadataFiles(DDO ddo) throws IOException, EncryptionException, InterruptedException {
        return this.getDecriptedSecretStoreMetadataFiles(ddo, 10);
    }

    public List<AssetMetadata.File> getDecriptedSecretStoreMetadataFiles(DDO ddo, int retries) throws IOException, EncryptionException, InterruptedException {
        AuthorizationService authorizationService = ddo.getAuthorizationService();
        SecretStoreManager secretStoreManager = this.getSecretStoreInstance(authorizationService);
        String jsonFiles = null;
        for (int counter = 0; counter < retries; ++counter) {
            try {
                jsonFiles = secretStoreManager.decryptDocument(ddo.getDid().getHash(), ddo.getMetadataService().attributes.encryptedFiles);
                return DDO.fromJSON(new TypeReference<ArrayList<AssetMetadata.File>>(){}, jsonFiles);
            }
            catch (EncryptionException e) {
                log.warn("Unable to decrypt [" + counter + "]");
                Thread.sleep(1000L);
                continue;
            }
        }
        throw new EncryptionException("Unable to decrypt document after " + retries + " retries");
    }

    public boolean tokenApprove(NeverminedToken tokenContract, String spenderAddress, String price) throws TokenApproveException {
        String checksumAddress = Keys.toChecksumAddress((String)spenderAddress);
        try {
            TransactionReceipt receipt = (TransactionReceipt)tokenContract.approve(checksumAddress, new BigInteger(price)).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing Token Approve: " + receipt.getStatus();
                log.error(msg);
                throw new TokenApproveException(msg);
            }
            log.debug("Token Approve transactionReceipt OK ");
            return true;
        }
        catch (Exception e) {
            String msg = "Error executing Token Approve ";
            log.error(msg + ": " + e.getMessage());
            throw new TokenApproveException(msg, e);
        }
    }

    public DDO resolveDID(DID did) throws DDOException {
        EthFilter didFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.didRegistry.getContractAddress());
        try {
            EthLog ethLog;
            Event event = DIDRegistry.DIDATTRIBUTEREGISTERED_EVENT;
            String eventSignature = EventEncoder.encode((Event)event);
            didFilter.addSingleTopic(eventSignature);
            String didTopic = "0x" + did.getHash();
            didFilter.addOptionalTopics(new String[]{didTopic});
            try {
                ethLog = (EthLog)this.getKeeperService().getWeb3().ethGetLogs(didFilter).send();
            }
            catch (IOException e) {
                throw new EthereumException("Error searching DID " + did.toString() + " onchain: " + e.getMessage());
            }
            List logs = ethLog.getLogs();
            int numLogs = logs.size();
            if (numLogs < 1) {
                throw new DDOException("No events found for " + did.toString());
            }
            EthLog.LogResult logResult = (EthLog.LogResult)logs.get(numLogs - 1);
            List nonIndexed = FunctionReturnDecoder.decode((String)((EthLog.LogObject)logResult).getData(), (List)event.getNonIndexedParameters());
            String didUrl = ((Type)nonIndexed.get(0)).getValue().toString();
            MetadataApiService ddoAquariosDto = MetadataApiService.getInstance(UrlHelper.getBaseUrl((String)didUrl));
            return ddoAquariosDto.getDDO(didUrl);
        }
        catch (Exception ex) {
            log.error("Unable to retrieve DDO " + ex.getMessage());
            throw new DDOException("Unable to retrieve DDO " + ex.getMessage());
        }
    }

    public ContractAddresses getContractAddresses() {
        return this.contractAddresses;
    }

    public KeeperService getKeeperService() {
        return this.keeperService;
    }

    public BaseManager setKeeperService(KeeperService keeperService) {
        this.keeperService = keeperService;
        return this;
    }

    public MetadataApiService getMetadataApiService() {
        return this.metadataApiService;
    }

    public BaseManager setMetadataApiService(MetadataApiService metadataApiService) {
        this.metadataApiService = metadataApiService;
        return this;
    }

    public SecretStoreDto getSecretStoreDto() {
        return this.secretStoreDto;
    }

    public BaseManager setSecretStoreDto(SecretStoreDto secretStoreDto) {
        this.secretStoreDto = secretStoreDto;
        return this;
    }

    public SecretStoreManager getSecretStoreManager() {
        return this.secretStoreManager;
    }

    public BaseManager setSecretStoreManager(SecretStoreManager secretStoreManager) {
        this.secretStoreManager = secretStoreManager;
        return this;
    }

    public EvmDto getEvmDto() {
        return this.evmDto;
    }

    public BaseManager setEvmDto(EvmDto evmDto) {
        this.evmDto = evmDto;
        return this;
    }

    public BaseManager setTokenContract(NeverminedToken contract) {
        this.tokenContract = contract;
        return this;
    }

    public BaseManager setTemplateStoreManagerContract(TemplateStoreManager contract) {
        this.templateStoreManager = contract;
        return this;
    }

    public BaseManager setDispenserContract(Dispenser contract) {
        this.dispenser = contract;
        return this;
    }

    public BaseManager setEscrowAccessSecretStoreTemplate(EscrowAccessSecretStoreTemplate contract) {
        this.escrowAccessSecretStoreTemplate = contract;
        return this;
    }

    public BaseManager setDidRegistryContract(DIDRegistry contract) {
        this.didRegistry = contract;
        return this;
    }

    public BaseManager setAgreementStoreManagerContract(AgreementStoreManager contract) {
        this.agreementStoreManager = contract;
        return this;
    }

    public BaseManager setConditionStoreManagerContract(ConditionStoreManager contract) {
        this.conditionStoreManager = contract;
        return this;
    }

    public LockRewardCondition getLockRewardCondition() {
        return this.lockRewardCondition;
    }

    public BaseManager setLockRewardCondition(LockRewardCondition lockRewardCondition) {
        this.lockRewardCondition = lockRewardCondition;
        return this;
    }

    public EscrowReward getEscrowReward() {
        return this.escrowReward;
    }

    public BaseManager setEscrowReward(EscrowReward escrowReward) {
        this.escrowReward = escrowReward;
        return this;
    }

    public ComputeExecutionCondition getComputeExecutionCondition() {
        return this.computeExecutionCondition;
    }

    public BaseManager setComputeExecutionCondition(ComputeExecutionCondition computeExecutionCondition) {
        this.computeExecutionCondition = computeExecutionCondition;
        return this;
    }

    public EscrowComputeExecutionTemplate getEscrowComputeExecutionTemplate() {
        return this.escrowComputeExecutionTemplate;
    }

    public BaseManager setEscrowComputeExecutionTemplate(EscrowComputeExecutionTemplate escrowComputeExecutionTemplate) {
        this.escrowComputeExecutionTemplate = escrowComputeExecutionTemplate;
        return this;
    }

    public AccessSecretStoreCondition getAccessSecretStoreCondition() {
        return this.accessSecretStoreCondition;
    }

    public BaseManager setAccessSecretStoreCondition(AccessSecretStoreCondition accessSecretStoreCondition) {
        this.accessSecretStoreCondition = accessSecretStoreCondition;
        return this;
    }

    public Account getMainAccount() {
        return this.mainAccount;
    }

    public BaseManager setMainAccount(Account mainAccount) {
        this.mainAccount = mainAccount;
        return this;
    }

    public String getProviderAddress() {
        return this.providerAddress;
    }

    public BaseManager setProviderAddress(String providerAddress) {
        this.providerAddress = providerAddress;
        return this;
    }

    public byte[] getTemplateIdByName(String contractName) {
        return Hash.sha3((byte[])contractName.getBytes());
    }

    public String toString() {
        return "BaseManager{keeperService=" + this.keeperService + ", metadataApiService=" + this.metadataApiService + "}";
    }

    public static class ContractAddresses {
        private String lockRewardConditionAddress;
        private String accessSecretStoreConditionAddress;

        public String getLockRewardConditionAddress() {
            return this.lockRewardConditionAddress;
        }

        public void setLockRewardConditionAddress(String address) {
            this.lockRewardConditionAddress = address;
        }

        public String getAccessSecretStoreConditionAddress() {
            return this.accessSecretStoreConditionAddress;
        }

        public void setAccessSecretStoreConditionAddress(String address) {
            this.accessSecretStoreConditionAddress = address;
        }
    }
}

