/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.contracts.DIDRegistry;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.asset.AssetMetadata;
import io.keyko.nevermined.models.metadata.SearchQuery;
import io.keyko.nevermined.models.metadata.SearchResult;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Event;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class AssetsManager
extends BaseManager {
    public AssetsManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static AssetsManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new AssetsManager(keeperService, metadataApiService);
    }

    public DDO publishMetadata(DDO ddo) throws Exception {
        return this.getMetadataApiService().createDDO(ddo);
    }

    public DDO getByDID(String id) throws Exception {
        return this.getMetadataApiService().getDDOUsingId(id);
    }

    public boolean updateMetadata(String id, DDO ddo) throws Exception {
        return this.getMetadataApiService().updateDDO(id, ddo);
    }

    public SearchResult searchAssets(String text, int offset, int page) throws DDOException {
        return this.getMetadataApiService().searchDDO(text, offset, page);
    }

    public SearchResult searchAssets(Map<String, Object> params, int offset, int page, int sort) throws DDOException {
        SearchQuery searchQuery = new SearchQuery(params, offset, page, sort);
        return this.getMetadataApiService().searchDDO(searchQuery);
    }

    public Boolean deleteAsset(DID did) throws DDOException {
        return this.getMetadataApiService().retireAssetDDO(did.getDid());
    }

    public Boolean validateMetadata(AssetMetadata metadata) throws DDOException {
        return this.getMetadataApiService().validateMetadata(metadata);
    }

    public String getDIDOwner(DID did) throws Exception {
        return Keys.toChecksumAddress((String)((String)this.didRegistry.getDIDOwner(EncodingHelper.hexStringToBytes((String)did.getHash())).send()));
    }

    public List<DID> getOwnerAssets(String ownerAddress) throws ServiceException {
        EthFilter didFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.didRegistry.getContractAddress());
        try {
            EthLog ethLog;
            Event event = DIDRegistry.DIDATTRIBUTEREGISTERED_EVENT;
            String eventSignature = EventEncoder.encode((Event)event);
            didFilter.addSingleTopic(eventSignature);
            didFilter.addNullTopic();
            didFilter.addOptionalTopics(new String[]{Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)ownerAddress), (int)64)});
            try {
                ethLog = (EthLog)this.getKeeperService().getWeb3().ethGetLogs(didFilter).send();
            }
            catch (IOException e) {
                throw new EthereumException("Error creating ownerAssets filter.");
            }
            List logs = ethLog.getLogs();
            ArrayList<DID> DIDlist = new ArrayList<DID>();
            for (int i = 0; i <= logs.size() - 1; ++i) {
                DIDlist.add(DID.getFromHash(Numeric.cleanHexPrefix((String)((String)((EthLog.LogObject)logs.get(i)).getTopics().get(1)))));
            }
            return DIDlist;
        }
        catch (Exception ex) {
            log.error("Unable to retrieve assets owned by " + ownerAddress + ex.getMessage());
            throw new ServiceException("Unable to retrieve assets owned by " + ownerAddress + ex.getMessage());
        }
    }

    public Boolean transferOwnership(DID did, String newOwnerAddress) throws DDOException {
        Boolean isOwner;
        try {
            isOwner = this.getDIDOwner(did).equals(this.getMainAccount().address);
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to check the owner of the DID " + did.getDid(), e);
        }
        if (!isOwner.booleanValue()) {
            throw new DDOException("The main account is not the owner of this DID");
        }
        try {
            TransactionReceipt receipt = (TransactionReceipt)this.didRegistry.transferDIDOwnership(EncodingHelper.hexStringToBytes((String)did.getHash()), Keys.toChecksumAddress((String)newOwnerAddress)).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing DIDRegistry.transferDIDOwnership: " + receipt.getStatus();
                log.error(msg);
                throw new DDOException(msg);
            }
            return true;
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to transfer the ownership of the DID " + did.getDid(), e);
        }
    }

    public Boolean grantPermission(DID did, String subjectAddress) throws DDOException {
        Boolean isOwner;
        try {
            isOwner = this.getDIDOwner(did).equals(this.getMainAccount().address);
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to check the owner of the DID " + did.getDid(), e);
        }
        if (!isOwner.booleanValue()) {
            throw new DDOException("The main account is not the owner of this DID");
        }
        try {
            TransactionReceipt receipt = (TransactionReceipt)this.didRegistry.grantPermission(EncodingHelper.hexStringToBytes((String)did.getHash()), Keys.toChecksumAddress((String)subjectAddress)).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing DIDRegistry.grantPermission: " + receipt.getStatus();
                log.error(msg);
                throw new DDOException(msg);
            }
            return true;
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to grantPermission the Permission for DID " + did.getDid(), e);
        }
    }

    public Boolean revokePermission(DID did, String subjectAddress) throws DDOException {
        Boolean isOwner;
        try {
            isOwner = this.getDIDOwner(did).equals(this.getMainAccount().address);
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to check the owner of the DID " + did.getDid(), e);
        }
        if (!isOwner.booleanValue()) {
            throw new DDOException("The main account is not the owner of this DID");
        }
        try {
            TransactionReceipt receipt = (TransactionReceipt)this.didRegistry.revokePermission(EncodingHelper.hexStringToBytes((String)did.getHash()), Keys.toChecksumAddress((String)subjectAddress)).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing DIDRegistry.revokePermission: " + receipt.getStatus();
                log.error(msg);
                throw new DDOException(msg);
            }
            return true;
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to revoke the Permission for DID " + did.getDid(), e);
        }
    }

    public Boolean getPermission(DID did, String subjectAddress) throws DDOException {
        try {
            return (Boolean)this.didRegistry.getPermission(EncodingHelper.hexStringToBytes((String)did.getHash()), Keys.toChecksumAddress((String)subjectAddress)).send();
        }
        catch (Exception e) {
            throw new DDOException("There was an error trying to transfer the ownership of the DID " + did.getDid(), e);
        }
    }
}

