/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.contracts.AccessSecretStoreCondition;
import io.keyko.nevermined.contracts.ComputeExecutionCondition;
import io.keyko.nevermined.exceptions.ConditionNotFoundException;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.service.Agreement;
import io.keyko.nevermined.models.service.AgreementStatus;
import io.keyko.nevermined.models.service.Condition;
import io.keyko.nevermined.models.service.Service;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Event;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple6;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.utils.Numeric;

public class AgreementsManager
extends BaseManager {
    private static final Logger log = LogManager.getLogger(AgreementsManager.class);

    public AgreementsManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static AgreementsManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new AgreementsManager(keeperService, metadataApiService);
    }

    public Boolean createAccessAgreement(String agreementId, DDO ddo, List<byte[]> conditionIds, String accessConsumer, Service service) throws Exception {
        log.debug("Creating agreement with id: " + agreementId);
        TransactionReceipt txReceipt = (TransactionReceipt)this.escrowAccessSecretStoreTemplate.createAgreement(EncodingHelper.hexStringToBytes((String)("0x" + agreementId)), EncodingHelper.hexStringToBytes((String)("0x" + ddo.getDid().getHash())), conditionIds, service.retrieveTimeOuts(), service.retrieveTimeLocks(), accessConsumer).send();
        return txReceipt.isStatusOK();
    }

    public Boolean createComputeAgreement(String agreementId, DDO ddo, List<byte[]> conditionIds, String accessConsumer, Service service) throws Exception {
        log.debug("Creating agreement with id: " + agreementId);
        TransactionReceipt txReceipt = (TransactionReceipt)this.escrowComputeExecutionTemplate.createAgreement(EncodingHelper.hexStringToBytes((String)("0x" + agreementId)), EncodingHelper.hexStringToBytes((String)("0x" + ddo.getDid().getHash())), conditionIds, service.retrieveTimeOuts(), service.retrieveTimeLocks(), accessConsumer).send();
        return txReceipt.isStatusOK();
    }

    public Agreement getAgreement(String agreementId) throws Exception {
        return new Agreement((Tuple6)this.agreementStoreManager.getAgreement(EncodingHelper.hexStringToBytes((String)agreementId)).send());
    }

    public AgreementStatus getStatus(String agreementId) throws Exception {
        List condition_ids = (List)((Tuple6)this.agreementStoreManager.getAgreement(EncodingHelper.hexStringToBytes((String)agreementId)).send()).component4();
        AgreementStatus agreementStatus = new AgreementStatus();
        agreementStatus.agreementId = agreementId;
        AgreementStatus.ConditionStatusMap condition = new AgreementStatus.ConditionStatusMap();
        for (int i = 0; i <= condition_ids.size() - 1; ++i) {
            Tuple7 agreementCondition = (Tuple7)this.conditionStoreManager.getCondition((byte[])condition_ids.get(i)).send();
            String address = (String)agreementCondition.component1();
            String conditionName = this.getConditionNameByAddress(Keys.toChecksumAddress((String)address));
            BigInteger state = (BigInteger)agreementCondition.component2();
            condition.conditions.put(conditionName, state);
        }
        agreementStatus.conditions.add(condition);
        return agreementStatus;
    }

    private String getConditionNameByAddress(String address) throws Exception {
        if (this.lockRewardCondition.getContractAddress().equals(address)) {
            return Condition.ConditionTypes.lockReward.toString();
        }
        if (this.accessSecretStoreCondition.getContractAddress().equals(address)) {
            return Condition.ConditionTypes.accessSecretStore.toString();
        }
        if (this.escrowReward.getContractAddress().equals(address)) {
            return Condition.ConditionTypes.escrowReward.toString();
        }
        if (this.computeExecutionCondition.getContractAddress().equals(address)) {
            return Condition.ConditionTypes.execCompute.toString();
        }
        log.error("The current address" + address + "is not a condition address.");
        throw new ConditionNotFoundException("The current address" + address + "is not a condition address.");
    }

    private List<DID> getAccessAgreementsFulfilledByConsumer(String consumerAddress) throws ServiceException {
        EthFilter didFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.accessSecretStoreCondition.getContractAddress());
        try {
            EthLog ethLog;
            Event event = AccessSecretStoreCondition.FULFILLED_EVENT;
            String eventSignature = EventEncoder.encode((Event)event);
            didFilter.addSingleTopic(eventSignature);
            didFilter.addNullTopic();
            didFilter.addNullTopic();
            didFilter.addOptionalTopics(new String[]{Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)consumerAddress), (int)64)});
            try {
                ethLog = (EthLog)this.getKeeperService().getWeb3().ethGetLogs(didFilter).send();
            }
            catch (IOException e) {
                throw new EthereumException("Error creating consumedAssets filter.");
            }
            List logs = ethLog.getLogs();
            ArrayList<DID> DIDlist = new ArrayList<DID>();
            for (int i = 0; i <= logs.size() - 1; ++i) {
                DIDlist.add(DID.getFromHash(Numeric.cleanHexPrefix((String)((String)((EthLog.LogObject)logs.get(i)).getTopics().get(2)))));
            }
            return DIDlist;
        }
        catch (Exception ex) {
            log.error("\"Unable to retrieve access agreements fulfilled by " + consumerAddress + ex.getMessage());
            throw new ServiceException("Unable to retrieve access agreements fulfilled by " + consumerAddress + ex.getMessage());
        }
    }

    private List<DID> getComputeAgreementsFulfilledByConsumer(String consumerAddress) throws ServiceException {
        EthFilter didFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.computeExecutionCondition.getContractAddress());
        try {
            EthLog ethLog;
            Event event = ComputeExecutionCondition.FULFILLED_EVENT;
            String eventSignature = EventEncoder.encode((Event)event);
            didFilter.addSingleTopic(eventSignature);
            didFilter.addNullTopic();
            didFilter.addNullTopic();
            didFilter.addOptionalTopics(new String[]{Numeric.toHexStringWithPrefixZeroPadded((BigInteger)Numeric.toBigInt((String)consumerAddress), (int)64)});
            try {
                ethLog = (EthLog)this.getKeeperService().getWeb3().ethGetLogs(didFilter).send();
            }
            catch (IOException e) {
                throw new EthereumException("Error creating consumedAssets filter.");
            }
            List logs = ethLog.getLogs();
            ArrayList<DID> DIDlist = new ArrayList<DID>();
            for (int i = 0; i <= logs.size() - 1; ++i) {
                DIDlist.add(DID.getFromHash(Numeric.cleanHexPrefix((String)((String)((EthLog.LogObject)logs.get(i)).getTopics().get(2)))));
            }
            return DIDlist;
        }
        catch (Exception ex) {
            log.error("Unable to retrieve compute agreements fulfilled by " + consumerAddress + ex.getMessage());
            throw new ServiceException("Unable to retrieve compute agreements fulfilled by " + consumerAddress + ex.getMessage());
        }
    }

    public List<DID> getConsumerAssets(String consumerAddress) throws ServiceException {
        return Stream.concat(this.getAccessAgreementsFulfilledByConsumer(consumerAddress).stream(), this.getComputeAgreementsFulfilledByConsumer(consumerAddress).stream()).collect(Collectors.toList());
    }
}

