/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.manager;

import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.BaseManager;
import io.keyko.nevermined.models.Account;
import io.keyko.nevermined.models.Balance;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthAccounts;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class AccountsManager
extends BaseManager {
    private static final Logger log = LogManager.getLogger(AccountsManager.class);
    private String faucetUrl;

    private AccountsManager(KeeperService keeperService, MetadataApiService metadataApiService) {
        super(keeperService, metadataApiService);
    }

    public static AccountsManager getInstance(KeeperService keeperService, MetadataApiService metadataApiService) {
        return new AccountsManager(keeperService, metadataApiService);
    }

    public List<Account> getAccounts() throws EthereumException {
        try {
            EthAccounts ethAccounts = (EthAccounts)this.getKeeperService().getWeb3().ethAccounts().send();
            ArrayList<Account> accounts = new ArrayList<Account>();
            for (String account : ethAccounts.getAccounts()) {
                accounts.add(new Account(account));
            }
            return accounts;
        }
        catch (IOException e) {
            log.error("Error getting etherum accounts from keeper: " + e.getMessage());
            throw new EthereumException("Error getting etherum accounts from keeper", e);
        }
    }

    public Balance getAccountBalance(String accountAddress) throws EthereumException {
        return new Balance(this.getEthAccountBalance(accountAddress), this.getNeverminedAccountBalance(accountAddress));
    }

    public BigInteger getEthAccountBalance(String accountAddress) throws EthereumException {
        try {
            return ((EthGetBalance)this.getKeeperService().getWeb3().ethGetBalance(accountAddress, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
        }
        catch (Exception ex) {
            String msg = "Unable to get account(" + accountAddress + ") Ocean balance";
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public BigInteger getNeverminedAccountBalance(String accountAddress) throws EthereumException {
        try {
            return (BigInteger)this.tokenContract.balanceOf(accountAddress).send();
        }
        catch (Exception ex) {
            String msg = "Unable to get account(" + accountAddress + ") Ocean balance";
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public TransactionReceipt requestTokens(BigInteger amount) throws EthereumException {
        try {
            return (TransactionReceipt)this.dispenser.requestTokens(amount).send();
        }
        catch (Exception ex) {
            String msg = "Unable request tokens " + amount.toString();
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public TransactionReceipt transfer(String receiverAccount, BigInteger amount) throws EthereumException {
        try {
            return (TransactionReceipt)this.tokenContract.transfer(receiverAccount, amount).send();
        }
        catch (Exception ex) {
            String msg = "Unable transfer tokens " + amount.toString();
            log.error(msg + ": " + ex.getMessage());
            throw new EthereumException(msg, ex);
        }
    }

    public String getFaucetUrl() {
        return this.faucetUrl;
    }

    public AccountsManager setFaucetUrl(String faucetUrl) {
        this.faucetUrl = faucetUrl;
        return this;
    }
}

