/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.external;

import com.fasterxml.jackson.core.type.TypeReference;
import io.keyko.common.helpers.HttpHelper;
import io.keyko.common.models.HttpResponse;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.models.AbstractModel;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.asset.AssetMetadata;
import io.keyko.nevermined.models.metadata.SearchQuery;
import io.keyko.nevermined.models.metadata.SearchResult;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataApiService {
    private static final Logger log = LogManager.getLogger(MetadataApiService.class);
    private static final String DDO_URI = "/api/v1/metadata/assets/ddo";
    private String ddoEndpoint;

    public static MetadataApiService getInstance(String url) {
        log.debug("Getting Metadata API instance: " + url);
        return new MetadataApiService(url);
    }

    private MetadataApiService(String url) {
        String url1 = url.replaceAll("/$", "");
        this.ddoEndpoint = url1 + DDO_URI;
    }

    public String getDdoEndpoint() {
        return this.ddoEndpoint;
    }

    public DDO createDDO(DDO ddo) throws DDOException {
        log.debug("Creating DDO: " + ddo.id);
        try {
            HttpResponse response = HttpHelper.httpClientPost((String)this.ddoEndpoint, new ArrayList(), (String)DDO.cleanFileUrls(ddo).toJson());
            if (response.getStatusCode() != 201) {
                throw new DDOException("Unable to create DDO: " + response.toString());
            }
            return DDO.fromJSON(new TypeReference<DDO>(){}, response.getBody());
        }
        catch (Exception e) {
            throw new DDOException("Error building DDO from JSON", e);
        }
    }

    public DDO getDDO(String url) throws DDOException {
        HttpResponse response;
        log.debug("Getting DDO: " + url);
        try {
            response = HttpHelper.httpClientGet((String)url);
        }
        catch (HttpException e) {
            throw new DDOException("Unable to get DDO", e);
        }
        if (response.getStatusCode() != 200) {
            throw new DDOException("Unable to get DDO: " + response.toString());
        }
        try {
            return DDO.fromJSON(new TypeReference<DDO>(){}, response.getBody());
        }
        catch (Exception e) {
            throw new DDOException("Error building DDO from JSON", e);
        }
    }

    public DDO getDDOUsingId(String id) throws Exception {
        return this.getDDO(this.ddoEndpoint + "/" + id);
    }

    public boolean updateDDO(String id, DDO ddo) throws Exception {
        HttpResponse response = HttpHelper.httpClientPut((String)(this.ddoEndpoint + "/" + id), new ArrayList(), (String)ddo.toJson());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
            return true;
        }
        throw new Exception("Unable to update DDO: " + response.toString());
    }

    public SearchResult searchDDO(String param, int offset, int page) throws DDOException {
        HttpResponse response;
        String url = this.ddoEndpoint + "/query?text=" + param + "&page=" + page + "&offset=" + offset;
        try {
            response = HttpHelper.httpClientGet((String)url);
        }
        catch (HttpException e) {
            throw new DDOException("Unable to get DDO: ", e);
        }
        if (response.getStatusCode() != 200) {
            throw new DDOException("Unable to search for DDO's: " + response.toString());
        }
        try {
            return (SearchResult)AbstractModel.getMapperInstance().readValue(response.getBody(), (TypeReference)new TypeReference<SearchResult>(){});
        }
        catch (IOException e) {
            throw new DDOException("Unable to search for DDO's: ", e);
        }
    }

    public SearchResult searchDDO(SearchQuery searchQuery) throws DDOException {
        HttpResponse response;
        try {
            response = HttpHelper.httpClientPost((String)(this.ddoEndpoint + "/query"), new ArrayList(), (String)searchQuery.toJson());
        }
        catch (Exception e) {
            throw new DDOException("Unable to get DDO", e);
        }
        if (response.getStatusCode() != 200) {
            throw new DDOException("Unable to search for DDO's: " + response.toString());
        }
        try {
            return (SearchResult)AbstractModel.getMapperInstance().readValue(response.getBody(), (TypeReference)new TypeReference<SearchResult>(){});
        }
        catch (IOException e) {
            throw new DDOException("Unable to search for DDO's", e);
        }
    }

    public boolean retireAssetDDO(String id) throws DDOException {
        HttpResponse response;
        try {
            response = HttpHelper.httpClientDelete((String)(this.ddoEndpoint + "/" + id));
        }
        catch (Exception e) {
            throw new DDOException("Unable to retire DDO with DID: " + id, e);
        }
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
            return true;
        }
        throw new DDOException("Unable to retire DDO with DID: " + id);
    }

    public boolean validateMetadata(AssetMetadata metadata) throws DDOException {
        HttpResponse response;
        try {
            response = HttpHelper.httpClientPost((String)(this.ddoEndpoint + "/validate"), new ArrayList(), (String)metadata.toJson());
        }
        catch (Exception e) {
            throw new DDOException("Unable to call the validate endpoint", e);
        }
        return response.getBody().contains("true");
    }
}

