/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.external;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.keyko.common.helpers.HttpHelper;
import io.keyko.common.helpers.StringsHelper;
import io.keyko.common.models.HttpResponse;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.models.AbstractModel;
import io.keyko.nevermined.models.gateway.ComputeLogs;
import io.keyko.nevermined.models.gateway.ComputeStatus;
import io.keyko.nevermined.models.gateway.EncryptionRequest;
import io.keyko.nevermined.models.gateway.EncryptionResponse;
import io.keyko.nevermined.models.gateway.ExecuteService;
import io.keyko.nevermined.models.gateway.InitializeAccessSLA;
import io.keyko.nevermined.models.gateway.Status;
import io.keyko.nevermined.models.service.types.AuthorizationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GatewayService {
    private static final Logger log = LogManager.getLogger(GatewayService.class);
    private static final String ENCRYPT_URI = "/api/v1/gateway/services/encrypt";
    private static final String HEADER_CONSUMER_ADDRESS = "X-Consumer-Address";
    private static final String HEADER_SIGNATURE = "X-Signature";
    private static final String HEADER_DID = "X-DID";
    private static final String HEADER_WORKFLOW_DID = "X-Workflow-DID";

    @Deprecated
    public static ServiceAgreementResult initializeAccessServiceAgreement(String url, InitializeAccessSLA payload) {
        log.debug("Initializing SLA[" + payload.serviceAgreementId + "]: " + url);
        ServiceAgreementResult result = new ServiceAgreementResult();
        try {
            String payloadJson = payload.toJson();
            log.debug(payloadJson);
            HttpResponse response = HttpHelper.httpClientPost((String)url, new ArrayList(), (String)payloadJson);
            result.setCode(response.getStatusCode());
            if (response.getStatusCode() != 201) {
                log.debug("Unable to Initialize SLA: " + response.toString());
                result.setOk(false);
                return result;
            }
        }
        catch (Exception e) {
            log.error("Exception Initializing SLA: " + e.getMessage());
            result.setOk(false);
            return result;
        }
        result.setOk(true);
        return result;
    }

    public static HttpHelper.DownloadResult consumeUrl(String serviceEndpoint, String consumerAddress, String serviceAgreementId, String url, String destinationPath) throws IOException, URISyntaxException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("consumerAddress", consumerAddress);
        parameters.put("serviceAgreementId", serviceAgreementId);
        parameters.put("url", url);
        String endpoint = StringsHelper.formUrl((String)serviceEndpoint, parameters);
        log.debug("Consuming URL[" + url + "]: for service Agreement " + serviceAgreementId);
        return HttpHelper.downloadResource((String)endpoint, (String)destinationPath);
    }

    public static void downloadUrl(String serviceEndpoint, String consumerAddress, String serviceAgreementId, String url, String destinationPath) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("consumerAddress", consumerAddress);
        parameters.put("serviceAgreementId", serviceAgreementId);
        parameters.put("url", url);
        String endpoint = StringsHelper.formUrl((String)serviceEndpoint, parameters);
        log.debug("Consuming URL[" + url + "]: for service Agreement " + serviceAgreementId);
        HttpHelper.download((String)endpoint, (String)destinationPath);
    }

    public static InputStream downloadUrl(String serviceEndpoint, String consumerAddress, String serviceAgreementId, String did, int index, String signature, Boolean isRangeRequest, Integer startRange, Integer endRange) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONSUMER_ADDRESS, consumerAddress);
        headers.put(HEADER_DID, did);
        headers.put(HEADER_SIGNATURE, signature);
        String endpoint = serviceEndpoint + "/" + serviceAgreementId + "/" + index;
        log.debug("Downloading from URL[" + endpoint + "]: for service Agreement " + serviceAgreementId);
        return HttpHelper.download((String)endpoint, headers, (Boolean)isRangeRequest, (Integer)startRange, (Integer)endRange);
    }

    public static InputStream downloadUrlByOwner(String serviceEndpoint, String consumerAddress, String did, int index, String signature, Boolean isRangeRequest, Integer startRange, Integer endRange) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONSUMER_ADDRESS, consumerAddress);
        headers.put(HEADER_DID, did);
        headers.put(HEADER_SIGNATURE, signature);
        String endpoint = serviceEndpoint + "/" + index;
        log.debug("Owner downloading from URL[" + endpoint + "]");
        return HttpHelper.download((String)endpoint, headers, (Boolean)isRangeRequest, (Integer)startRange, (Integer)endRange);
    }

    public static void downloadToPath(String serviceEndpoint, String consumerAddress, String serviceAgreementId, String did, int index, String signature, String destinationPath, Boolean isRangeRequest, Integer startRange, Integer endRange) throws IOException {
        InputStream inputStream = GatewayService.downloadUrl(serviceEndpoint, consumerAddress, serviceAgreementId, did, index, signature, isRangeRequest, startRange, endRange);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)new File(destinationPath));
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
    }

    public static void downloadToPathByOwner(String serviceEndpoint, String consumerAddress, String did, int index, String signature, String destinationPath, Boolean isRangeRequest, Integer startRange, Integer endRange) throws IOException {
        InputStream inputStream = GatewayService.downloadUrlByOwner(serviceEndpoint, consumerAddress, did, index, signature, isRangeRequest, startRange, endRange);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)new File(destinationPath));
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
    }

    public static Status getStatus(String serviceEndpoint) throws IOException {
        log.debug("Getting Gateway Status");
        try {
            HttpResponse httpResponse = HttpHelper.httpClientGet((String)serviceEndpoint);
            if (httpResponse.getStatusCode() != 200) {
                throw new IOException("Invalid http response from Gateway: " + httpResponse.getStatusCode());
            }
            return Status.fromJSON(new TypeReference<Status>(){}, httpResponse.getBody());
        }
        catch (HttpException e) {
            throw new IOException("Unable to fetch status page", e);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse status page from gateway", e);
        }
    }

    public static EncryptionResponse encrypt(String gatewayUrl, String message, AuthorizationService.AuthTypes authType) throws ServiceException {
        return GatewayService.encrypt(gatewayUrl, message, authType, null);
    }

    public static EncryptionResponse encrypt(String gatewayUrl, String message, AuthorizationService.AuthTypes authType, String did) throws ServiceException {
        log.debug("Encrypting message using " + authType.name());
        EncryptionRequest encryptionReq = new EncryptionRequest(message, authType.getName());
        String endpoint = gatewayUrl + ENCRYPT_URI;
        if (authType.equals((Object)AuthorizationService.AuthTypes.SECRET_STORE) && !did.isEmpty()) {
            encryptionReq.did = did;
        }
        try {
            String payloadJson = encryptionReq.toJson();
            HttpResponse response = HttpHelper.httpClientPost((String)endpoint, new ArrayList(), (String)payloadJson);
            if (response.getStatusCode() != 200) {
                log.error("Unable to Encrypt Message: " + response.toString());
                throw new ServiceException("Unable to Encrypt Message");
            }
            return EncryptionResponse.fromJSON(new TypeReference<EncryptionResponse>(){}, response.getBody());
        }
        catch (Exception e) {
            log.error("Error encrypting message: " + e.getMessage());
            throw new ServiceException("Error Encrypting Message: " + e.getMessage());
        }
    }

    public static ServiceExecutionResult initializeServiceExecution(String serviceEndpoint, ExecuteService executeService) {
        log.debug("Initializing Execution of Service. Agreement Id: [" + executeService.agreementId + "]: " + serviceEndpoint);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONSUMER_ADDRESS, executeService.consumerAddress);
        headers.put(HEADER_WORKFLOW_DID, executeService.workflowId);
        headers.put(HEADER_SIGNATURE, executeService.signature);
        String endpoint = serviceEndpoint + "/" + executeService.agreementId;
        ServiceExecutionResult result = new ServiceExecutionResult();
        try {
            HttpResponse response = HttpHelper.httpClientPost((String)endpoint, headers);
            result.setCode(response.getStatusCode());
            if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
                log.debug("Unable to Initialize Execution of the Service: " + response.toString());
                result.setOk(false);
                return result;
            }
            result.setOk(true);
            result.setExecutionId(GatewayService.getExecutionId(response.getBody()));
            return result;
        }
        catch (Exception e) {
            log.error("Exception Initializing Execution of the Service: " + e.getMessage());
            result.setOk(false);
            return result;
        }
    }

    private static String getExecutionId(String bodyResponse) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map responseMap = (Map)mapper.readValue(bodyResponse, (TypeReference)new TypeReference<Map<String, String>>(){});
        return (String)responseMap.get("workflowId");
    }

    public static List<ComputeLogs> getComputeLogs(String serviceEndpoint, String consumerAddress, String signature) throws ServiceException {
        List<ComputeLogs> logs;
        HttpResponse response;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONSUMER_ADDRESS, consumerAddress);
        headers.put(HEADER_SIGNATURE, signature);
        try {
            response = HttpHelper.httpClientGet((String)serviceEndpoint, headers);
        }
        catch (HttpException e) {
            log.error("Exception getting the compute logs: " + e.getMessage());
            throw new ServiceException("Exception getting the compute logs", e);
        }
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            log.error("Unable to get the compute logs: " + response.toString());
            throw new ServiceException("Unable to get logs: " + response.toString());
        }
        try {
            logs = ComputeLogs.fromJSON(new TypeReference<List<ComputeLogs>>(){}, response.getBody());
        }
        catch (IOException e) {
            log.error("Exception parsing the compute logs: " + e.getMessage());
            throw new ServiceException("Unable to parse logs", e);
        }
        return logs;
    }

    public static ComputeStatus getComputeStatus(String serviceEndpoint, String consumerAddress, String signature) throws ServiceException {
        ComputeStatus computeStatus;
        HttpResponse response;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_CONSUMER_ADDRESS, consumerAddress);
        headers.put(HEADER_SIGNATURE, signature);
        try {
            response = HttpHelper.httpClientGet((String)serviceEndpoint, headers);
        }
        catch (HttpException e) {
            log.error("Exception getting the compute status: " + e.getMessage());
            throw new ServiceException("Exception getting the compute status", e);
        }
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            log.error("Unable to get the compute status: " + response.toString());
            throw new ServiceException("Unable to get compute status: " + response.toString());
        }
        try {
            computeStatus = ComputeStatus.fromJSON(new TypeReference<ComputeStatus>(){}, response.getBody());
        }
        catch (IOException e) {
            log.error("Exception parsing the compute status: " + e.getMessage());
            throw new ServiceException("Unable to parse status", e);
        }
        return computeStatus;
    }

    public static class ServiceExecutionResult
    extends AbstractModel {
        private Boolean ok;
        private String workflowId;
        private Integer code;

        public Boolean getOk() {
            return this.ok;
        }

        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getExecutionId() {
            return this.workflowId;
        }

        public void setExecutionId(String executionId) {
            this.workflowId = executionId;
        }
    }

    public static class ServiceAgreementResult {
        private Boolean ok;
        private Integer code;

        public Boolean getOk() {
            return this.ok;
        }

        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }
    }
}

