/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.external;

import com.fasterxml.jackson.core.type.TypeReference;
import io.keyko.common.helpers.HttpHelper;
import io.keyko.common.models.HttpResponse;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.models.faucet.FaucetRequest;
import io.keyko.nevermined.models.faucet.FaucetResponse;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FaucetService {
    private static final Logger log = LogManager.getLogger(FaucetService.class);
    private static final String FAUCET_URI = "/faucet";

    public static FaucetResponse requestEthFromFaucet(String faucetUrl, String address) throws ServiceException {
        try {
            FaucetRequest faucetRequest = new FaucetRequest(address);
            HttpResponse response = HttpHelper.httpClientPost((String)(faucetUrl + FAUCET_URI), new ArrayList(), (String)faucetRequest.toJson());
            if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
                log.warn("Error getting funds from faucet " + response.getBody());
            }
            return FaucetResponse.fromJSON(new TypeReference<FaucetResponse>(){}, response.getBody());
        }
        catch (Exception ex) {
            String msg = "Error requesting eth from faucet for address " + address;
            log.error(msg + ": " + ex.getMessage());
            throw new ServiceException("Exception getting ETH from faucet: " + ex.getMessage());
        }
    }
}

