/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.core.sla.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import io.keyko.common.helpers.CryptoHelper;
import io.keyko.common.helpers.EncodingHelper;
import io.keyko.nevermined.contracts.AccessSecretStoreCondition;
import io.keyko.nevermined.contracts.ComputeExecutionCondition;
import io.keyko.nevermined.contracts.EscrowAccessSecretStoreTemplate;
import io.keyko.nevermined.contracts.EscrowComputeExecutionTemplate;
import io.keyko.nevermined.exceptions.InitializeConditionsException;
import io.keyko.nevermined.models.AbstractModel;
import io.keyko.nevermined.models.service.Condition;
import io.reactivex.Flowable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Event;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.EthFilter;

public abstract class ServiceAgreementHandler {
    private static final Logger log = LogManager.getLogger(ServiceAgreementHandler.class);
    private String conditionsTemplate = null;

    public static String generateSlaId() {
        String token = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        return token.replaceAll("-", "");
    }

    public static Flowable<String> listenExecuteAgreement(EscrowAccessSecretStoreTemplate slaContract, String serviceAgreementId) {
        EthFilter slaFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, slaContract.getContractAddress());
        Event event = EscrowAccessSecretStoreTemplate.AGREEMENTCREATED_EVENT;
        String eventSignature = EventEncoder.encode((Event)event);
        String slaTopic = "0x" + serviceAgreementId;
        slaFilter.addSingleTopic(eventSignature);
        slaFilter.addOptionalTopics(new String[]{slaTopic});
        return slaContract.agreementCreatedEventFlowable(slaFilter).map(eventResponse -> EncodingHelper.toHexString((byte[])eventResponse._agreementId));
    }

    public static Flowable<String> listenExecuteAgreement(EscrowComputeExecutionTemplate slaContract, String serviceAgreementId) {
        EthFilter slaFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, slaContract.getContractAddress());
        Event event = EscrowComputeExecutionTemplate.AGREEMENTCREATED_EVENT;
        String eventSignature = EventEncoder.encode((Event)event);
        String slaTopic = "0x" + serviceAgreementId;
        slaFilter.addSingleTopic(eventSignature);
        slaFilter.addOptionalTopics(new String[]{slaTopic});
        return slaContract.agreementCreatedEventFlowable(slaFilter).map(eventResponse -> EncodingHelper.toHexString((byte[])eventResponse._agreementId));
    }

    public static Flowable<String> listenForFulfilledEvent(AccessSecretStoreCondition accessCondition, String serviceAgreementId) {
        EthFilter grantedFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, accessCondition.getContractAddress());
        Event event = AccessSecretStoreCondition.FULFILLED_EVENT;
        String eventSignature = EventEncoder.encode((Event)event);
        String slaTopic = "0x" + serviceAgreementId;
        grantedFilter.addSingleTopic(eventSignature);
        grantedFilter.addOptionalTopics(new String[]{slaTopic});
        return accessCondition.fulfilledEventFlowable(grantedFilter).map(eventResponse -> EncodingHelper.toHexString((byte[])eventResponse._agreementId));
    }

    public static Flowable<String> listenForFulfilledEvent(ComputeExecutionCondition computeCondition, String serviceAgreementId) {
        EthFilter grantedFilter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, computeCondition.getContractAddress());
        Event event = ComputeExecutionCondition.FULFILLED_EVENT;
        String eventSignature = EventEncoder.encode((Event)event);
        String slaTopic = "0x" + serviceAgreementId;
        grantedFilter.addSingleTopic(eventSignature);
        grantedFilter.addOptionalTopics(new String[]{slaTopic});
        return computeCondition.fulfilledEventFlowable(grantedFilter).map(eventResponse -> EncodingHelper.toHexString((byte[])eventResponse._agreementId));
    }

    public abstract String getConditionFileTemplate();

    public List<Condition> initializeConditions(Map<String, Object> params) throws InitializeConditionsException {
        try {
            this.conditionsTemplate = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("sla/" + this.getConditionFileTemplate()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.conditionsTemplate == null) {
                this.conditionsTemplate = new String(Files.readAllBytes(Paths.get("src/main/resources/sla/" + this.getConditionFileTemplate(), new String[0])));
            }
            params.forEach((_name, _func) -> {
                this.conditionsTemplate = _func instanceof byte[] ? this.conditionsTemplate.replaceAll("\\{" + _name + "\\}", CryptoHelper.getHex((byte[])((byte[])_func))) : this.conditionsTemplate.replaceAll("\\{" + _name + "\\}", _func.toString());
            });
            return (List)AbstractModel.getMapperInstance().readValue(this.conditionsTemplate, (TypeReference)new TypeReference<List<Condition>>(){});
        }
        catch (Exception e) {
            String msg = "Error initializing conditions for template";
            log.error(msg);
            throw new InitializeConditionsException(msg, e);
        }
    }
}

