/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.core.sla.functions;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.nevermined.contracts.LockRewardCondition;
import io.keyko.nevermined.exceptions.LockRewardFulfillException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class FulfillLockReward {
    private static final Logger log = LogManager.getLogger(FulfillLockReward.class);

    public static Boolean executeFulfill(LockRewardCondition lockRewardCondition, String serviceAgreementId, String escrowRewardAddress, String price) throws LockRewardFulfillException {
        try {
            String escrowRewardAddressChecksum = Keys.toChecksumAddress((String)escrowRewardAddress);
            byte[] serviceId = EncodingHelper.hexStringToBytes((String)serviceAgreementId);
            log.debug("service Agreement String: " + serviceAgreementId);
            log.debug("serviceID Bytes:" + serviceId);
            log.debug("EscrowRewardAddress: " + escrowRewardAddressChecksum);
            log.debug("Price: " + price);
            TransactionReceipt receipt = (TransactionReceipt)lockRewardCondition.fulfill(serviceId, escrowRewardAddressChecksum, new BigInteger(price)).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing LockRewardCondition.Fulfill: " + receipt.getStatus() + " for serviceAgreement " + serviceAgreementId;
                log.error(msg);
                throw new LockRewardFulfillException(msg);
            }
            log.debug("LockRewardCondition.Fulfill transactionReceipt OK for serviceAgreement " + serviceAgreementId);
            return true;
        }
        catch (Exception e) {
            String msg = "Error executing LockRewardCondition.Fulfill for serviceAgreement " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new LockRewardFulfillException(msg, e);
        }
    }
}

