/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.core.sla.functions;

import io.keyko.common.helpers.EncodingHelper;
import io.keyko.nevermined.contracts.EscrowReward;
import io.keyko.nevermined.exceptions.EscrowRewardException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Keys;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class FulfillEscrowReward {
    private static final Logger log = LogManager.getLogger(FulfillEscrowReward.class);

    public static Boolean executeFulfill(EscrowReward escrowReward, String serviceAgreementId, String lockRewardAddress, String price, String consumerAddress, String lockConditionId, String releaseConditionId) throws EscrowRewardException {
        try {
            String lockRewardAddressChecksum = Keys.toChecksumAddress((String)lockRewardAddress);
            byte[] serviceId = EncodingHelper.hexStringToBytes((String)serviceAgreementId);
            byte[] lockConditionIdBytes = EncodingHelper.hexStringToBytes((String)lockConditionId);
            byte[] releaseConditionIdBytes = EncodingHelper.hexStringToBytes((String)releaseConditionId);
            TransactionReceipt receipt = (TransactionReceipt)escrowReward.fulfill(serviceId, new BigInteger(price), lockRewardAddressChecksum, consumerAddress, lockConditionIdBytes, releaseConditionIdBytes).send();
            if (!receipt.getStatus().equals("0x1")) {
                String msg = "The Status received is not valid executing EscrowReward.Fulfill: " + receipt.getStatus() + " for serviceAgreement " + serviceAgreementId;
                log.error(msg);
                throw new EscrowRewardException(msg);
            }
            log.debug("EscrowReward.Fulfill transactionReceipt OK for serviceAgreement " + serviceAgreementId);
            return true;
        }
        catch (Exception e) {
            String msg = "Error executing EscrowReward.Fulfill for serviceAgreement " + serviceAgreementId;
            log.error(msg + ": " + e.getMessage());
            throw new EscrowRewardException(msg, e);
        }
    }
}

