/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api.impl;

import io.keyko.nevermined.api.TemplatesAPI;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.manager.TemplatesManager;
import io.keyko.nevermined.models.service.template.TemplateSEA;
import java.math.BigInteger;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class TemplatesImpl
implements TemplatesAPI {
    private TemplatesManager templatesManager;

    public TemplatesImpl(TemplatesManager templatesManager) {
        this.templatesManager = templatesManager;
    }

    @Override
    public TransactionReceipt propose(String templateAddress) throws EthereumException {
        return this.templatesManager.proposeTemplate(templateAddress);
    }

    @Override
    public TransactionReceipt approve(String templateAddress) throws EthereumException {
        return this.templatesManager.approveTemplate(templateAddress);
    }

    @Override
    public TransactionReceipt revoke(String templateAddress) throws EthereumException {
        return this.templatesManager.revokeTemplate(templateAddress);
    }

    @Override
    public boolean isApproved(String templateAddress) throws EthereumException {
        return this.templatesManager.isTemplateApproved(templateAddress);
    }

    @Override
    public BigInteger getListSize() throws EthereumException {
        return this.templatesManager.getTemplateListSize();
    }

    @Override
    public TemplateSEA getTemplate(String templateAddress) throws EthereumException {
        return this.templatesManager.getTemplate(templateAddress);
    }
}

