/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api.impl;

import io.keyko.nevermined.api.AssetsAPI;
import io.keyko.nevermined.exceptions.ConsumeServiceException;
import io.keyko.nevermined.exceptions.DDOException;
import io.keyko.nevermined.exceptions.EscrowRewardException;
import io.keyko.nevermined.exceptions.OrderException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.external.GatewayService;
import io.keyko.nevermined.manager.AgreementsManager;
import io.keyko.nevermined.manager.AssetsManager;
import io.keyko.nevermined.manager.NeverminedManager;
import io.keyko.nevermined.models.DDO;
import io.keyko.nevermined.models.DID;
import io.keyko.nevermined.models.asset.AssetMetadata;
import io.keyko.nevermined.models.asset.OrderResult;
import io.keyko.nevermined.models.gateway.ComputeLogs;
import io.keyko.nevermined.models.gateway.ComputeStatus;
import io.keyko.nevermined.models.metadata.SearchResult;
import io.keyko.nevermined.models.service.AuthConfig;
import io.keyko.nevermined.models.service.ProviderConfig;
import io.keyko.nevermined.models.service.Service;
import io.keyko.nevermined.models.service.types.ComputingService;
import io.reactivex.Flowable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class AssetsImpl
implements AssetsAPI {
    private NeverminedManager neverminedManager;
    private AssetsManager assetsManager;
    private AgreementsManager agreementsManager;
    private static final int DEFAULT_OFFSET = 20;
    private static final int DEFAULT_PAGE = 1;

    public AssetsImpl(NeverminedManager neverminedManager, AssetsManager assetsManager, AgreementsManager agreementsManager) {
        this.neverminedManager = neverminedManager;
        this.assetsManager = assetsManager;
        this.agreementsManager = agreementsManager;
    }

    @Override
    public DDO create(AssetMetadata metadata, ProviderConfig providerConfig, AuthConfig authConfig) throws DDOException {
        return this.neverminedManager.registerAccessServiceAsset(metadata, providerConfig, authConfig);
    }

    @Override
    public DDO create(AssetMetadata metadata, ProviderConfig providerConfig) throws DDOException {
        return this.create(metadata, providerConfig, new AuthConfig(providerConfig.getGatewayUrl()));
    }

    @Override
    public DDO createComputeService(AssetMetadata metadata, ProviderConfig providerConfig) throws DDOException {
        return this.neverminedManager.registerComputeService(metadata, providerConfig, new ComputingService.Provider());
    }

    @Override
    public DDO createComputeService(AssetMetadata metadata, ProviderConfig providerConfig, ComputingService.Provider computingProvider) throws DDOException {
        return this.neverminedManager.registerComputeService(metadata, providerConfig, computingProvider);
    }

    @Override
    public List<ComputeLogs> getComputeLogs(String serviceAgreementId, String executionId, String consumerAddress, ProviderConfig providerConfig) throws ServiceException {
        return this.neverminedManager.getComputeLogs(serviceAgreementId, executionId, consumerAddress, providerConfig);
    }

    @Override
    public ComputeStatus getComputeStatus(String serviceAgreementId, String executionId, String consumerAddress, ProviderConfig providerConfig) throws ServiceException {
        return this.neverminedManager.getComputeStatus(serviceAgreementId, executionId, consumerAddress, providerConfig);
    }

    @Override
    public DDO resolve(DID did) throws DDOException {
        return this.neverminedManager.resolveDID(did);
    }

    @Override
    public List<AssetMetadata.File> getMetadataFiles(DID did) throws DDOException {
        try {
            DDO ddo = this.resolve(did);
            return this.neverminedManager.getDecriptedSecretStoreMetadataFiles(ddo);
        }
        catch (Exception e) {
            throw new DDOException("Error trying to get the files of the DDO", e);
        }
    }

    @Override
    public SearchResult search(String text) throws DDOException {
        return this.search(text, 20, 1);
    }

    @Override
    public SearchResult search(String text, int offset, int page) throws DDOException {
        return this.assetsManager.searchAssets(text, offset, page);
    }

    @Override
    public SearchResult query(Map<String, Object> params, int offset, int page, int sort) throws DDOException {
        return this.assetsManager.searchAssets(params, offset, page, sort);
    }

    @Override
    public SearchResult query(Map<String, Object> params) throws DDOException {
        return this.query(params, 20, 1, 1);
    }

    @Override
    public Boolean consume(String serviceAgreementId, DID did, int serviceDefinitionId, String basePath) throws ConsumeServiceException {
        return this.neverminedManager.access(serviceAgreementId, did, serviceDefinitionId, basePath);
    }

    @Override
    public Boolean consume(String serviceAgreementId, DID did, int serviceDefinitionId, int fileIndex, String basePath) throws ConsumeServiceException {
        return this.neverminedManager.access(serviceAgreementId, did, serviceDefinitionId, fileIndex, basePath);
    }

    @Override
    public InputStream consumeBinary(String serviceAgreementId, DID did, int serviceDefinitionId) throws ConsumeServiceException {
        return this.consumeBinary(serviceAgreementId, did, serviceDefinitionId, 0);
    }

    @Override
    public InputStream consumeBinary(String serviceAgreementId, DID did, int serviceDefinitionId, int fileIndex) throws ConsumeServiceException {
        return this.neverminedManager.consumeBinary(serviceAgreementId, did, serviceDefinitionId, fileIndex);
    }

    @Override
    public InputStream consumeBinary(String serviceAgreementId, DID did, int serviceDefinitionId, int fileIndex, int rangeStart, int rangeEnd) throws ConsumeServiceException {
        return this.neverminedManager.consumeBinary(serviceAgreementId, did, serviceDefinitionId, fileIndex, true, rangeStart, rangeEnd);
    }

    @Override
    public Boolean ownerDownload(DID did, int serviceIndex, String basePath) throws ServiceException, ConsumeServiceException {
        return this.neverminedManager.downloadAssetByOwner(did, serviceIndex, basePath);
    }

    public Boolean ownerDownload(DID did, int serviceIndex, String basePath, int fileIndex) throws ServiceException, ConsumeServiceException {
        return this.neverminedManager.downloadAssetByOwner(did, serviceIndex, basePath, fileIndex);
    }

    @Override
    public Flowable<OrderResult> order(DID did, int serviceDefinitionId) throws OrderException {
        return this.neverminedManager.purchaseAssetFlowable(did, serviceDefinitionId);
    }

    @Override
    public OrderResult orderDirect(DID did) throws OrderException, ServiceException, EscrowRewardException {
        return this.neverminedManager.purchaseAssetDirect(did);
    }

    @Override
    public OrderResult orderDirect(DID did, Service.ServiceTypes serviceTypes) throws OrderException, ServiceException, EscrowRewardException {
        return this.neverminedManager.purchaseAssetDirect(did, serviceTypes);
    }

    @Override
    public OrderResult orderDirect(DID did, int serviceDefinitionId, Service.ServiceTypes serviceTypes) throws OrderException, ServiceException, EscrowRewardException {
        return this.neverminedManager.purchaseAssetDirect(did, serviceDefinitionId, serviceTypes);
    }

    @Override
    public OrderResult orderDirect(DID did, int serviceDefinitionId) throws OrderException, ServiceException, EscrowRewardException {
        return this.neverminedManager.purchaseAssetDirect(did, serviceDefinitionId);
    }

    @Override
    public Boolean retire(DID did) throws DDOException {
        return this.assetsManager.deleteAsset(did);
    }

    @Override
    public List<DID> ownerAssets(String ownerAddress) throws ServiceException {
        return this.assetsManager.getOwnerAssets(ownerAddress);
    }

    @Override
    public List<DID> consumerAssets(String consumerAddress) throws ServiceException {
        return this.agreementsManager.getConsumerAssets(consumerAddress);
    }

    @Override
    public GatewayService.ServiceExecutionResult execute(String agreementId, DID did, int index, DID workflowDID) throws ServiceException {
        return this.neverminedManager.executeComputeService(agreementId, did, index, workflowDID);
    }

    @Override
    public String owner(DID did) throws Exception {
        return this.assetsManager.getDIDOwner(did);
    }

    @Override
    public Boolean validate(AssetMetadata metadata) throws DDOException {
        return this.assetsManager.validateMetadata(metadata);
    }

    @Override
    public Boolean transferOwnership(DID did, String newOwnerAddress) throws DDOException {
        return this.assetsManager.transferOwnership(did, newOwnerAddress);
    }

    @Override
    public Boolean delegatePermissions(DID did, String subjectAddress) throws DDOException {
        return this.assetsManager.grantPermission(did, subjectAddress);
    }

    @Override
    public Boolean revokePermissions(DID did, String subjectAddress) throws DDOException {
        return this.assetsManager.revokePermission(did, subjectAddress);
    }

    @Override
    public Boolean getPermissions(DID did, String subjectAddress) throws DDOException {
        return this.assetsManager.getPermission(did, subjectAddress);
    }
}

