/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api.impl;

import io.keyko.nevermined.api.AccountsAPI;
import io.keyko.nevermined.exceptions.EthereumException;
import io.keyko.nevermined.exceptions.ServiceException;
import io.keyko.nevermined.external.FaucetService;
import io.keyko.nevermined.manager.AccountsManager;
import io.keyko.nevermined.models.Account;
import io.keyko.nevermined.models.Balance;
import io.keyko.nevermined.models.faucet.FaucetResponse;
import java.math.BigInteger;
import java.util.List;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class AccountsImpl
implements AccountsAPI {
    private AccountsManager accountsManager;

    public AccountsImpl(AccountsManager accountsManager) {
        this.accountsManager = accountsManager;
    }

    @Override
    public List<Account> list() throws EthereumException {
        return this.accountsManager.getAccounts();
    }

    @Override
    public Balance balance(Account account) throws EthereumException {
        return this.accountsManager.getAccountBalance(account.address);
    }

    @Override
    public FaucetResponse requestEthFromFaucet(String address) throws ServiceException {
        return FaucetService.requestEthFromFaucet(this.accountsManager.getFaucetUrl(), address);
    }

    @Override
    public TransactionReceipt requestTokens(BigInteger amount) throws EthereumException {
        return this.accountsManager.requestTokens(amount);
    }
}

