/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api.helper;

import com.oceanprotocol.secretstore.core.EvmDto;
import com.oceanprotocol.secretstore.core.SecretStoreDto;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.api.config.NeverminedConfig;
import io.keyko.nevermined.contracts.AccessSecretStoreCondition;
import io.keyko.nevermined.contracts.AgreementStoreManager;
import io.keyko.nevermined.contracts.ComputeExecutionCondition;
import io.keyko.nevermined.contracts.ConditionStoreManager;
import io.keyko.nevermined.contracts.DIDRegistry;
import io.keyko.nevermined.contracts.Dispenser;
import io.keyko.nevermined.contracts.EscrowAccessSecretStoreTemplate;
import io.keyko.nevermined.contracts.EscrowComputeExecutionTemplate;
import io.keyko.nevermined.contracts.EscrowReward;
import io.keyko.nevermined.contracts.LockRewardCondition;
import io.keyko.nevermined.contracts.NeverminedToken;
import io.keyko.nevermined.contracts.TemplateStoreManager;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.AccountsManager;
import io.keyko.nevermined.manager.AgreementsManager;
import io.keyko.nevermined.manager.AssetsManager;
import io.keyko.nevermined.manager.ConditionsManager;
import io.keyko.nevermined.manager.NeverminedManager;
import io.keyko.nevermined.manager.SecretStoreManager;
import io.keyko.nevermined.manager.TemplatesManager;
import java.io.IOException;
import org.web3j.crypto.CipherException;
import org.web3j.protocol.Web3j;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class InitializationHelper {
    private NeverminedConfig neverminedConfig;

    public InitializationHelper(NeverminedConfig neverminedConfig) {
        this.neverminedConfig = neverminedConfig;
    }

    public KeeperService getKeeper() throws IOException, CipherException {
        KeeperService keeper = KeeperService.getInstance((String)this.neverminedConfig.getKeeperUrl(), (String)this.neverminedConfig.getMainAccountAddress(), (String)this.neverminedConfig.getMainAccountPassword(), (String)this.neverminedConfig.getMainAccountCredentialsFile(), (int)this.neverminedConfig.getKeeperTxAttempts(), (long)this.neverminedConfig.getKeeperTxSleepDuration());
        keeper.setGasLimit(this.neverminedConfig.getKeeperGasLimit()).setGasPrice(this.neverminedConfig.getKeeperGasPrice());
        return keeper;
    }

    public MetadataApiService getMetadataService() {
        return MetadataApiService.getInstance(this.neverminedConfig.getMetadataUrl());
    }

    public SecretStoreDto getSecretStoreDto() {
        return SecretStoreDto.builder((String)this.neverminedConfig.getSecretStoreUrl());
    }

    public EvmDto getEvmDto() {
        return EvmDto.builder((String)this.neverminedConfig.getKeeperUrl(), (String)this.neverminedConfig.getMainAccountAddress(), (String)this.neverminedConfig.getMainAccountPassword());
    }

    public SecretStoreManager getSecretStoreManager(SecretStoreDto secretStoreDto, EvmDto evmDto) {
        return SecretStoreManager.getInstance(secretStoreDto, evmDto);
    }

    public NeverminedManager getNeverminedManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return NeverminedManager.getInstance(keeperService, metadataApiService);
    }

    public AccountsManager getAccountsManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return AccountsManager.getInstance(keeperService, metadataApiService).setFaucetUrl(this.neverminedConfig.getFaucetUrl());
    }

    public AgreementsManager getAgreementsManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return AgreementsManager.getInstance(keeperService, metadataApiService);
    }

    public ConditionsManager getConditionsManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return ConditionsManager.getInstance(keeperService, metadataApiService);
    }

    public TemplatesManager getTemplatesManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return TemplatesManager.getInstance(keeperService, metadataApiService);
    }

    public AssetsManager getAssetsManager(KeeperService keeperService, MetadataApiService metadataApiService) throws IOException, CipherException {
        return AssetsManager.getInstance(keeperService, metadataApiService);
    }

    public NeverminedToken loadNeverminedTokenContract(KeeperService keeper) throws IOException, CipherException {
        return NeverminedToken.load((String)this.neverminedConfig.getTokenAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public TemplateStoreManager loadTemplateStoreManagerContract(KeeperService keeper) throws IOException, CipherException {
        return TemplateStoreManager.load((String)this.neverminedConfig.getTemplateStoreManagerAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public Dispenser loadDispenserContract(KeeperService keeper) throws IOException, CipherException {
        return Dispenser.load((String)this.neverminedConfig.getDispenserAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public DIDRegistry loadDIDRegistryContract(KeeperService keeper) throws IOException, CipherException {
        return DIDRegistry.load((String)this.neverminedConfig.getDidRegistryAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public EscrowAccessSecretStoreTemplate loadEscrowAccessSecretStoreTemplate(KeeperService keeper) throws IOException, CipherException {
        return EscrowAccessSecretStoreTemplate.load((String)this.neverminedConfig.getEscrowAccessSecretStoreTemplateAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public LockRewardCondition loadLockRewardCondition(KeeperService keeper) throws IOException, CipherException {
        return LockRewardCondition.load((String)this.neverminedConfig.getLockrewardConditionsAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public EscrowReward loadEscrowReward(KeeperService keeper) throws IOException, CipherException {
        return EscrowReward.load((String)this.neverminedConfig.getEscrowRewardConditionsAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public AgreementStoreManager loadAgreementStoreManager(KeeperService keeper) throws IOException, CipherException {
        return AgreementStoreManager.load((String)this.neverminedConfig.getAgreementStoreManagerAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public ConditionStoreManager loadConditionStoreManager(KeeperService keeper) throws IOException, CipherException {
        return ConditionStoreManager.load((String)this.neverminedConfig.getConditionStoreManagerAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public AccessSecretStoreCondition loadAccessSecretStoreCondition(KeeperService keeper) throws IOException, CipherException {
        return AccessSecretStoreCondition.load((String)this.neverminedConfig.getAccessSsConditionsAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public EscrowComputeExecutionTemplate loadEscrowComputeExecutionTemplate(KeeperService keeper) throws IOException, CipherException {
        return EscrowComputeExecutionTemplate.load((String)this.neverminedConfig.getEscrowComputeExecutionTemplateAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }

    public ComputeExecutionCondition loadComputeExecutionCondition(KeeperService keeper) throws IOException, CipherException {
        return ComputeExecutionCondition.load((String)this.neverminedConfig.getComputeExecutionConditionAddress(), (Web3j)keeper.getWeb3(), (TransactionManager)keeper.getTxManager(), (ContractGasProvider)keeper.getContractGasProvider());
    }
}

