/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api.config;

import io.keyko.nevermined.api.config.NeverminedConfig;
import java.math.BigInteger;
import java.util.Properties;

public class NeverminedConfigFactory {
    private static final String DEFAULT_KEEPER_URL = "http://localhost:8545";
    private static final BigInteger DEFAULT_KEEPER_GAS_LIMIT = BigInteger.valueOf(4712388L);
    private static final BigInteger DEFAULT_KEEPER_GAS_PRICE = BigInteger.valueOf(100000000000L);
    private static final String DEFAULT_METADATA_URL = "http://localhost:5000";
    private static final String DEFAULT_SECRET_STORE_URL = "http://localhost:12001";
    private static final String DEFAULT_FAUCET_URL = "http://localhost:3001";
    private static final String DEFAULT_CONSUME_PATH = "/tmp";

    public static NeverminedConfig getNeverminedConfig(Properties properties) {
        NeverminedConfig neverminedConfig = new NeverminedConfig();
        properties.getOrDefault((Object)"consume.basePath", DEFAULT_CONSUME_PATH);
        neverminedConfig.setKeeperUrl((String)properties.getOrDefault((Object)"keeper.url", DEFAULT_KEEPER_URL));
        neverminedConfig.setKeeperGasLimit(new BigInteger((String)properties.getOrDefault((Object)"keeper.gasLimit", DEFAULT_KEEPER_GAS_LIMIT.toString())));
        neverminedConfig.setKeeperGasPrice(new BigInteger((String)properties.getOrDefault((Object)"keeper.gasPrice", DEFAULT_KEEPER_GAS_PRICE.toString())));
        neverminedConfig.setKeeperTxAttempts(Integer.parseInt((String)properties.getOrDefault((Object)"keeper.tx.attempts", String.valueOf(40))));
        neverminedConfig.setKeeperTxSleepDuration(Long.parseLong((String)properties.getOrDefault((Object)"keeper.tx.sleepDuration", String.valueOf(15000L))));
        neverminedConfig.setMetadataUrl((String)properties.getOrDefault((Object)"metadata.url", DEFAULT_METADATA_URL));
        neverminedConfig.setSecretStoreUrl((String)properties.getOrDefault((Object)"secretstore.url", DEFAULT_SECRET_STORE_URL));
        neverminedConfig.setFaucetUrl((String)properties.getOrDefault((Object)"faucet.url", DEFAULT_FAUCET_URL));
        neverminedConfig.setProviderAddress((String)properties.getOrDefault((Object)"provider.address", ""));
        neverminedConfig.setDidRegistryAddress((String)properties.getOrDefault((Object)"contract.DIDRegistry.address", ""));
        neverminedConfig.setEscrowRewardConditionsAddress((String)properties.getOrDefault((Object)"contract.EscrowReward.address", ""));
        neverminedConfig.setEscrowAccessSecretStoreTemplateAddress((String)properties.getOrDefault((Object)"contract.EscrowAccessSecretStoreTemplate.address", ""));
        neverminedConfig.setLockrewardConditionsAddress((String)properties.getOrDefault((Object)"contract.LockRewardCondition.address", ""));
        neverminedConfig.setAccessSsConditionsAddress((String)properties.getOrDefault((Object)"contract.AccessSecretStoreCondition.address", ""));
        neverminedConfig.setAgreementStoreManagerAddress((String)properties.getOrDefault((Object)"contract.AgreementStoreManager.address", ""));
        neverminedConfig.setConditionStoreManagerAddress((String)properties.getOrDefault((Object)"contract.ConditionStoreManager.address", ""));
        neverminedConfig.setTokenAddress((String)properties.getOrDefault((Object)"contract.NeverminedToken.address", ""));
        neverminedConfig.setTemplateStoreManagerAddress((String)properties.getOrDefault((Object)"contract.TemplateStoreManager.address", ""));
        neverminedConfig.setDispenserAddress((String)properties.getOrDefault((Object)"contract.Dispenser.address", ""));
        neverminedConfig.setConsumeBasePath((String)properties.getOrDefault((Object)"consume.basePath", DEFAULT_CONSUME_PATH));
        neverminedConfig.setMainAccountAddress((String)properties.getOrDefault((Object)"account.main.address", ""));
        neverminedConfig.setMainAccountPassword((String)properties.getOrDefault((Object)"account.main.password", ""));
        neverminedConfig.setMainAccountCredentialsFile((String)properties.getOrDefault((Object)"account.main.credentialsFile", ""));
        neverminedConfig.setEscrowComputeExecutionTemplateAddress((String)properties.getOrDefault((Object)"contract.EscrowComputeExecutionTemplate.address", ""));
        neverminedConfig.setComputeExecutionConditionAddress((String)properties.getOrDefault((Object)"contract.ComputeExecutionCondition.address", ""));
        return neverminedConfig;
    }
}

