/*
 * Decompiled with CFR 0.152.
 */
package io.keyko.nevermined.api;

import com.oceanprotocol.secretstore.core.EvmDto;
import com.oceanprotocol.secretstore.core.SecretStoreDto;
import com.typesafe.config.Config;
import io.keyko.common.web3.KeeperService;
import io.keyko.nevermined.api.AccountsAPI;
import io.keyko.nevermined.api.AgreementsAPI;
import io.keyko.nevermined.api.AssetsAPI;
import io.keyko.nevermined.api.ConditionsAPI;
import io.keyko.nevermined.api.SecretStoreAPI;
import io.keyko.nevermined.api.TemplatesAPI;
import io.keyko.nevermined.api.TokensAPI;
import io.keyko.nevermined.api.config.NeverminedConfig;
import io.keyko.nevermined.api.config.NeverminedConfigFactory;
import io.keyko.nevermined.api.helper.InitializationHelper;
import io.keyko.nevermined.api.impl.AccountsImpl;
import io.keyko.nevermined.api.impl.AgreementsImpl;
import io.keyko.nevermined.api.impl.AssetsImpl;
import io.keyko.nevermined.api.impl.ConditionsImpl;
import io.keyko.nevermined.api.impl.SecretStoreImpl;
import io.keyko.nevermined.api.impl.TemplatesImpl;
import io.keyko.nevermined.api.impl.TokensImpl;
import io.keyko.nevermined.contracts.AccessSecretStoreCondition;
import io.keyko.nevermined.contracts.AgreementStoreManager;
import io.keyko.nevermined.contracts.ComputeExecutionCondition;
import io.keyko.nevermined.contracts.ConditionStoreManager;
import io.keyko.nevermined.contracts.DIDRegistry;
import io.keyko.nevermined.contracts.Dispenser;
import io.keyko.nevermined.contracts.EscrowAccessSecretStoreTemplate;
import io.keyko.nevermined.contracts.EscrowComputeExecutionTemplate;
import io.keyko.nevermined.contracts.EscrowReward;
import io.keyko.nevermined.contracts.LockRewardCondition;
import io.keyko.nevermined.contracts.NeverminedToken;
import io.keyko.nevermined.contracts.TemplateStoreManager;
import io.keyko.nevermined.exceptions.InitializationException;
import io.keyko.nevermined.exceptions.InvalidConfiguration;
import io.keyko.nevermined.external.MetadataApiService;
import io.keyko.nevermined.manager.AccountsManager;
import io.keyko.nevermined.manager.AgreementsManager;
import io.keyko.nevermined.manager.AssetsManager;
import io.keyko.nevermined.manager.ConditionsManager;
import io.keyko.nevermined.manager.NeverminedManager;
import io.keyko.nevermined.manager.SecretStoreManager;
import io.keyko.nevermined.manager.TemplatesManager;
import io.keyko.nevermined.models.Account;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.IOException;
import java.net.SocketException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Keys;

public class NeverminedAPI {
    private static final Logger log = LogManager.getLogger(NeverminedAPI.class);
    private NeverminedConfig neverminedConfig;
    private KeeperService keeperService;
    private MetadataApiService metadataApiService;
    private SecretStoreDto secretStoreDto;
    private EvmDto evmDto;
    private SecretStoreManager secretStoreManager;
    private NeverminedManager neverminedManager;
    private AssetsManager assetsManager;
    private AccountsManager accountsManager;
    private AgreementsManager agreementsManager;
    private ConditionsManager conditionsManager;
    private TemplatesManager templatesManager;
    private NeverminedToken tokenContract;
    private Dispenser dispenser;
    private DIDRegistry didRegistryContract;
    private EscrowAccessSecretStoreTemplate escrowAccessSecretStoreTemplate;
    private LockRewardCondition lockRewardCondition;
    private AccessSecretStoreCondition accessSecretStoreCondition;
    private EscrowReward escrowReward;
    private TemplateStoreManager templateStoreManagerContract;
    private AgreementStoreManager agreementStoreManagerContract;
    private ConditionStoreManager conditionStoreManager;
    private ComputeExecutionCondition computeExecutionCondition;
    private EscrowComputeExecutionTemplate escrowComputeExecutionTemplate;
    private AccountsAPI accountsAPI;
    private AgreementsAPI agreementsAPI;
    private ConditionsAPI conditionsAPI;
    private TokensAPI tokensAPI;
    private AssetsAPI assetsAPI;
    private SecretStoreAPI secretStoreAPI;
    private TemplatesAPI templatesAPI;
    private Account mainAccount;
    private static NeverminedAPI neverminedAPI = null;

    private NeverminedAPI(NeverminedConfig neverminedConfig) {
        this.neverminedConfig = neverminedConfig;
    }

    private static Properties toProperties(Config config) {
        Properties properties = new Properties();
        config.entrySet().forEach(e -> properties.setProperty((String)e.getKey(), config.getString((String)e.getKey())));
        return properties;
    }

    private static void setRxUndeliverableExceptionHandler() {
        RxJavaPlugins.setErrorHandler(e -> {
            if (e instanceof UndeliverableException) {
                e = e.getCause();
            }
            if (e instanceof IOException || e instanceof SocketException) {
                return;
            }
            if (e instanceof InterruptedException) {
                return;
            }
            if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
                return;
            }
            if (e instanceof IllegalStateException) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
                return;
            }
            log.warn("Undeliverable exception received:  " + e.getMessage());
        });
    }

    public static NeverminedAPI getInstance(Properties properties) throws InitializationException, InvalidConfiguration {
        NeverminedAPI.setRxUndeliverableExceptionHandler();
        NeverminedConfig neverminedConfig = NeverminedConfigFactory.getNeverminedConfig(properties);
        NeverminedConfig.NeverminedConfigValidation validation = NeverminedConfig.validate(neverminedConfig);
        if (!validation.isValid().booleanValue()) {
            String msg = "Error Initializing Nevermined API. Configuration not valid " + validation.errorsToString();
            log.error(msg);
            throw new InvalidConfiguration(msg);
        }
        neverminedAPI = new NeverminedAPI(neverminedConfig);
        NeverminedAPI.neverminedAPI.mainAccount = new Account(Keys.toChecksumAddress((String)neverminedConfig.getMainAccountAddress()), neverminedConfig.getMainAccountPassword());
        InitializationHelper initializationHelper = new InitializationHelper(neverminedConfig);
        try {
            NeverminedAPI.neverminedAPI.neverminedConfig = neverminedConfig;
            NeverminedAPI.neverminedAPI.metadataApiService = initializationHelper.getMetadataService();
            NeverminedAPI.neverminedAPI.keeperService = initializationHelper.getKeeper();
            NeverminedAPI.neverminedAPI.secretStoreDto = initializationHelper.getSecretStoreDto();
            NeverminedAPI.neverminedAPI.evmDto = initializationHelper.getEvmDto();
            NeverminedAPI.neverminedAPI.secretStoreManager = initializationHelper.getSecretStoreManager(NeverminedAPI.neverminedAPI.secretStoreDto, NeverminedAPI.neverminedAPI.evmDto);
            NeverminedAPI.neverminedAPI.didRegistryContract = initializationHelper.loadDIDRegistryContract(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.escrowAccessSecretStoreTemplate = initializationHelper.loadEscrowAccessSecretStoreTemplate(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.lockRewardCondition = initializationHelper.loadLockRewardCondition(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.accessSecretStoreCondition = initializationHelper.loadAccessSecretStoreCondition(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.escrowReward = initializationHelper.loadEscrowReward(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.dispenser = initializationHelper.loadDispenserContract(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.tokenContract = initializationHelper.loadNeverminedTokenContract(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.templateStoreManagerContract = initializationHelper.loadTemplateStoreManagerContract(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.agreementStoreManagerContract = initializationHelper.loadAgreementStoreManager(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.conditionStoreManager = initializationHelper.loadConditionStoreManager(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.computeExecutionCondition = initializationHelper.loadComputeExecutionCondition(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.escrowComputeExecutionTemplate = initializationHelper.loadEscrowComputeExecutionTemplate(NeverminedAPI.neverminedAPI.keeperService);
            NeverminedAPI.neverminedAPI.agreementsManager = initializationHelper.getAgreementsManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.agreementsManager.setConditionStoreManagerContract(NeverminedAPI.neverminedAPI.conditionStoreManager).setEscrowAccessSecretStoreTemplate(NeverminedAPI.neverminedAPI.escrowAccessSecretStoreTemplate).setAgreementStoreManagerContract(NeverminedAPI.neverminedAPI.agreementStoreManagerContract).setLockRewardCondition(NeverminedAPI.neverminedAPI.lockRewardCondition).setAccessSecretStoreCondition(NeverminedAPI.neverminedAPI.accessSecretStoreCondition).setEscrowReward(NeverminedAPI.neverminedAPI.escrowReward).setComputeExecutionCondition(NeverminedAPI.neverminedAPI.computeExecutionCondition).setEscrowComputeExecutionTemplate(NeverminedAPI.neverminedAPI.escrowComputeExecutionTemplate);
            NeverminedAPI.neverminedAPI.templatesManager = initializationHelper.getTemplatesManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.templatesManager.setMainAccount(NeverminedAPI.neverminedAPI.mainAccount);
            NeverminedAPI.neverminedAPI.templatesManager.setTemplateStoreManagerContract(NeverminedAPI.neverminedAPI.templateStoreManagerContract);
            NeverminedAPI.neverminedAPI.neverminedManager = initializationHelper.getNeverminedManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.neverminedManager.setAgreementManager(NeverminedAPI.neverminedAPI.agreementsManager).setTemplatesManager(NeverminedAPI.neverminedAPI.templatesManager).setSecretStoreManager(NeverminedAPI.neverminedAPI.secretStoreManager).setDidRegistryContract(NeverminedAPI.neverminedAPI.didRegistryContract).setEscrowAccessSecretStoreTemplate(NeverminedAPI.neverminedAPI.escrowAccessSecretStoreTemplate).setLockRewardCondition(NeverminedAPI.neverminedAPI.lockRewardCondition).setEscrowReward(NeverminedAPI.neverminedAPI.escrowReward).setAccessSecretStoreCondition(NeverminedAPI.neverminedAPI.accessSecretStoreCondition).setTokenContract(NeverminedAPI.neverminedAPI.tokenContract).setTemplateStoreManagerContract(NeverminedAPI.neverminedAPI.templateStoreManagerContract).setAgreementStoreManagerContract(NeverminedAPI.neverminedAPI.agreementStoreManagerContract).setConditionStoreManagerContract(NeverminedAPI.neverminedAPI.conditionStoreManager).setComputeExecutionCondition(NeverminedAPI.neverminedAPI.computeExecutionCondition).setEscrowComputeExecutionTemplate(NeverminedAPI.neverminedAPI.escrowComputeExecutionTemplate).setMainAccount(NeverminedAPI.neverminedAPI.mainAccount).setEvmDto(NeverminedAPI.neverminedAPI.evmDto);
            NeverminedAPI.neverminedAPI.accountsManager = initializationHelper.getAccountsManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.accountsManager.setTokenContract(NeverminedAPI.neverminedAPI.tokenContract).setDispenserContract(NeverminedAPI.neverminedAPI.dispenser).setMainAccount(NeverminedAPI.neverminedAPI.mainAccount);
            NeverminedAPI.neverminedAPI.conditionsManager = initializationHelper.getConditionsManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.conditionsManager.setTokenContract(NeverminedAPI.neverminedAPI.tokenContract).setConditionStoreManagerContract(NeverminedAPI.neverminedAPI.conditionStoreManager).setEscrowAccessSecretStoreTemplate(NeverminedAPI.neverminedAPI.escrowAccessSecretStoreTemplate).setAgreementStoreManagerContract(NeverminedAPI.neverminedAPI.agreementStoreManagerContract).setLockRewardCondition(NeverminedAPI.neverminedAPI.lockRewardCondition).setAccessSecretStoreCondition(NeverminedAPI.neverminedAPI.accessSecretStoreCondition).setEscrowReward(NeverminedAPI.neverminedAPI.escrowReward).setComputeExecutionCondition(NeverminedAPI.neverminedAPI.computeExecutionCondition).setEscrowComputeExecutionTemplate(NeverminedAPI.neverminedAPI.escrowComputeExecutionTemplate);
            NeverminedAPI.neverminedAPI.assetsManager = initializationHelper.getAssetsManager(NeverminedAPI.neverminedAPI.keeperService, NeverminedAPI.neverminedAPI.metadataApiService);
            NeverminedAPI.neverminedAPI.assetsManager.setMainAccount(NeverminedAPI.neverminedAPI.mainAccount).setDidRegistryContract(NeverminedAPI.neverminedAPI.didRegistryContract);
            NeverminedAPI.neverminedAPI.accountsAPI = new AccountsImpl(NeverminedAPI.neverminedAPI.accountsManager);
            NeverminedAPI.neverminedAPI.agreementsAPI = new AgreementsImpl(NeverminedAPI.neverminedAPI.agreementsManager, NeverminedAPI.neverminedAPI.neverminedManager);
            NeverminedAPI.neverminedAPI.conditionsAPI = new ConditionsImpl(NeverminedAPI.neverminedAPI.conditionsManager);
            NeverminedAPI.neverminedAPI.tokensAPI = new TokensImpl(NeverminedAPI.neverminedAPI.accountsManager);
            NeverminedAPI.neverminedAPI.secretStoreAPI = new SecretStoreImpl(NeverminedAPI.neverminedAPI.secretStoreManager);
            NeverminedAPI.neverminedAPI.assetsAPI = new AssetsImpl(NeverminedAPI.neverminedAPI.neverminedManager, NeverminedAPI.neverminedAPI.assetsManager, NeverminedAPI.neverminedAPI.agreementsManager);
            NeverminedAPI.neverminedAPI.templatesAPI = new TemplatesImpl(NeverminedAPI.neverminedAPI.templatesManager);
            return neverminedAPI;
        }
        catch (Exception e) {
            String msg = "Error Initializing Nevermined API";
            log.error(msg + ": " + e.getMessage());
            throw new InitializationException(msg, e);
        }
    }

    public static NeverminedAPI getInstance(Config config) throws InitializationException, InvalidConfiguration {
        return NeverminedAPI.getInstance(NeverminedAPI.toProperties(config));
    }

    public Account getMainAccount() {
        return this.mainAccount;
    }

    public AccountsAPI getAccountsAPI() {
        return this.accountsAPI;
    }

    public AgreementsAPI getAgreementsAPI() {
        return this.agreementsAPI;
    }

    public ConditionsAPI getConditionsAPI() {
        return this.conditionsAPI;
    }

    public TokensAPI getTokensAPI() {
        return this.tokensAPI;
    }

    public AssetsAPI getAssetsAPI() {
        return this.assetsAPI;
    }

    public SecretStoreAPI getSecretStoreAPI() {
        return this.secretStoreAPI;
    }

    public TemplatesAPI getTemplatesAPI() {
        return this.templatesAPI;
    }

    public void setTemplateStoreManagerContract(TemplateStoreManager contract) {
        NeverminedAPI.neverminedAPI.templatesManager.setTemplateStoreManagerContract(contract);
    }
}

