/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import com.google.common.io.CharStreams;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Rethrow;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MicronautTest
class LocalStorageTest {
    @Inject
    StorageInterface storageInterface;

    LocalStorageTest() {
    }

    private URI putFile(URL resource, String path) throws Exception {
        return this.storageInterface.put(new URI(path), (InputStream)new FileInputStream(Objects.requireNonNull(resource).getFile()));
    }

    @Test
    void get() throws Exception {
        String prefix = IdUtils.create();
        URL resource = LocalStorageTest.class.getClassLoader().getResource("application.yml");
        String content = CharStreams.toString((Readable)new InputStreamReader(new FileInputStream(Objects.requireNonNull(resource).getFile())));
        this.putFile(resource, "/" + prefix + "/storage/get.yml");
        InputStream get = this.storageInterface.get(new URI("/" + prefix + "/storage/get.yml"));
        MatcherAssert.assertThat((Object)CharStreams.toString((Readable)new InputStreamReader(get)), (Matcher)Matchers.is((Object)content));
        InputStream getScheme = this.storageInterface.get(new URI("kestra:///" + prefix + "/storage/get.yml"));
        MatcherAssert.assertThat((Object)CharStreams.toString((Readable)new InputStreamReader(getScheme)), (Matcher)Matchers.is((Object)content));
    }

    @Test
    void missing() {
        String prefix = IdUtils.create();
        Assertions.assertThrows(FileNotFoundException.class, () -> this.storageInterface.get(new URI("/" + prefix + "/storage/missing.yml")));
    }

    @Test
    void put() throws Exception {
        String prefix = IdUtils.create();
        URL resource = LocalStorageTest.class.getClassLoader().getResource("application.yml");
        URI put = this.putFile(resource, "/" + prefix + "/storage/put.yml");
        InputStream get = this.storageInterface.get(new URI("/" + prefix + "/storage/put.yml"));
        MatcherAssert.assertThat((Object)put.toString(), (Matcher)Matchers.is((Object)new URI("kestra:///" + prefix + "/storage/put.yml").toString()));
        MatcherAssert.assertThat((Object)CharStreams.toString((Readable)new InputStreamReader(get)), (Matcher)Matchers.is((Object)CharStreams.toString((Readable)new InputStreamReader(new FileInputStream(Objects.requireNonNull(resource).getFile())))));
        MatcherAssert.assertThat((Object)this.storageInterface.size(new URI("/" + prefix + "/storage/put.yml")), (Matcher)Matchers.is((Object)77L));
        Assertions.assertThrows(FileNotFoundException.class, () -> MatcherAssert.assertThat((Object)this.storageInterface.size(new URI("/" + prefix + "/storage/muissing.yml")), (Matcher)Matchers.is((Object)76L)));
        boolean delete = this.storageInterface.delete(put);
        MatcherAssert.assertThat((Object)delete, (Matcher)Matchers.is((Object)true));
        delete = this.storageInterface.delete(put);
        MatcherAssert.assertThat((Object)delete, (Matcher)Matchers.is((Object)false));
        Assertions.assertThrows(FileNotFoundException.class, () -> this.storageInterface.get(new URI("/" + prefix + "/storage/put.yml")));
    }

    @Test
    void deleteByPrefix() throws Exception {
        String prefix = IdUtils.create();
        URL resource = LocalStorageTest.class.getClassLoader().getResource("application.yml");
        List<String> path = Arrays.asList("/" + prefix + "/storage/root.yml", "/" + prefix + "/storage/level1/1.yml", "/" + prefix + "/storage/level1/level2/1.yml");
        path.forEach(Rethrow.throwConsumer(s -> this.putFile(resource, (String)s)));
        List deleted = this.storageInterface.deleteByPrefix(new URI("/" + prefix + "/storage/"));
        MatcherAssert.assertThat((Object)deleted, (Matcher)Matchers.containsInAnyOrder((Object[])path.stream().map(s -> URI.create("kestra://" + s)).toArray()));
        Assertions.assertThrows(FileNotFoundException.class, () -> this.storageInterface.get(new URI("/" + prefix + "/storage/")));
        path.forEach(s -> Assertions.assertThrows(FileNotFoundException.class, () -> this.storageInterface.get(new URI((String)s))));
    }

    @Test
    void deleteByPrefixNoResult() throws Exception {
        String prefix = IdUtils.create();
        List deleted = this.storageInterface.deleteByPrefix(new URI("/" + prefix + "/storage/"));
        MatcherAssert.assertThat((Object)deleted.size(), (Matcher)Matchers.is((Object)0));
    }
}

