/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import io.kestra.core.storages.StorageInterface;
import io.kestra.storage.local.LocalConfig;
import io.kestra.storage.local.LocalStorageEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

@Singleton
@LocalStorageEnabled
public class LocalStorage
implements StorageInterface {
    LocalConfig config;

    @Inject
    public LocalStorage(LocalConfig config) {
        this.config = config;
        this.createDirectory(null);
    }

    private Path getPath(URI uri) {
        return Paths.get(this.config.getBasePath().toAbsolutePath().toString(), uri.toString());
    }

    private void createDirectory(URI append) {
        File file;
        if (append != null) {
            Path path = Paths.get(this.config.getBasePath().toAbsolutePath().toString(), append.getPath());
            file = path.getParent().toFile();
        } else {
            file = new File(this.config.getBasePath().toUri());
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
        }
    }

    public InputStream get(URI uri) throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getPath(URI.create(uri.getPath())).toAbsolutePath().toString()));
    }

    public Long size(URI uri) throws IOException {
        try {
            return Files.size(this.getPath(URI.create(uri.getPath())));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (IOException e) {
            throw new IOException("Unable to find file at '" + uri + "' with message '" + e.getMessage() + "'");
        }
    }

    public URI put(URI uri, InputStream data) throws IOException {
        this.createDirectory(uri);
        try (InputStream inputStream = data;
             FileOutputStream outStream = new FileOutputStream(this.getPath(uri).toFile());){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = data.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        return URI.create("kestra://" + uri.getPath());
    }

    public boolean delete(URI uri) throws IOException {
        File file = this.getPath(URI.create(uri.getPath())).toFile();
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public List<URI> deleteByPrefix(URI storagePrefix) throws IOException {
        Path path = this.getPath(storagePrefix);
        if (!path.toFile().exists()) {
            return List.of();
        }
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            List<URI> list = walk.sorted(Comparator.reverseOrder()).map(r -> Pair.of((Object)r.toFile(), (Object)r.toFile().isFile())).peek(r -> ((File)r.getLeft()).delete()).filter(Pair::getRight).map(r -> URI.create("kestra://" + ((File)r.getLeft()).toURI().getPath().substring(this.config.getBasePath().toAbsolutePath().toString().length()))).collect(Collectors.toList());
            return list;
        }
    }
}

