/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.FileAttributes;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import lombok.Generated;

public final class LocalFileAttributes
implements FileAttributes {
    private final Path filePath;
    private final BasicFileAttributes basicFileAttributes;

    public String getFileName() {
        return this.filePath.getFileName().toString();
    }

    public long getLastModifiedTime() {
        return this.basicFileAttributes.lastModifiedTime().toMillis();
    }

    public long getCreationTime() {
        return this.basicFileAttributes.creationTime().toMillis();
    }

    public FileAttributes.FileType getType() {
        if (this.basicFileAttributes.isRegularFile()) {
            return FileAttributes.FileType.File;
        }
        if (this.basicFileAttributes.isDirectory()) {
            return FileAttributes.FileType.Directory;
        }
        throw new RuntimeException("Unknown type for file %s".formatted(this.getFileName()));
    }

    public long getSize() {
        return this.basicFileAttributes.size();
    }

    public Map<String, String> getMetadata() throws IOException {
        return LocalFileAttributes.getMetadata(this.filePath);
    }

    public static Map<String, String> getMetadata(Path filePath) throws IOException {
        File metadataFile = new File(filePath.toString() + ".metadata");
        if (metadataFile.exists()) {
            try (FileInputStream is = new FileInputStream(metadataFile);){
                String metadataFileContent = new String(((InputStream)is).readAllBytes());
                Map map = (Map)JacksonMapper.ofIon().readValue(metadataFileContent, (TypeReference)new TypeReference<Map<String, String>>(){});
                return map;
            }
        }
        return null;
    }

    @ConstructorProperties(value={"filePath", "basicFileAttributes"})
    @Generated
    LocalFileAttributes(Path filePath, BasicFileAttributes basicFileAttributes) {
        this.filePath = filePath;
        this.basicFileAttributes = basicFileAttributes;
    }

    @Generated
    public static LocalFileAttributesBuilder builder() {
        return new LocalFileAttributesBuilder();
    }

    @Generated
    public Path getFilePath() {
        return this.filePath;
    }

    @Generated
    public BasicFileAttributes getBasicFileAttributes() {
        return this.basicFileAttributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFileAttributes)) {
            return false;
        }
        LocalFileAttributes other = (LocalFileAttributes)o;
        Path this$filePath = this.getFilePath();
        Path other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath)) {
            return false;
        }
        BasicFileAttributes this$basicFileAttributes = this.getBasicFileAttributes();
        BasicFileAttributes other$basicFileAttributes = other.getBasicFileAttributes();
        return !(this$basicFileAttributes == null ? other$basicFileAttributes != null : !this$basicFileAttributes.equals(other$basicFileAttributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
        BasicFileAttributes $basicFileAttributes = this.getBasicFileAttributes();
        result = result * 59 + ($basicFileAttributes == null ? 43 : $basicFileAttributes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalFileAttributes(filePath=" + String.valueOf(this.getFilePath()) + ", basicFileAttributes=" + String.valueOf(this.getBasicFileAttributes()) + ")";
    }

    @Generated
    public static class LocalFileAttributesBuilder {
        @Generated
        private Path filePath;
        @Generated
        private BasicFileAttributes basicFileAttributes;

        @Generated
        LocalFileAttributesBuilder() {
        }

        @Generated
        public LocalFileAttributesBuilder filePath(Path filePath) {
            this.filePath = filePath;
            return this;
        }

        @Generated
        public LocalFileAttributesBuilder basicFileAttributes(BasicFileAttributes basicFileAttributes) {
            this.basicFileAttributes = basicFileAttributes;
            return this;
        }

        @Generated
        public LocalFileAttributes build() {
            return new LocalFileAttributes(this.filePath, this.basicFileAttributes);
        }

        @Generated
        public String toString() {
            return "LocalFileAttributes.LocalFileAttributesBuilder(filePath=" + String.valueOf(this.filePath) + ", basicFileAttributes=" + String.valueOf(this.basicFileAttributes) + ")";
        }
    }
}

