/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import io.kestra.core.storages.StorageInterface;
import io.kestra.storage.local.LocalConfig;
import io.kestra.storage.local.LocalStorageEnabled;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@LocalStorageEnabled
public class LocalStorage
implements StorageInterface {
    LocalConfig config;

    @Inject
    public LocalStorage(LocalConfig config) {
        this.config = config;
        this.createDirectory(null);
    }

    private Path getPath(URI uri) {
        return Paths.get(this.config.getBasePath().toAbsolutePath().toString(), uri.toString());
    }

    private void createDirectory(URI append) {
        File file;
        if (append != null) {
            Path path = Paths.get(this.config.getBasePath().toAbsolutePath().toString(), append.getPath());
            file = path.getParent().toFile();
        } else {
            file = new File(this.config.getBasePath().toUri());
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
        }
    }

    public InputStream get(URI uri) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.getPath(URI.create(uri.getPath())).toAbsolutePath().toString()));
    }

    public Long size(URI uri) throws IOException {
        return Files.size(this.getPath(URI.create(uri.getPath())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI put(URI uri, InputStream data) throws IOException {
        this.createDirectory(uri);
        try (FileOutputStream outStream = new FileOutputStream(this.getPath(uri).toFile());){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = data.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        finally {
            data.close();
        }
        return URI.create("kestra://" + uri.getPath());
    }

    public boolean delete(URI uri) throws IOException {
        File file = this.getPath(URI.create(uri.getPath())).toFile();
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }
}

