/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.FileAttributes;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.StorageObject;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.WindowsUtils;
import io.kestra.storage.local.LocalFileAttributes;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin
@Plugin.Id(value="local")
public class LocalStorage
implements StorageInterface {
    private static final Logger log = LoggerFactory.getLogger(LocalStorage.class);
    @PluginProperty
    @NotNull
    private Path basePath;

    public void init() throws IOException {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            Files.createDirectories(this.basePath, new FileAttribute[0]);
        }
    }

    private Path getPath(String tenantId, URI uri) {
        Path basePath;
        Path path = basePath = tenantId == null ? this.basePath.toAbsolutePath() : Paths.get(this.basePath.toAbsolutePath().toString(), tenantId);
        if (uri == null) {
            return basePath;
        }
        this.parentTraversalGuard(uri);
        return Paths.get(basePath.toString(), WindowsUtils.windowsToUnixPath((String)uri.getPath()));
    }

    public InputStream get(String tenantId, URI uri) throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getPath(tenantId, uri).toAbsolutePath().toString()));
    }

    public StorageObject getWithMetadata(String tenantId, URI uri) throws IOException {
        return new StorageObject(LocalFileAttributes.getMetadata(this.getPath(tenantId, uri)), this.get(tenantId, uri));
    }

    public List<URI> allByPrefix(String tenantId, final URI prefix, final boolean includeDirectories) throws IOException {
        Path fsPath = this.getPath(tenantId, prefix);
        final ArrayList uris = new ArrayList();
        Files.walkFileTree(fsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String dirPath = dir.toString().replace("\\", "/");
                if (includeDirectories) {
                    uris.add(URI.create(dirPath + "/"));
                }
                return super.preVisitDirectory(Path.of(dirPath, new String[0]), attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!file.getFileName().toString().endsWith(".metadata")) {
                    uris.add(URI.create(file.toString().replace("\\", "/")));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                log.warn("Failed to visit file " + String.valueOf(file) + " while searching all by prefix for path " + prefix.getPath(), (Throwable)exc);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        URI fsPathUri = URI.create(fsPath.toString().replace("\\", "/"));
        return uris.stream().sorted(Comparator.reverseOrder()).map(fsPathUri::relativize).map(URI::getPath).filter(Predicate.not(String::isEmpty)).map(path -> {
            String prefixPath;
            return URI.create("kestra://" + prefixPath + ((prefixPath = prefix.getPath()).endsWith("/") ? "" : "/") + path);
        }).toList();
    }

    public boolean exists(String tenantId, URI uri) {
        return Files.exists(this.getPath(tenantId, uri), new LinkOption[0]);
    }

    public List<FileAttributes> list(String tenantId, URI uri) throws IOException {
        List<FileAttributes> list;
        block8: {
            Stream<Path> stream = Files.list(this.getPath(tenantId, uri));
            try {
                list = stream.filter(path -> !path.getFileName().toString().endsWith(".metadata")).map(Rethrow.throwFunction(file -> {
                    URI relative = URI.create(this.getPath(tenantId, null).relativize(Path.of(file.toUri())).toString().replace("\\", "/"));
                    return this.getAttributes(tenantId, relative);
                })).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
            }
            stream.close();
        }
        return list;
    }

    public URI put(String tenantId, URI uri, StorageObject storageObject) throws IOException {
        FileOutputStream outStream;
        File file = this.getPath(tenantId, uri).toFile();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (InputStream data = storageObject.inputStream();){
            outStream = new FileOutputStream(file);
            try {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = data.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)outStream).close();
            }
        }
        Map metadata = storageObject.metadata();
        if (metadata != null) {
            outStream = new FileOutputStream(String.valueOf(file.toPath()) + ".metadata");
            try {
                ((OutputStream)outStream).write(JacksonMapper.ofIon().writeValueAsBytes((Object)metadata));
            }
            finally {
                ((OutputStream)outStream).close();
            }
        }
        return URI.create("kestra://" + uri.getRawPath());
    }

    public FileAttributes getAttributes(String tenantId, URI uri) throws IOException {
        Path path = this.getPath(tenantId, uri);
        try {
            return LocalFileAttributes.builder().filePath(path).basicFileAttributes(Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0])).build();
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public URI createDirectory(String tenantId, URI uri) {
        if (uri == null || uri.getPath().isEmpty()) {
            throw new IllegalArgumentException("Unable to create a directory with empty url.");
        }
        File file = this.getPath(tenantId, uri).toFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
        }
        return URI.create("kestra://" + uri.getPath());
    }

    public URI move(String tenantId, URI from, URI to) throws IOException {
        try {
            Files.move(this.getPath(tenantId, from), this.getPath(tenantId, to), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return URI.create("kestra://" + to.getPath());
    }

    public boolean delete(String tenantId, URI uri) throws IOException {
        Path path = this.getPath(tenantId, uri);
        File file = path.toFile();
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        return Files.deleteIfExists(path);
    }

    public List<URI> deleteByPrefix(String tenantId, URI storagePrefix) throws IOException {
        Path path = this.getPath(tenantId, storagePrefix);
        if (!path.toFile().exists()) {
            return List.of();
        }
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            List<URI> list = walk.sorted(Comparator.reverseOrder()).map(Path::toFile).peek(File::delete).map(r -> this.getKestraUri(tenantId, r.toPath())).toList();
            return list;
        }
    }

    private URI getKestraUri(String tenantId, Path path) {
        Path prefix = tenantId == null ? this.basePath.toAbsolutePath() : Path.of(this.basePath.toAbsolutePath().toString(), tenantId);
        return URI.create("kestra:///" + prefix.relativize(path).toString().replace("\\", "/"));
    }

    private void parentTraversalGuard(URI uri) {
        if (uri.toString().contains("..")) {
            throw new IllegalArgumentException("File should be accessed with their full path and not using relative '..' path.");
        }
    }

    @Generated
    public Path getBasePath() {
        return this.basePath;
    }

    @Generated
    public void setBasePath(Path basePath) {
        this.basePath = basePath;
    }

    @Generated
    public LocalStorage() {
    }
}

