/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import io.kestra.core.storages.FileAttributes;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.Rethrow;
import io.kestra.storage.local.LocalConfig;
import io.kestra.storage.local.LocalFileAttributes;
import io.kestra.storage.local.LocalStorageEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

@Singleton
@LocalStorageEnabled
public class LocalStorage
implements StorageInterface {
    LocalConfig config;

    @Inject
    public LocalStorage(LocalConfig config) throws IOException {
        this.config = config;
        if (!Files.exists(config.getBasePath(), new LinkOption[0])) {
            Files.createDirectories(config.getBasePath(), new FileAttribute[0]);
        }
    }

    private Path getPath(String tenantId, URI uri) {
        Path basePath;
        Path path = basePath = tenantId == null ? this.config.getBasePath().toAbsolutePath() : Paths.get(this.config.getBasePath().toAbsolutePath().toString(), tenantId);
        if (uri == null) {
            return basePath;
        }
        this.parentTraversalGuard(uri);
        return Paths.get(basePath.toString(), uri.getPath());
    }

    public InputStream get(String tenantId, URI uri) throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getPath(tenantId, uri).toAbsolutePath().toString()));
    }

    public boolean exists(String tenantId, URI uri) {
        return Files.exists(this.getPath(tenantId, uri), new LinkOption[0]);
    }

    public List<FileAttributes> list(String tenantId, URI uri) throws IOException {
        List<FileAttributes> list;
        block8: {
            Stream<Path> stream = Files.list(this.getPath(tenantId, uri));
            try {
                list = stream.map(Rethrow.throwFunction(file -> {
                    URI relative = URI.create(this.getPath(tenantId, null).relativize(Path.of(file.toUri())).toString());
                    return this.getAttributes(tenantId, relative);
                })).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
            }
            stream.close();
        }
        return list;
    }

    public Long size(String tenantId, URI uri) throws IOException {
        try {
            return Files.size(this.getPath(tenantId, uri));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("Unable to find file at '" + uri + "'");
        }
        catch (IOException e) {
            throw new IOException("Unable to find file at '" + uri + "' with message '" + e.getMessage() + "'");
        }
    }

    public Long lastModifiedTime(String tenantId, URI uri) throws IOException {
        FileTime lastModifiedTime;
        try {
            lastModifiedTime = Files.getLastModifiedTime(this.getPath(tenantId, uri), new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return lastModifiedTime.toMillis();
    }

    public URI put(String tenantId, URI uri, InputStream data) throws IOException {
        File file = this.getPath(tenantId, uri).toFile();
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + parent.getAbsolutePath());
        }
        try (InputStream inputStream = data;
             FileOutputStream outStream = new FileOutputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = data.read(buffer)) != -1) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
        return URI.create("kestra://" + uri.getPath());
    }

    public FileAttributes getAttributes(String tenantId, URI uri) throws IOException {
        Path path = this.getPath(tenantId, uri);
        try {
            return LocalFileAttributes.builder().fileName(path.getFileName().toString()).basicFileAttributes(Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0])).build();
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public URI createDirectory(String tenantId, URI uri) {
        if (uri == null || uri.getPath().isEmpty()) {
            throw new IllegalArgumentException("Unable to create a directory with empty url.");
        }
        File file = this.getPath(tenantId, uri).toFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getAbsolutePath());
        }
        return URI.create("kestra://" + uri.getPath());
    }

    public URI move(String tenantId, URI from, URI to) throws IOException {
        try {
            Files.move(this.getPath(tenantId, from), this.getPath(tenantId, to), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return URI.create("kestra://" + to.getPath());
    }

    public boolean delete(String tenantId, URI uri) throws IOException {
        Path path = this.getPath(tenantId, uri);
        File file = path.toFile();
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        return Files.deleteIfExists(path);
    }

    public List<URI> deleteByPrefix(String tenantId, URI storagePrefix) throws IOException {
        Path path = this.getPath(tenantId, storagePrefix);
        if (!path.toFile().exists()) {
            return List.of();
        }
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            List<URI> list = walk.sorted(Comparator.reverseOrder()).map(Path::toFile).peek(File::delete).map(r -> this.getKestraUri(tenantId, r.toPath())).toList();
            return list;
        }
    }

    private URI getKestraUri(String tenantId, Path path) {
        Path prefix = tenantId == null ? this.config.getBasePath().toAbsolutePath() : Path.of(this.config.getBasePath().toAbsolutePath().toString(), tenantId);
        return URI.create("kestra:///" + prefix.relativize(path));
    }

    private void parentTraversalGuard(URI uri) {
        if (uri.toString().contains("..")) {
            throw new IllegalArgumentException("File should be accessed with their full path and not using relative '..' path.");
        }
    }
}

