/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.storage.local;

import io.kestra.core.storages.FileAttributes;
import java.beans.ConstructorProperties;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.Generated;

public final class LocalFileAttributes
implements FileAttributes {
    private final String fileName;
    private final BasicFileAttributes basicFileAttributes;

    public long getLastModifiedTime() {
        return this.basicFileAttributes.lastModifiedTime().toMillis();
    }

    public long getCreationTime() {
        return this.basicFileAttributes.creationTime().toMillis();
    }

    public FileAttributes.FileType getType() {
        if (this.basicFileAttributes.isRegularFile()) {
            return FileAttributes.FileType.File;
        }
        if (this.basicFileAttributes.isDirectory()) {
            return FileAttributes.FileType.Directory;
        }
        throw new RuntimeException("Unknown type for file %s".formatted(this.fileName));
    }

    public long getSize() {
        return this.basicFileAttributes.size();
    }

    @ConstructorProperties(value={"fileName", "basicFileAttributes"})
    @Generated
    LocalFileAttributes(String fileName, BasicFileAttributes basicFileAttributes) {
        this.fileName = fileName;
        this.basicFileAttributes = basicFileAttributes;
    }

    @Generated
    public static LocalFileAttributesBuilder builder() {
        return new LocalFileAttributesBuilder();
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public BasicFileAttributes getBasicFileAttributes() {
        return this.basicFileAttributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalFileAttributes)) {
            return false;
        }
        LocalFileAttributes other = (LocalFileAttributes)o;
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        BasicFileAttributes this$basicFileAttributes = this.getBasicFileAttributes();
        BasicFileAttributes other$basicFileAttributes = other.getBasicFileAttributes();
        return !(this$basicFileAttributes == null ? other$basicFileAttributes != null : !this$basicFileAttributes.equals(other$basicFileAttributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        BasicFileAttributes $basicFileAttributes = this.getBasicFileAttributes();
        result = result * 59 + ($basicFileAttributes == null ? 43 : $basicFileAttributes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalFileAttributes(fileName=" + this.getFileName() + ", basicFileAttributes=" + this.getBasicFileAttributes() + ")";
    }

    @Generated
    public static class LocalFileAttributesBuilder {
        @Generated
        private String fileName;
        @Generated
        private BasicFileAttributes basicFileAttributes;

        @Generated
        LocalFileAttributesBuilder() {
        }

        @Generated
        public LocalFileAttributesBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Generated
        public LocalFileAttributesBuilder basicFileAttributes(BasicFileAttributes basicFileAttributes) {
            this.basicFileAttributes = basicFileAttributes;
            return this;
        }

        @Generated
        public LocalFileAttributes build() {
            return new LocalFileAttributes(this.fileName, this.basicFileAttributes);
        }

        @Generated
        public String toString() {
            return "LocalFileAttributes.LocalFileAttributesBuilder(fileName=" + this.fileName + ", basicFileAttributes=" + this.basicFileAttributes + ")";
        }
    }
}

