/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.memory;

import io.micronaut.configuration.jdbc.hikari.DatasourceConfiguration;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.flyway.FlywayConfigurationProperties;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;

@Factory
@Requires(missingProperty="datasources", condition=H2RepositoryOrQueue.class)
public class DatasourceProvider {
    @Singleton
    @Named(value="h2")
    public CustomDatasourceConfiguration getDatasourceConfiguration() {
        CustomDatasourceConfiguration memory = new CustomDatasourceConfiguration("h2");
        memory.setUrl("jdbc:h2:mem:public");
        memory.setUsername("sa");
        memory.setPassword("");
        memory.setDriverClassName("org.h2.Driver");
        return memory;
    }

    @Singleton
    @Named(value="h2")
    public CustomFlywayConfiguration getFlywayConfiguration() {
        CustomFlywayConfiguration flyway = new CustomFlywayConfiguration("h2");
        flyway.setEnabled(true);
        flyway.setLocations(new String[]{"classpath:migrations/h2"});
        flyway.setIgnoreMigrationPatterns(new String[]{"*:missing", "*:future"});
        flyway.getProperties().put("outOfOrder", "true");
        return flyway;
    }

    public static class CustomDatasourceConfiguration
    extends DatasourceConfiguration {
        public CustomDatasourceConfiguration(String name) {
            super(name);
        }
    }

    public static class CustomFlywayConfiguration
    extends FlywayConfigurationProperties {
        public CustomFlywayConfiguration(String name) {
            super(name);
        }
    }

    public static class H2RepositoryOrQueue
    implements Condition {
        public boolean matches(ConditionContext context) {
            Optional repositoryType = context.getProperty("kestra.repository.type", String.class);
            if (repositoryType.isPresent() && (((String)repositoryType.get()).equals("h2") || ((String)repositoryType.get()).equals("memory"))) {
                return true;
            }
            Optional queueType = context.getProperty("kestra.queue.type", String.class);
            return queueType.isPresent() && (((String)queueType.get()).equals("h2") || ((String)queueType.get()).equals("memory"));
        }
    }
}

