/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.memory;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.serializers.YamlParser;
import jakarta.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@KestraTest
public class MemoryRepositoryTest {
    @Inject
    private YamlParser yamlParser;
    @Inject
    private FlowRepositoryInterface flowRepositoryInterface;

    @Test
    void verifyMemoryFallbacksToH2() {
        MatcherAssert.assertThat((Object)this.flowRepositoryInterface.findAll(null).size(), (Matcher)Matchers.is((Object)0));
        String flowSource = "id: some-flow\nnamespace: some.namespace\ntasks:\n  - id: some-task\n    type: io.kestra.core.tasks.debugs.Return\n    format: \"Hello, World!\"";
        Flow flow = (Flow)this.yamlParser.parse(flowSource, Flow.class);
        this.flowRepositoryInterface.create(flow, flowSource, flow);
        MatcherAssert.assertThat((Object)this.flowRepositoryInterface.findAll(null).size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((FlowWithSource)this.flowRepositoryInterface.findByIdWithSource(null, "some.namespace", "some-flow").get()).getSource(), (Matcher)Matchers.is((Object)flowSource));
    }
}

