/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import com.unboundid.ldif.LDIFReader;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import java.io.IOException;
import java.net.URI;

public final class Utils {
    public static URI resolveKestraUri(String file, RunContext runContext) throws IllegalVariableEvaluationException, NullPointerException, IllegalArgumentException {
        try {
            return URI.create(runContext.render(file));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            runContext.logger().error("Invalid URI syntax: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static LDIFReader getLDIFReaderFromUri(String file, RunContext runContext) throws IOException, IllegalVariableEvaluationException, NullPointerException, IllegalArgumentException {
        URI resolvedUri = Utils.resolveKestraUri(file, runContext);
        return new LDIFReader(runContext.storage().getFile(resolvedUri));
    }

    public static IonReader getIONReaderFromUri(String file, RunContext runContext) throws IonException, IllegalArgumentException, IOException, IllegalVariableEvaluationException, NullPointerException {
        URI resolvedUri = Utils.resolveKestraUri(file, runContext);
        IonSystem ionSystem = IonSystemBuilder.standard().build();
        return ionSystem.newReader(runContext.storage().getFile(resolvedUri));
    }
}

