/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.ldap.LdapConnection;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Retrieves entries in LDAP.", description="Search and list entries based on a filter list for each base DN target.")
@Plugin(examples={@Example(title="Retrieve LDAP entries.\nIn this example, assuming that their is exactly one entry matching each of our filter,\nthe outputs of the task would be four entries in this order (since we search two times in the same baseDn) :\n(dn, description, mail) of {melusine, metatron, melusine, metatron}.", full=true, code={"id: ldap_search\nnamespace: company.team\n\ntasks:\n  - id: search\n    type: io.kestra.plugin.ldap.Search\n    userDn: cn=admin,dc=orga,dc=en\n    password: admin\n    baseDn: ou=people,dc=orga,dc=en\n    filter: (|(sn=melusine*)(sn=metatron*))\n    attributes:\n      - description\n      - mail\n    hostname: 0.0.0.0\n    port: 15060\n"})})
public class Search
extends LdapConnection
implements RunnableTask<Output> {
    @Schema(title="Filter", description="Filter for the search in the LDAP.")
    @PluginProperty(dynamic=true)
    private String filter;
    @Schema(title="Attributes", description="Specific attributes to retrieve from the filtered entries. Retrieves all attributes by default.\nSepcial attributes may be specified :\n\"+\"   -> OPERATIONAL_ATTRIBUTES\n\"1.1\" -> NO_ATTRIBUTES\n\"0.0\" -> ALL_ATTRIBUTES_EXCEPT_OPERATIONAL\n    `--> This special attribute canno't be combined with other attributes and the search will ignore everything else.\n")
    @PluginProperty
    private List<String> attributes;
    @Schema(title="Base DN", description="Base DN target in the LDAP.")
    @PluginProperty(dynamic=true)
    private String baseDn;
    @Schema(title="SUB", description="Search scope of the filter :\nBASE -- Indicates that only the entry specified by the base DN should be considered.\nONE -- Indicates that only entries that are immediate subordinates of the entry specified by the base DN (but not the base entry itself) should be considered.\nSUB -- Indicates that the base entry itself and any subordinate entries (to any depth) should be considered.\nSUBORDINATE_SUBTREE -- Indicates that any subordinate entries (to any depth) below the entry specified by the base DN should be considered, but the base entry itself should not be considered, as described in draft-sermersheim-ldap-subordinate-scope.")
    @PluginProperty
    private SearchScope sub;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        ArrayList<String> results = new ArrayList<String>();
        URI storedResults = null;
        Integer entriesFound = 0;
        Long searchTime = 0L;
        try (LDAPConnection connection = this.getLdapConnection(runContext);){
            this.filter = runContext.render(this.filter).replaceAll("\n\\s*", "");
            SearchRequest request = new SearchRequest(runContext.render(this.baseDn), this.sub, this.filter, this.attributes.contains("0.0") ? SearchRequest.REQUEST_ATTRS_DEFAULT : this.attributes.toArray(new String[0]));
            Long startTime = System.currentTimeMillis();
            SearchResult result = connection.search(request);
            if (result.getResultCode() == ResultCode.SUCCESS) {
                searchTime = System.currentTimeMillis() - startTime;
                for (SearchResultEntry entry : result.getSearchEntries()) {
                    results.add(entry.toLDIFString());
                    Integer n = entriesFound;
                    entriesFound = entriesFound + 1;
                }
                File tempfile = runContext.workingDir().createTempFile(String.join((CharSequence)"\n", results).getBytes(), ".ldif").toFile();
                storedResults = runContext.storage().putFile(tempfile);
            } else {
                logger.warn("Search failed with filter {}, LDAP response : {}", (Object)this.filter, (Object)result.getResultString());
            }
        }
        catch (LDAPException e) {
            logger.error("LDAP error: {}", (Object)e.getResultString());
            throw e;
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"entries.found", (Integer)entriesFound, (String[])new String[]{"origin", "retrieve"}));
        runContext.metric((AbstractMetricEntry)Timer.of((String)"searche.meanTime", (Duration)Duration.ofMillis(searchTime), (String[])new String[]{"origin", "retrieve"}));
        return Output.builder().uri(storedResults).build();
    }

    @Generated
    private static String $default$filter() {
        return "(objectclass=*)";
    }

    @Generated
    private static List<String> $default$attributes() {
        return Arrays.asList("*");
    }

    @Generated
    private static String $default$baseDn() {
        return "ou=system";
    }

    @Generated
    private static SearchScope $default$sub() {
        return SearchScope.SUB;
    }

    @Generated
    protected Search(SearchBuilder<?, ?> b) {
        super(b);
        this.filter = b.filter$set ? b.filter$value : Search.$default$filter();
        this.attributes = b.attributes$set ? b.attributes$value : Search.$default$attributes();
        this.baseDn = b.baseDn$set ? b.baseDn$value : Search.$default$baseDn();
        this.sub = b.sub$set ? b.sub$value : Search.$default$sub();
    }

    @Generated
    public static SearchBuilder<?, ?> builder() {
        return new SearchBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Search(super=" + super.toString() + ", filter=" + this.getFilter() + ", attributes=" + String.valueOf(this.getAttributes()) + ", baseDn=" + this.getBaseDn() + ", sub=" + String.valueOf(this.getSub()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Search)) {
            return false;
        }
        Search other = (Search)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$baseDn = this.getBaseDn();
        String other$baseDn = other.getBaseDn();
        if (this$baseDn == null ? other$baseDn != null : !this$baseDn.equals(other$baseDn)) {
            return false;
        }
        SearchScope this$sub = this.getSub();
        SearchScope other$sub = other.getSub();
        return !(this$sub == null ? other$sub != null : !((Object)this$sub).equals(other$sub));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Search;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $baseDn = this.getBaseDn();
        result = result * 59 + ($baseDn == null ? 43 : $baseDn.hashCode());
        SearchScope $sub = this.getSub();
        result = result * 59 + ($sub == null ? 43 : ((Object)$sub).hashCode());
        return result;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getBaseDn() {
        return this.baseDn;
    }

    @Generated
    public SearchScope getSub() {
        return this.sub;
    }

    @Generated
    public Search() {
        this.filter = Search.$default$filter();
        this.attributes = Search.$default$attributes();
        this.baseDn = Search.$default$baseDn();
        this.sub = Search.$default$sub();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Result file URI", description="A file that contains zero or more matching queries as LDIF formatted strings.")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Search.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class SearchBuilder<C extends Search, B extends SearchBuilder<C, B>>
    extends LdapConnection.LdapConnectionBuilder<C, B> {
        @Generated
        private boolean filter$set;
        @Generated
        private String filter$value;
        @Generated
        private boolean attributes$set;
        @Generated
        private List<String> attributes$value;
        @Generated
        private boolean baseDn$set;
        @Generated
        private String baseDn$value;
        @Generated
        private boolean sub$set;
        @Generated
        private SearchScope sub$value;

        @Generated
        public B filter(String filter) {
            this.filter$value = filter;
            this.filter$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B attributes(List<String> attributes) {
            this.attributes$value = attributes;
            this.attributes$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B baseDn(String baseDn) {
            this.baseDn$value = baseDn;
            this.baseDn$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B sub(SearchScope sub) {
            this.sub$value = sub;
            this.sub$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Search.SearchBuilder(super=" + super.toString() + ", filter$value=" + this.filter$value + ", attributes$value=" + String.valueOf(this.attributes$value) + ", baseDn$value=" + this.baseDn$value + ", sub$value=" + String.valueOf(this.sub$value) + ")";
        }
    }

    @Generated
    private static final class SearchBuilderImpl
    extends SearchBuilder<Search, SearchBuilderImpl> {
        @Generated
        private SearchBuilderImpl() {
        }

        @Override
        @Generated
        protected SearchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Search build() {
            return new Search(this);
        }
    }
}

