/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.ldap.LdapConnection;
import io.kestra.plugin.ldap.Utils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Modify entries in LDAP.", description="Modify, Delete or Add attributes or DNs following LDIF changeType fields of each entries provided.")
@Plugin(examples={@Example(title="Modify entries in LDAP server.", full=true, code={"id: ldap_modify\nnamespace: company.team\n\ntasks:\n  - id: modify\n    type: io.kestra.plugin.ldap.Modify\n    userDn: cn=admin,dc=orga,dc=en\n    password: admin\n    inputs:\n       - \"{{ outputs.some_task.uri_of_ldif_change_record_formated_file }}\"\n    hostname: 0.0.0.0\n    port: 18060\n"})})
public class Modify
extends LdapConnection
implements RunnableTask<VoidOutput> {
    @Schema(title="URI(s) of input file(s)", description="List of URI(s) of file(s) containing LDIF formatted entries to modify into LDAP. Entries must provide a changeType field.")
    @PluginProperty(dynamic=true)
    @NotNull
    private List<String> inputs;
    private Logger logger;
    private Integer modificationsDone;
    private Integer modificationRequests;
    private List<Long> modificationsTimes;

    public VoidOutput run(RunContext runContext) throws Exception {
        this.logger = runContext.logger();
        try (LDAPConnection connection = this.getLdapConnection(runContext);){
            for (String inputUri : this.inputs) {
                try {
                    LDIFReader reader = Utils.getLDIFReaderFromUri(inputUri, runContext);
                    try {
                        this.processEntries(reader, connection);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error reading LDIF file {} : {}", (Object)inputUri, (Object)e.getMessage());
                }
            }
        }
        catch (LDAPException e) {
            this.logger.error("LDAP error: {}", (Object)e.getResultString());
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"modifications.requested", (Integer)this.modificationRequests, (String[])new String[]{"origin", "input"}));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"modifications.done", (Integer)this.modificationsDone, (String[])new String[]{"origin", "input"}));
        if (!this.modificationsTimes.isEmpty()) {
            Long meanTime = this.modificationsTimes.stream().mapToLong(Long::longValue).sum() / (long)this.modificationsDone.intValue();
            runContext.metric((AbstractMetricEntry)Timer.of((String)"modifications.meanTime", (Duration)Duration.ofMillis(meanTime), (String[])new String[]{"origin", "input"}));
        }
        return new VoidOutput();
    }

    private void processEntries(LDIFReader reader, LDAPConnection connection) throws LDAPException, IOException, LDIFException {
        while (true) {
            LDIFChangeRecord entry = null;
            try {
                entry = reader.readChangeRecord();
            }
            catch (LDIFException e) {
                this.logger.error("Cannot read entry: {}", e.getDataLines());
                continue;
            }
            if (entry == null) break;
            Integer e = this.modificationRequests;
            this.modificationRequests = this.modificationRequests + 1;
            long startTime = System.currentTimeMillis();
            try {
                LDAPResult result = entry.processChange(connection);
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.modificationsTimes.add(System.currentTimeMillis() - startTime);
                    Integer n = this.modificationsDone;
                    this.modificationsDone = this.modificationsDone + 1;
                    continue;
                }
                this.logger.warn("Cannot modify entry: {}, LDAP response: {}", (Object)entry.toLDIF(), (Object)result.getResultString());
            }
            catch (LDAPException e2) {
                this.logger.error("Error modifying entry {}: {}", (Object)entry.getDN(), (Object)e2.getResultString());
            }
        }
    }

    @Generated
    private static Logger $default$logger() {
        return null;
    }

    @Generated
    private static Integer $default$modificationsDone() {
        return 0;
    }

    @Generated
    private static Integer $default$modificationRequests() {
        return 0;
    }

    @Generated
    private static List<Long> $default$modificationsTimes() {
        return new ArrayList<Long>();
    }

    @Generated
    protected Modify(ModifyBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.logger = b.logger$set ? b.logger$value : Modify.$default$logger();
        this.modificationsDone = b.modificationsDone$set ? b.modificationsDone$value : Modify.$default$modificationsDone();
        this.modificationRequests = b.modificationRequests$set ? b.modificationRequests$value : Modify.$default$modificationRequests();
        this.modificationsTimes = b.modificationsTimes$set ? b.modificationsTimes$value : Modify.$default$modificationsTimes();
    }

    @Generated
    public static ModifyBuilder<?, ?> builder() {
        return new ModifyBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Modify(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", logger=" + String.valueOf(this.logger) + ", modificationsDone=" + this.modificationsDone + ", modificationRequests=" + this.modificationRequests + ", modificationsTimes=" + String.valueOf(this.modificationsTimes) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modify)) {
            return false;
        }
        Modify other = (Modify)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$modificationsDone = this.modificationsDone;
        Integer other$modificationsDone = other.modificationsDone;
        if (this$modificationsDone == null ? other$modificationsDone != null : !((Object)this$modificationsDone).equals(other$modificationsDone)) {
            return false;
        }
        Integer this$modificationRequests = this.modificationRequests;
        Integer other$modificationRequests = other.modificationRequests;
        if (this$modificationRequests == null ? other$modificationRequests != null : !((Object)this$modificationRequests).equals(other$modificationRequests)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        List<Long> this$modificationsTimes = this.modificationsTimes;
        List<Long> other$modificationsTimes = other.modificationsTimes;
        return !(this$modificationsTimes == null ? other$modificationsTimes != null : !((Object)this$modificationsTimes).equals(other$modificationsTimes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Modify;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $modificationsDone = this.modificationsDone;
        result = result * 59 + ($modificationsDone == null ? 43 : ((Object)$modificationsDone).hashCode());
        Integer $modificationRequests = this.modificationRequests;
        result = result * 59 + ($modificationRequests == null ? 43 : ((Object)$modificationRequests).hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        List<Long> $modificationsTimes = this.modificationsTimes;
        result = result * 59 + ($modificationsTimes == null ? 43 : ((Object)$modificationsTimes).hashCode());
        return result;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public Modify() {
        this.logger = Modify.$default$logger();
        this.modificationsDone = Modify.$default$modificationsDone();
        this.modificationRequests = Modify.$default$modificationRequests();
        this.modificationsTimes = Modify.$default$modificationsTimes();
    }

    @Generated
    public static abstract class ModifyBuilder<C extends Modify, B extends ModifyBuilder<C, B>>
    extends LdapConnection.LdapConnectionBuilder<C, B> {
        @Generated
        private List<String> inputs;
        @Generated
        private boolean logger$set;
        @Generated
        private Logger logger$value;
        @Generated
        private boolean modificationsDone$set;
        @Generated
        private Integer modificationsDone$value;
        @Generated
        private boolean modificationRequests$set;
        @Generated
        private Integer modificationRequests$value;
        @Generated
        private boolean modificationsTimes$set;
        @Generated
        private List<Long> modificationsTimes$value;

        @Generated
        public B inputs(List<String> inputs) {
            this.inputs = inputs;
            return (B)((Object)this.self());
        }

        @Generated
        public B logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B modificationsDone(Integer modificationsDone) {
            this.modificationsDone$value = modificationsDone;
            this.modificationsDone$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B modificationRequests(Integer modificationRequests) {
            this.modificationRequests$value = modificationRequests;
            this.modificationRequests$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B modificationsTimes(List<Long> modificationsTimes) {
            this.modificationsTimes$value = modificationsTimes;
            this.modificationsTimes$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Modify.ModifyBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", logger$value=" + String.valueOf(this.logger$value) + ", modificationsDone$value=" + this.modificationsDone$value + ", modificationRequests$value=" + this.modificationRequests$value + ", modificationsTimes$value=" + String.valueOf(this.modificationsTimes$value) + ")";
        }
    }

    @Generated
    private static final class ModifyBuilderImpl
    extends ModifyBuilder<Modify, ModifyBuilderImpl> {
        @Generated
        private ModifyBuilderImpl() {
        }

        @Override
        @Generated
        protected ModifyBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Modify build() {
            return new Modify(this);
        }
    }
}

