/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFRecord;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Ionise LDIF entries.", description="Transform .ldif files to .ion ones.")
@Plugin(examples={@Example(title="Make ION entries from LDIF ones.", full=true, code={"id: ldap_ldif_to_ion\nnamespace: company.team\n\ninputs:\n  - id: file1\n    type: FILE\n  - id: file2\n    type: FILE\n\ntasks:\n  - id: ldif_to_ion\n    type: io.kestra.plugin.ldap.LdifToIon\n    inputs:\n      - \"{{ inputs.file1 }}\"\n      - \"{{ inputs.file2 }}\"\n\n"}), @Example(title="INPUT example : here's an LDIF file content that may be inputted :", code={"# simple entry\ndn: cn=bob@orga.com,ou=diffusion_list,dc=orga,dc=com\ndescription: Some description\nsomeOtherAttribute: perhaps\ndescription: Some other description\nsomeOtherAttribute: perhapsAgain\n\n# modify changeRecord\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: modify\ndelete: description\ndescription: Some description 3\n-\nadd: description\ndescription: Some description 4\n-\nreplace: someOtherAttribute\nsomeOtherAttribute: Loves herself more\n-\n\n# delete changeRecord\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: delete\n\n# moddn and modrdn are equals, what's mandatory is to specify in the following order : newrdn -> deleteoldrdn -> (optional) newsuperior\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: modrdn\nnewrdn: cn=triss@orga.com\ndeleteoldrdn: 0\nnewsuperior: ou=expeople,dc=example,dc=com\n\n# moddn without new superior\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: moddn\nnewrdn: cn=triss@orga.com\ndeleteoldrdn: 1\n"}), @Example(title="OUTPUT example : here's an ION file content that may be outputted :", code={"# simple entry\n{dn:\"cn=bob@orga.com,ou=diffusion_list,dc=orga,dc=com\",attributes:{description:[\"Some description\",\"Some other description\"],someOtherAttribute:[\"perhaps\",\"perhapsAgain\"]}}\n# modify changeRecord\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"modify\",modifications:[{operation:\"DELETE\",attribute:\"description\",values:[\"Some description 3\"]},{operation:\"ADD\",attribute:\"description\",values:[\"Some description 4\"]},{operation:\"REPLACE\",attribute:\"someOtherAttribute\",values:[\"Loves herself more\"]}]}\n# delete changeRecord\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"delete\"}\n# moddn changeRecord (it is mandatory to specify a newrdn and a deleteoldrdn)\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"moddn\",newDn:{newrdn:\"cn=triss@orga.com\",deleteoldrdn:false,newsuperior:\"ou=expeople,dc=example,dc=com\"}}\n# moddn changeRecord without new superior (it is optional to specify a new superior field)\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"moddn\",newDn:{newrdn:\"cn=triss@orga.com\",deleteoldrdn:true}}\n"})})
public class LdifToIon
extends Task
implements RunnableTask<Output> {
    @Schema(title="URI(s) of file(s) containing LDIF entries.")
    @PluginProperty(dynamic=true)
    @NotNull
    private List<String> inputs;
    private Integer translateCount;
    private Integer entriesFound;
    private Logger logger;

    public Output run(RunContext runContext) throws Exception {
        this.logger = runContext.logger();
        ArrayList<URI> storedResults = new ArrayList<URI>();
        for (String path : this.inputs) {
            try {
                storedResults.add(this.transformLdifToIon(path, runContext));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        if (!this.inputs.isEmpty() && storedResults.isEmpty()) {
            throw new Exception("Not a single file has been translated.");
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"entries.found", (Integer)this.entriesFound, (String[])new String[]{"origin", "LdifToIon"}));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"entries.translated", (Integer)this.translateCount, (String[])new String[]{"origin", "LdifToIon"}));
        return Output.builder().urisList(storedResults).build();
    }

    /*
     * Exception decompiling
     */
    private URI transformLdifToIon(String ldifFilePath, RunContext runContext) throws IOException, IllegalVariableEvaluationException, NullPointerException, IllegalArgumentException, IllegalStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processEntries(LDIFReader ldifReader, IonWriter ionWriter) throws IOException, IllegalArgumentException {
        while (true) {
            String[] record = null;
            Entry entry = null;
            LDIFChangeRecord changeRecord = null;
            try {
                LDIFRecord ldifRecord = ldifReader.readLDIFRecord();
                if (ldifRecord == null) break;
                record = ldifRecord.toLDIF();
            }
            catch (LDIFException e) {
                this.logger.warn("Canno't read LDIF entry {}, {}", e.getDataLines(), (Object)e.getMessage());
                continue;
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
                continue;
            }
            try {
                changeRecord = LDIFReader.decodeChangeRecord(record);
            }
            catch (LDIFException e_change) {
                try {
                    entry = LDIFReader.decodeEntry(record);
                }
                catch (LDIFException e_entry) {
                    this.logger.warn("Translation failed, not an Entry nor a ChangeRecord : {}, {}, {}", new Object[]{record.toString(), e_entry.getMessage(), e_change.getMessage()});
                }
            }
            if (entry == null && changeRecord == null) break;
            Integer e_change = this.entriesFound;
            this.entriesFound = this.entriesFound + 1;
            try {
                if (entry != null) {
                    this.writeIonEntry(ionWriter, entry);
                } else {
                    this.writeIonChangeRecord(ionWriter, changeRecord);
                }
                e_change = this.translateCount;
                this.translateCount = this.translateCount + 1;
            }
            catch (IOException | IllegalArgumentException e) {
                this.logger.warn("Canno't write ION entry {}, {}", (Object)(entry == null ? changeRecord.toLDIFString() : entry.toLDIFString()), (Object)e.getMessage());
            }
        }
    }

    private void writeIonEntry(IonWriter ionWriter, Entry entry) throws IOException, IllegalArgumentException {
        ionWriter.stepIn(IonType.STRUCT);
        ionWriter.setFieldName("dn");
        ionWriter.writeString(entry.getDN());
        ionWriter.setFieldName("attributes");
        this.writeAttributes(ionWriter, entry.getAttributes());
        ionWriter.stepOut();
    }

    private void writeAttributes(IonWriter ionWriter, Collection<Attribute> attributes) throws IOException, IllegalArgumentException {
        ionWriter.stepIn(IonType.STRUCT);
        for (Attribute attribute : attributes) {
            ionWriter.setFieldName(attribute.getName());
            ionWriter.stepIn(IonType.LIST);
            for (String value : attribute.getValues()) {
                ionWriter.writeString(value);
            }
            ionWriter.stepOut();
        }
        ionWriter.stepOut();
    }

    private void writeIonChangeRecord(IonWriter ionWriter, LDIFChangeRecord changeRecord) throws IOException, IllegalArgumentException {
        ionWriter.stepIn(IonType.STRUCT);
        ionWriter.setFieldName("dn");
        ionWriter.writeString(changeRecord.getDN());
        ionWriter.setFieldName("changeType");
        ionWriter.writeString(changeRecord.getChangeType().toString());
        if (changeRecord.getChangeType() == ChangeType.MODIFY) {
            ionWriter.setFieldName("modifications");
            this.writeModifications(ionWriter, ((LDIFModifyChangeRecord)changeRecord).getModifications());
        } else if (changeRecord.getChangeType() == ChangeType.MODIFY_DN) {
            ionWriter.setFieldName("newDn");
            this.writeModifications(ionWriter, (LDIFModifyDNChangeRecord)changeRecord);
        } else if (changeRecord.getChangeType() == ChangeType.ADD) {
            ionWriter.setFieldName("attributes");
            this.writeAttributes(ionWriter, ((LDIFAddChangeRecord)changeRecord).getEntryToAdd().getAttributes());
        }
        ionWriter.stepOut();
    }

    private void writeModifications(IonWriter ionWriter, Modification[] modifications) throws IOException, IllegalArgumentException {
        ionWriter.stepIn(IonType.LIST);
        for (Modification modification : modifications) {
            ionWriter.stepIn(IonType.STRUCT);
            ionWriter.setFieldName("operation");
            ionWriter.writeString(modification.getModificationType().toString());
            ionWriter.setFieldName("attribute");
            ionWriter.writeString(modification.getAttributeName());
            ionWriter.setFieldName("values");
            ionWriter.stepIn(IonType.LIST);
            for (String value : modification.getValues()) {
                ionWriter.writeString(value);
            }
            ionWriter.stepOut();
            ionWriter.stepOut();
        }
        ionWriter.stepOut();
    }

    private void writeModifications(IonWriter ionWriter, LDIFModifyDNChangeRecord modifications) throws IOException, IllegalArgumentException {
        ionWriter.stepIn(IonType.STRUCT);
        ionWriter.setFieldName("newrdn");
        ionWriter.writeString(modifications.getNewRDN());
        ionWriter.setFieldName("deleteoldrdn");
        ionWriter.writeBool(modifications.deleteOldRDN());
        if (modifications.getNewSuperiorDN() != null) {
            ionWriter.setFieldName("newsuperior");
            ionWriter.writeString(modifications.getNewSuperiorDN());
        }
        ionWriter.stepOut();
    }

    @Generated
    private static Integer $default$translateCount() {
        return 0;
    }

    @Generated
    private static Integer $default$entriesFound() {
        return 0;
    }

    @Generated
    private static Logger $default$logger() {
        return null;
    }

    @Generated
    protected LdifToIon(LdifToIonBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.translateCount = b.translateCount$set ? b.translateCount$value : LdifToIon.$default$translateCount();
        this.entriesFound = b.entriesFound$set ? b.entriesFound$value : LdifToIon.$default$entriesFound();
        this.logger = b.logger$set ? b.logger$value : LdifToIon.$default$logger();
    }

    @Generated
    public static LdifToIonBuilder<?, ?> builder() {
        return new LdifToIonBuilderImpl();
    }

    @Generated
    public String toString() {
        return "LdifToIon(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", translateCount=" + this.translateCount + ", entriesFound=" + this.entriesFound + ", logger=" + String.valueOf(this.logger) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LdifToIon)) {
            return false;
        }
        LdifToIon other = (LdifToIon)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$translateCount = this.translateCount;
        Integer other$translateCount = other.translateCount;
        if (this$translateCount == null ? other$translateCount != null : !((Object)this$translateCount).equals(other$translateCount)) {
            return false;
        }
        Integer this$entriesFound = this.entriesFound;
        Integer other$entriesFound = other.entriesFound;
        if (this$entriesFound == null ? other$entriesFound != null : !((Object)this$entriesFound).equals(other$entriesFound)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LdifToIon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $translateCount = this.translateCount;
        result = result * 59 + ($translateCount == null ? 43 : ((Object)$translateCount).hashCode());
        Integer $entriesFound = this.entriesFound;
        result = result * 59 + ($entriesFound == null ? 43 : ((Object)$entriesFound).hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public LdifToIon() {
        this.translateCount = LdifToIon.$default$translateCount();
        this.entriesFound = LdifToIon.$default$entriesFound();
        this.logger = LdifToIon.$default$logger();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="URI(s) of ION translated file(s).")
        private final List<URI> urisList;

        @ConstructorProperties(value={"urisList"})
        @Generated
        Output(List<URI> urisList) {
            this.urisList = urisList;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUrisList() {
            return this.urisList;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> urisList;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder urisList(List<URI> urisList) {
                this.urisList = urisList;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.urisList);
            }

            @Generated
            public String toString() {
                return "LdifToIon.Output.OutputBuilder(urisList=" + String.valueOf(this.urisList) + ")";
            }
        }
    }

    @Generated
    public static abstract class LdifToIonBuilder<C extends LdifToIon, B extends LdifToIonBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<String> inputs;
        @Generated
        private boolean translateCount$set;
        @Generated
        private Integer translateCount$value;
        @Generated
        private boolean entriesFound$set;
        @Generated
        private Integer entriesFound$value;
        @Generated
        private boolean logger$set;
        @Generated
        private Logger logger$value;

        @Generated
        public B inputs(List<String> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B translateCount(Integer translateCount) {
            this.translateCount$value = translateCount;
            this.translateCount$set = true;
            return (B)this.self();
        }

        @Generated
        public B entriesFound(Integer entriesFound) {
            this.entriesFound$value = entriesFound;
            this.entriesFound$set = true;
            return (B)this.self();
        }

        @Generated
        public B logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LdifToIon.LdifToIonBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", translateCount$value=" + this.translateCount$value + ", entriesFound$value=" + this.entriesFound$value + ", logger$value=" + String.valueOf(this.logger$value) + ")";
        }
    }

    @Generated
    private static final class LdifToIonBuilderImpl
    extends LdifToIonBuilder<LdifToIon, LdifToIonBuilderImpl> {
        @Generated
        private LdifToIonBuilderImpl() {
        }

        @Override
        @Generated
        protected LdifToIonBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LdifToIon build() {
            return new LdifToIon(this);
        }
    }
}

