/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class LdapConnection
extends Task {
    @Schema(title="Hostname", description="Hostname for connection.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String hostname;
    @Schema(title="Port", description="A whole number describing the port for connection.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String port;
    @Schema(title="User", description="Username for connection.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String userDn;
    @Schema(title="Password", description="User password for connection.")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String password;
    @Schema(title="Authentication method", description="Authentication method to use with the LDAP server.", allowableValues={"simple", "gssapi"})
    @PluginProperty(dynamic=true)
    @NotNull
    protected String authMethod;
    @Schema(title="Kerberos key distribution center", description="Needed for GSSAPI authentication method.\nIf set, property realm must be set too.\nIf this is not provided, an attempt will be made to determine the appropriate value from the system configuration.")
    @PluginProperty(dynamic=true)
    protected String kdc;
    @Schema(title="Realm", description="Needed for GSSAPI authentication method.\nIf set, property kdc must be set too.\nIf this is not provided, an attempt will be made to determine the appropriate value from the system configuration.")
    @PluginProperty(dynamic=true)
    protected String realm;
    @Schema(title="SSL Configuration", description="Configure SSL/LDAPS connection parameters.")
    protected SslOptions sslOptions;

    protected LDAPConnection getLdapConnection(RunContext runContext) throws Exception, LDAPException, IllegalVariableEvaluationException {
        Logger logger = runContext.logger();
        String authMethodProperty = runContext.render(this.authMethod);
        boolean trustAllCertificates = this.sslOptions != null && runContext.render(this.sslOptions.getInsecureTrustAllCertificates()).as(Boolean.class).orElse(false) != false;
        try {
            LDAPConnection connection = this.createLdapConnection(this.hostname, Integer.parseInt(runContext.render(this.port)), trustAllCertificates);
            connection.bind(switch (authMethodProperty) {
                case "simple" -> new SimpleBindRequest(runContext.render(this.userDn), runContext.render(this.password));
                case "gssapi" -> {
                    String kdcProperty = runContext.render(this.kdc);
                    String realmProperty = runContext.render(this.realm);
                    GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(runContext.render(this.userDn), runContext.render(this.password));
                    if (kdcProperty == null && realmProperty != null || kdcProperty != null && realmProperty == null) {
                        throw new IllegalArgumentException("Property kdc and realm both must be set or neither must be set.");
                    }
                    if (kdcProperty != null) {
                        gssapiProperties.setKDCAddress(kdcProperty);
                    }
                    if (realmProperty != null) {
                        gssapiProperties.setRealm(realmProperty);
                    }
                    yield new GSSAPIBindRequest(gssapiProperties, new Control[0]);
                }
                default -> throw new IllegalArgumentException(String.format("Invalid authentication method \"%s\".", authMethodProperty));
            });
            return connection;
        }
        catch (LDAPException e) {
            logger.error("LDAP connextion error: {}", (Object)e.getResultString());
            throw e;
        }
    }

    public LDAPConnection createLdapConnection(String hostname, int port, boolean trustAllCertificates) throws LDAPException, GeneralSecurityException {
        LDAPConnection connection;
        if (trustAllCertificates) {
            SSLUtil sslUtil = new SSLUtil(new TrustAllTrustManager());
            SSLSocketFactory sslSocketFactory = sslUtil.createSSLSocketFactory();
            connection = new LDAPConnection(sslSocketFactory, hostname, port);
        } else {
            connection = new LDAPConnection(hostname, port);
        }
        return connection;
    }

    @Generated
    private static String $default$authMethod() {
        return "simple";
    }

    @Generated
    protected LdapConnection(LdapConnectionBuilder<?, ?> b) {
        super(b);
        this.hostname = b.hostname;
        this.port = b.port;
        this.userDn = b.userDn;
        this.password = b.password;
        this.authMethod = b.authMethod$set ? b.authMethod$value : LdapConnection.$default$authMethod();
        this.kdc = b.kdc;
        this.realm = b.realm;
        this.sslOptions = b.sslOptions;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getUserDn() {
        return this.userDn;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Generated
    public String getKdc() {
        return this.kdc;
    }

    @Generated
    public String getRealm() {
        return this.realm;
    }

    @Generated
    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    @Generated
    public LdapConnection() {
        this.authMethod = LdapConnection.$default$authMethod();
    }

    @Generated
    public static abstract class LdapConnectionBuilder<C extends LdapConnection, B extends LdapConnectionBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String hostname;
        @Generated
        private String port;
        @Generated
        private String userDn;
        @Generated
        private String password;
        @Generated
        private boolean authMethod$set;
        @Generated
        private String authMethod$value;
        @Generated
        private String kdc;
        @Generated
        private String realm;
        @Generated
        private SslOptions sslOptions;

        @Generated
        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        @Generated
        public B port(String port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B userDn(String userDn) {
            this.userDn = userDn;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B authMethod(String authMethod) {
            this.authMethod$value = authMethod;
            this.authMethod$set = true;
            return (B)this.self();
        }

        @Generated
        public B kdc(String kdc) {
            this.kdc = kdc;
            return (B)this.self();
        }

        @Generated
        public B realm(String realm) {
            this.realm = realm;
            return (B)this.self();
        }

        @Generated
        public B sslOptions(SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LdapConnection.LdapConnectionBuilder(super=" + super.toString() + ", hostname=" + this.hostname + ", port=" + this.port + ", userDn=" + this.userDn + ", password=" + this.password + ", authMethod$value=" + this.authMethod$value + ", kdc=" + this.kdc + ", realm=" + this.realm + ", sslOptions=" + String.valueOf(this.sslOptions) + ")";
        }
    }
}

