/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.UnknownSymbolException;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFDeleteChangeRecord;
import com.unboundid.ldif.LDIFModifyChangeRecord;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Unionises ION entries.", description="Transform .ion files to .ldif ones.")
@Plugin(examples={@Example(title="YAML: Make LDIF entries from ION ones.", full=true, code={"id: ldap_ion_to_ldif\nnamespace: company.team\n\ninputs:\n  - id: file1\n    type: FILE\n  - id: file2\n    type: FILE\n\ntasks:\n  - id: ion_to_ldiff\n    type: io.kestra.plugin.ldap.IonToLdif\n    inputs:\n      - \"{{ inputs.file1 }}\"\n      - \"{{ inputs.file2 }}\"\n"}), @Example(title="INPUT example: here's an ION file content that may be inputted :", code={"# simple entry\n{dn:\"cn=bob@orga.com,ou=diffusion_list,dc=orga,dc=com\",attributes:{description:[\"Some description\",\"Some other description\"],someOtherAttribute:[\"perhaps\",\"perhapsAgain\"]}}\n# modify changeRecord\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"modify\",modifications:[{operation:\"DELETE\",attribute:\"description\",values:[\"Some description 3\"]},{operation:\"ADD\",attribute:\"description\",values:[\"Some description 4\"]},{operation:\"REPLACE\",attribute:\"someOtherAttribute\",values:[\"Loves herself more\"]}]}\n# delete changeRecord\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"delete\"}\n# moddn changeRecord (it is mandatory to specify a newrdn and a deleteoldrdn)\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"moddn\",newDn:{newrdn:\"cn=triss@orga.com\",deleteoldrdn:false,newsuperior:\"ou=expeople,dc=example,dc=com\"}}\n# moddn changeRecord without new superior (it is optional to specify a new superior field)\n{dn:\"cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\",changeType:\"moddn\",newDn:{newrdn:\"cn=triss@orga.com\",deleteoldrdn:true}}\n"}, full=true), @Example(title="OUTPUT example: here's an LDIF file content that may be outputted :", code={"# simple entry\ndn: cn=bob@orga.com,ou=diffusion_list,dc=orga,dc=com\ndescription: Some description\nsomeOtherAttribute: perhaps\ndescription: Some other description\nsomeOtherAttribute: perhapsAgain\n\n# modify changeRecord\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: modify\ndelete: description\ndescription: Some description 3\n-\nadd: description\ndescription: Some description 4\n-\nreplace: someOtherAttribute\nsomeOtherAttribute: Loves herself more\n-\n\n# delete changeRecord\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: delete\n\n# moddn with new superior\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: moddn\nnewrdn: cn=triss@orga.com\ndeleteoldrdn: 0\nnewsuperior: ou=expeople,dc=example,dc=com\n\n# moddn without new superior\ndn: cn=triss@orga.com,ou=diffusion_list,dc=orga,dc=com\nchangetype: moddn\nnewrdn: cn=triss@orga.com\ndeleteoldrdn: 1\n"}, full=true)})
public class IonToLdif
extends Task
implements RunnableTask<Output> {
    @Schema(title="URI(s) of file(s) containing ION entries.")
    @PluginProperty(dynamic=true)
    @NotNull
    private List<String> inputs;
    private Integer count;
    private Integer found;
    private Logger logger;

    public Output run(RunContext runContext) throws Exception {
        this.logger = runContext.logger();
        ArrayList<URI> storedResults = new ArrayList<URI>();
        for (String path : this.inputs) {
            try {
                storedResults.add(this.transformIonToLdif(path, runContext));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        if (!this.inputs.isEmpty() && storedResults.isEmpty()) {
            throw new Exception("Not a single file has been translated.");
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"entries.found", (Integer)this.found, (String[])new String[]{"origin", "Ionise"}));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"entries.translated", (Integer)this.count, (String[])new String[]{"origin", "Ionise"}));
        return Output.builder().urisList(storedResults).build();
    }

    /*
     * Exception decompiling
     */
    private URI transformIonToLdif(String ionFilePath, RunContext runContext) throws IllegalStateException, IonException, IllegalArgumentException, IOException, IllegalVariableEvaluationException, NullPointerException, IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processIonEntries(IonReader ionReader, LDIFWriter ldifWriter) throws IOException, IllegalStateException {
        while (ionReader.next() != null) {
            ionReader.stepIn();
            LDIFRecord entry = null;
            Integer n = this.found;
            this.found = this.found + 1;
            try {
                entry = this.readIonEntry(ionReader);
            }
            catch (Exception e) {
                this.logger.error("Unable to read entry {}", (Object)e.getMessage());
            }
            if (entry != null) {
                try {
                    ldifWriter.writeLDIFRecord(entry);
                    Integer e = this.count;
                    this.count = this.count + 1;
                }
                catch (Exception e) {
                    this.logger.error("Unable to write entry {} : {}", (Object)entry.toString(), (Object)e.getMessage());
                }
            }
            ionReader.stepOut();
        }
    }

    private LDIFRecord readIonEntry(IonReader ionReader) throws UnknownSymbolException, IllegalStateException {
        String dn = null;
        List<Attribute> attributes = null;
        String changeType = null;
        List<Modification> modifications = null;
        NewDn newDn = null;
        while (ionReader.next() != null) {
            String fieldName = ionReader.getFieldName();
            if ("dn".equals(fieldName)) {
                dn = ionReader.stringValue();
                continue;
            }
            if ("attributes".equals(fieldName)) {
                ionReader.stepIn();
                attributes = this.readAttributes(ionReader);
                ionReader.stepOut();
                continue;
            }
            if ("changeType".equals(fieldName)) {
                changeType = ionReader.stringValue();
                continue;
            }
            if ("modifications".equals(fieldName) && "modify".equals(changeType)) {
                ionReader.stepIn();
                modifications = this.readModifications(ionReader);
                ionReader.stepOut();
                continue;
            }
            if ("newDn".equals(fieldName) && "moddn".equals(changeType)) {
                ionReader.stepIn();
                newDn = this.readNewDn(ionReader);
                ionReader.stepOut();
                continue;
            }
            this.logger.warn("Unrecognized field : {}", (Object)fieldName);
        }
        if (dn != null) {
            if (changeType == null) {
                return new Entry(dn, attributes);
            }
            if ("add".equals(changeType)) {
                return new LDIFAddChangeRecord(dn, attributes);
            }
            if ("delete".equals(changeType)) {
                return new LDIFDeleteChangeRecord(dn);
            }
            if ("modify".equals(changeType) && modifications != null) {
                return new LDIFModifyChangeRecord(dn, modifications.toArray(new Modification[0]));
            }
            if ("moddn".equals(changeType) && newDn != null) {
                return new LDIFModifyDNChangeRecord(dn, newDn.newRDN, newDn.deleteOldRDN, newDn.newsuperior);
            }
            this.logger.warn("Unable to make Ion entry from DN : {}, Attributes {}", (Object)dn, attributes);
        } else {
            this.logger.warn("Entry nb {} does not contain a DN", (Object)this.found);
        }
        return null;
    }

    private NewDn readNewDn(IonReader ionReader) throws UnknownSymbolException {
        String newRDN = null;
        Boolean deleteOldRDN = null;
        String newsuperior = null;
        while (ionReader.next() != null) {
            if (ionReader.getFieldName().equals("newrdn")) {
                newRDN = ionReader.stringValue();
                continue;
            }
            if (ionReader.getFieldName().equals("deleteoldrdn")) {
                deleteOldRDN = ionReader.booleanValue();
                continue;
            }
            if (!ionReader.getFieldName().equals("newsuperior")) continue;
            newsuperior = ionReader.stringValue();
        }
        return new NewDn(newRDN, deleteOldRDN, newsuperior);
    }

    private List<Modification> readModifications(IonReader ionReader) throws IllegalStateException, UnknownSymbolException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        while (ionReader.next() != null) {
            ionReader.stepIn();
            String operation = null;
            String attributeName = null;
            ArrayList<String> values = new ArrayList<String>();
            while (ionReader.next() != null) {
                String fieldName = ionReader.getFieldName();
                if ("operation".equals(fieldName)) {
                    operation = ionReader.stringValue();
                    continue;
                }
                if ("attribute".equals(fieldName)) {
                    attributeName = ionReader.stringValue();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    ionReader.stepIn();
                    while (ionReader.next() != null) {
                        values.add(ionReader.stringValue());
                    }
                    ionReader.stepOut();
                    continue;
                }
                this.logger.warn("Unrecognized field in modification: {}", (Object)fieldName);
            }
            if (operation != null && attributeName != null) {
                ModificationType modType = null;
                switch (operation) {
                    case "ADD": {
                        modType = ModificationType.ADD;
                        break;
                    }
                    case "DELETE": {
                        modType = ModificationType.DELETE;
                        break;
                    }
                    case "INCREMENT": {
                        modType = ModificationType.INCREMENT;
                        break;
                    }
                    case "REPLACE": {
                        modType = ModificationType.REPLACE;
                    }
                }
                modifications.add(new Modification(modType, attributeName, values.toArray(new String[0])));
            }
            ionReader.stepOut();
        }
        return modifications;
    }

    private List<Attribute> readAttributes(IonReader ionReader) throws IllegalStateException, UnknownSymbolException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        while (ionReader.next() != null) {
            String attributeName = ionReader.getFieldName();
            ionReader.stepIn();
            ArrayList<String> values = new ArrayList<String>();
            while (ionReader.next() != null) {
                values.add(ionReader.stringValue());
            }
            ionReader.stepOut();
            attributes.add(new Attribute(attributeName, values));
        }
        return attributes;
    }

    @Generated
    private static Integer $default$count() {
        return 0;
    }

    @Generated
    private static Integer $default$found() {
        return 0;
    }

    @Generated
    private static Logger $default$logger() {
        return null;
    }

    @Generated
    protected IonToLdif(IonToLdifBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.count = b.count$set ? b.count$value : IonToLdif.$default$count();
        this.found = b.found$set ? b.found$value : IonToLdif.$default$found();
        this.logger = b.logger$set ? b.logger$value : IonToLdif.$default$logger();
    }

    @Generated
    public static IonToLdifBuilder<?, ?> builder() {
        return new IonToLdifBuilderImpl();
    }

    @Generated
    public String toString() {
        return "IonToLdif(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", count=" + this.count + ", found=" + this.found + ", logger=" + String.valueOf(this.logger) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IonToLdif)) {
            return false;
        }
        IonToLdif other = (IonToLdif)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$count = this.count;
        Integer other$count = other.count;
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$found = this.found;
        Integer other$found = other.found;
        if (this$found == null ? other$found != null : !((Object)this$found).equals(other$found)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IonToLdif;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $count = this.count;
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $found = this.found;
        result = result * 59 + ($found == null ? 43 : ((Object)$found).hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public IonToLdif() {
        this.count = IonToLdif.$default$count();
        this.found = IonToLdif.$default$found();
        this.logger = IonToLdif.$default$logger();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="LDIF transformed file(s) URI(s).")
        private final List<URI> urisList;

        @ConstructorProperties(value={"urisList"})
        @Generated
        Output(List<URI> urisList) {
            this.urisList = urisList;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUrisList() {
            return this.urisList;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> urisList;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder urisList(List<URI> urisList) {
                this.urisList = urisList;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.urisList);
            }

            @Generated
            public String toString() {
                return "IonToLdif.Output.OutputBuilder(urisList=" + String.valueOf(this.urisList) + ")";
            }
        }
    }

    static class NewDn {
        @NotNull
        String newRDN;
        @NotNull
        Boolean deleteOldRDN;
        @Nullable
        String newsuperior;

        @ConstructorProperties(value={"newRDN", "deleteOldRDN", "newsuperior"})
        @Generated
        NewDn(String newRDN, Boolean deleteOldRDN, String newsuperior) {
            this.newRDN = newRDN;
            this.deleteOldRDN = deleteOldRDN;
            this.newsuperior = newsuperior;
        }

        @Generated
        public static NewDnBuilder builder() {
            return new NewDnBuilder();
        }

        @Generated
        public String getNewRDN() {
            return this.newRDN;
        }

        @Generated
        public Boolean getDeleteOldRDN() {
            return this.deleteOldRDN;
        }

        @Generated
        public String getNewsuperior() {
            return this.newsuperior;
        }

        @Generated
        public static class NewDnBuilder {
            @Generated
            private String newRDN;
            @Generated
            private Boolean deleteOldRDN;
            @Generated
            private String newsuperior;

            @Generated
            NewDnBuilder() {
            }

            @Generated
            public NewDnBuilder newRDN(String newRDN) {
                this.newRDN = newRDN;
                return this;
            }

            @Generated
            public NewDnBuilder deleteOldRDN(Boolean deleteOldRDN) {
                this.deleteOldRDN = deleteOldRDN;
                return this;
            }

            @Generated
            public NewDnBuilder newsuperior(String newsuperior) {
                this.newsuperior = newsuperior;
                return this;
            }

            @Generated
            public NewDn build() {
                return new NewDn(this.newRDN, this.deleteOldRDN, this.newsuperior);
            }

            @Generated
            public String toString() {
                return "IonToLdif.NewDn.NewDnBuilder(newRDN=" + this.newRDN + ", deleteOldRDN=" + this.deleteOldRDN + ", newsuperior=" + this.newsuperior + ")";
            }
        }
    }

    @Generated
    public static abstract class IonToLdifBuilder<C extends IonToLdif, B extends IonToLdifBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<String> inputs;
        @Generated
        private boolean count$set;
        @Generated
        private Integer count$value;
        @Generated
        private boolean found$set;
        @Generated
        private Integer found$value;
        @Generated
        private boolean logger$set;
        @Generated
        private Logger logger$value;

        @Generated
        public B inputs(List<String> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B count(Integer count) {
            this.count$value = count;
            this.count$set = true;
            return (B)this.self();
        }

        @Generated
        public B found(Integer found) {
            this.found$value = found;
            this.found$set = true;
            return (B)this.self();
        }

        @Generated
        public B logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IonToLdif.IonToLdifBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", count$value=" + this.count$value + ", found$value=" + this.found$value + ", logger$value=" + String.valueOf(this.logger$value) + ")";
        }
    }

    @Generated
    private static final class IonToLdifBuilderImpl
    extends IonToLdifBuilder<IonToLdif, IonToLdifBuilderImpl> {
        @Generated
        private IonToLdifBuilderImpl() {
        }

        @Override
        @Generated
        protected IonToLdifBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IonToLdif build() {
            return new IonToLdif(this);
        }
    }
}

