/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.ldap.LdapConnection;
import io.kestra.plugin.ldap.Utils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Remove entries in LDAP.", description="Remove entries based on a targeted DN list.")
@Plugin(examples={@Example(full=true, code={"id: ldap_delete\nnamespace: company.team\n\ntasks:\n  - id: delete\n    type: io.kestra.plugin.ldap.Delete\n    description: What your task is supposed to do and why.\n    userDn: cn=admin,dc=orga,dc=fr\n    password: admin\n    inputs:\n       - \"{{ outputs.some_task.uri_of_ldif_formated_file }}\"\n    hostname: 0.0.0.0\n    port: 15060\n"})})
public class Delete
extends LdapConnection
implements RunnableTask<VoidOutput> {
    @Schema(title="File(s) URI(s) containing Distinguished-Name(s)", description="Targeted DN(s) in the LDAP.")
    @PluginProperty(dynamic=true)
    @NotNull
    private List<String> inputs;
    private Integer deletionsDone;
    private Integer deletionRequests;
    private List<Long> deletionsTimes;
    private Logger logger;

    public VoidOutput run(RunContext runContext) throws Exception {
        this.logger = runContext.logger();
        try (LDAPConnection connection = this.getLdapConnection(runContext);){
            for (String file : this.inputs) {
                try {
                    LDIFReader reader = Utils.getLDIFReaderFromUri(file, runContext);
                    try {
                        this.processEntries(reader, connection);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Unable to process file {} completly : {}", (Object)file, (Object)e.getMessage());
                }
            }
        }
        catch (LDAPException e_l) {
            this.logger.error("LDAP error: {}", (Object)e_l.getMessage());
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"deletions.requested", (Integer)this.deletionRequests, (String[])new String[]{"origin", "delete"}));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"deletions.done", (Integer)this.deletionsDone, (String[])new String[]{"origin", "delete"}));
        if (!this.deletionsTimes.isEmpty()) {
            Long meanTime = this.deletionsTimes.stream().mapToLong(Long::longValue).sum() / (long)this.deletionsDone.intValue();
            runContext.metric((AbstractMetricEntry)Timer.of((String)"deletions.meanTime", (Duration)Duration.ofMillis(meanTime), (String[])new String[]{"origin", "delete"}));
        }
        return new VoidOutput();
    }

    private void processEntries(LDIFReader reader, LDAPConnection connection) throws IOException {
        while (true) {
            Entry entry = null;
            try {
                entry = reader.readEntry();
            }
            catch (LDIFException e) {
                this.logger.error("Cannot read entry: {}", e.getDataLines());
                continue;
            }
            if (entry == null) break;
            Integer e = this.deletionRequests;
            this.deletionRequests = this.deletionRequests + 1;
            String baseDn = entry.getDN();
            DeleteRequest deleteRequest = new DeleteRequest(baseDn);
            Long startMillis = System.currentTimeMillis();
            try {
                LDAPResult result = connection.delete(deleteRequest);
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.deletionsTimes.add(System.currentTimeMillis() - startMillis);
                    Integer n = this.deletionsDone;
                    this.deletionsDone = this.deletionsDone + 1;
                    continue;
                }
                this.logger.warn("Cannot remove entry '{}', LDAP response : {}", (Object)baseDn, (Object)result.getResultString());
            }
            catch (LDAPException e2) {
                this.logger.error("Error deleting DN '{}': {}", (Object)baseDn, (Object)e2.getMessage());
            }
        }
    }

    @Generated
    private static Integer $default$deletionsDone() {
        return 0;
    }

    @Generated
    private static Integer $default$deletionRequests() {
        return 0;
    }

    @Generated
    private static List<Long> $default$deletionsTimes() {
        return new ArrayList<Long>();
    }

    @Generated
    private static Logger $default$logger() {
        return null;
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.deletionsDone = b.deletionsDone$set ? b.deletionsDone$value : Delete.$default$deletionsDone();
        this.deletionRequests = b.deletionRequests$set ? b.deletionRequests$value : Delete.$default$deletionRequests();
        this.deletionsTimes = b.deletionsTimes$set ? b.deletionsTimes$value : Delete.$default$deletionsTimes();
        this.logger = b.logger$set ? b.logger$value : Delete.$default$logger();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", deletionsDone=" + this.deletionsDone + ", deletionRequests=" + this.deletionRequests + ", deletionsTimes=" + String.valueOf(this.deletionsTimes) + ", logger=" + String.valueOf(this.logger) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$deletionsDone = this.deletionsDone;
        Integer other$deletionsDone = other.deletionsDone;
        if (this$deletionsDone == null ? other$deletionsDone != null : !((Object)this$deletionsDone).equals(other$deletionsDone)) {
            return false;
        }
        Integer this$deletionRequests = this.deletionRequests;
        Integer other$deletionRequests = other.deletionRequests;
        if (this$deletionRequests == null ? other$deletionRequests != null : !((Object)this$deletionRequests).equals(other$deletionRequests)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<Long> this$deletionsTimes = this.deletionsTimes;
        List<Long> other$deletionsTimes = other.deletionsTimes;
        if (this$deletionsTimes == null ? other$deletionsTimes != null : !((Object)this$deletionsTimes).equals(other$deletionsTimes)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $deletionsDone = this.deletionsDone;
        result = result * 59 + ($deletionsDone == null ? 43 : ((Object)$deletionsDone).hashCode());
        Integer $deletionRequests = this.deletionRequests;
        result = result * 59 + ($deletionRequests == null ? 43 : ((Object)$deletionRequests).hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<Long> $deletionsTimes = this.deletionsTimes;
        result = result * 59 + ($deletionsTimes == null ? 43 : ((Object)$deletionsTimes).hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public Delete() {
        this.deletionsDone = Delete.$default$deletionsDone();
        this.deletionRequests = Delete.$default$deletionRequests();
        this.deletionsTimes = Delete.$default$deletionsTimes();
        this.logger = Delete.$default$logger();
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends LdapConnection.LdapConnectionBuilder<C, B> {
        @Generated
        private List<String> inputs;
        @Generated
        private boolean deletionsDone$set;
        @Generated
        private Integer deletionsDone$value;
        @Generated
        private boolean deletionRequests$set;
        @Generated
        private Integer deletionRequests$value;
        @Generated
        private boolean deletionsTimes$set;
        @Generated
        private List<Long> deletionsTimes$value;
        @Generated
        private boolean logger$set;
        @Generated
        private Logger logger$value;

        @Generated
        public B inputs(List<String> inputs) {
            this.inputs = inputs;
            return (B)((Object)this.self());
        }

        @Generated
        public B deletionsDone(Integer deletionsDone) {
            this.deletionsDone$value = deletionsDone;
            this.deletionsDone$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B deletionRequests(Integer deletionRequests) {
            this.deletionRequests$value = deletionRequests;
            this.deletionRequests$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B deletionsTimes(List<Long> deletionsTimes) {
            this.deletionsTimes$value = deletionsTimes;
            this.deletionsTimes$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", deletionsDone$value=" + this.deletionsDone$value + ", deletionRequests$value=" + this.deletionRequests$value + ", deletionsTimes$value=" + String.valueOf(this.deletionsTimes$value) + ", logger$value=" + String.valueOf(this.logger$value) + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

