/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.ldap;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.ldap.LdapConnection;
import io.kestra.plugin.ldap.Utils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Insert entries in LDAP.", description="Creates a new entry, if allowed, for each line of provided LDIF files.")
@Plugin(examples={@Example(title="Insert entries in LDAP server.", full=true, code={"id: ldap_add\nnamespace: company.team\n\ntasks:\n  - id: add\n    type: io.kestra.plugin.ldap.Add\n    description: What your task is supposed to do and why.\n    userDn: cn=admin,dc=orga,dc=en\n    password: admin\n    inputs:\n       - \"{{outputs.someTask.uri_of_ldif_formated_file}}\"\n    hostname: 0.0.0.0\n    port: 18060\n"})})
public class Add
extends LdapConnection
implements RunnableTask<VoidOutput> {
    @Schema(title="URI(s) of input file(s)", description="List of URI(s) of file(s) containing LDIF formatted entries to input into LDAP.")
    @PluginProperty(dynamic=true)
    @NotNull
    private List<String> inputs;
    private Integer additionsDone;
    private Integer additionRequests;
    private List<Long> additionsTimes;
    private Logger logger;

    public VoidOutput run(RunContext runContext) throws Exception {
        this.logger = runContext.logger();
        try (LDAPConnection connection = this.getLdapConnection(runContext);){
            for (String inputUri : this.inputs) {
                try {
                    LDIFReader reader = Utils.getLDIFReaderFromUri(inputUri, runContext);
                    try {
                        this.processEntries(reader, connection);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error reading LDIF file {} : {}", (Object)inputUri, (Object)e.getMessage());
                }
            }
        }
        catch (LDAPException e) {
            this.logger.error("LDAP error: {}", (Object)e.getResultString());
        }
        runContext.metric((AbstractMetricEntry)Counter.of((String)"additions.requested", (Integer)this.additionRequests, (String[])new String[]{"origin", "input"}));
        runContext.metric((AbstractMetricEntry)Counter.of((String)"additions.done", (Integer)this.additionsDone, (String[])new String[]{"origin", "input"}));
        if (!this.additionsTimes.isEmpty()) {
            Long meanTime = this.additionsTimes.stream().mapToLong(Long::longValue).sum() / (long)this.additionsDone.intValue();
            runContext.metric((AbstractMetricEntry)Timer.of((String)"additions.meanTime", (Duration)Duration.ofMillis(meanTime), (String[])new String[]{"origin", "input"}));
        }
        return new VoidOutput();
    }

    private void processEntries(LDIFReader reader, LDAPConnection connection) throws IOException {
        while (true) {
            Entry entry = null;
            try {
                entry = reader.readEntry();
            }
            catch (LDIFException e) {
                this.logger.error("Cannot read entry: {}", e.getDataLines());
                continue;
            }
            if (entry == null) break;
            Integer e = this.additionRequests;
            this.additionRequests = this.additionRequests + 1;
            Long startTime = System.currentTimeMillis();
            try {
                LDAPResult result = connection.add(entry);
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    this.additionsTimes.add(System.currentTimeMillis() - startTime);
                    Integer n = this.additionsDone;
                    this.additionsDone = this.additionsDone + 1;
                    continue;
                }
                this.logger.warn("Cannot add entry: {}, LDAP response: {}", (Object)entry.toLDIF(), (Object)result.getResultString());
            }
            catch (LDAPException e2) {
                this.logger.error("Error adding entry {}: {}", (Object)entry.getDN(), (Object)e2.getResultString());
            }
        }
    }

    @Generated
    private static Integer $default$additionsDone() {
        return 0;
    }

    @Generated
    private static Integer $default$additionRequests() {
        return 0;
    }

    @Generated
    private static List<Long> $default$additionsTimes() {
        return new ArrayList<Long>();
    }

    @Generated
    private static Logger $default$logger() {
        return null;
    }

    @Generated
    protected Add(AddBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.additionsDone = b.additionsDone$set ? b.additionsDone$value : Add.$default$additionsDone();
        this.additionRequests = b.additionRequests$set ? b.additionRequests$value : Add.$default$additionRequests();
        this.additionsTimes = b.additionsTimes$set ? b.additionsTimes$value : Add.$default$additionsTimes();
        this.logger = b.logger$set ? b.logger$value : Add.$default$logger();
    }

    @Generated
    public static AddBuilder<?, ?> builder() {
        return new AddBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Add(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", additionsDone=" + this.additionsDone + ", additionRequests=" + this.additionRequests + ", additionsTimes=" + String.valueOf(this.additionsTimes) + ", logger=" + String.valueOf(this.logger) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Add)) {
            return false;
        }
        Add other = (Add)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$additionsDone = this.additionsDone;
        Integer other$additionsDone = other.additionsDone;
        if (this$additionsDone == null ? other$additionsDone != null : !((Object)this$additionsDone).equals(other$additionsDone)) {
            return false;
        }
        Integer this$additionRequests = this.additionRequests;
        Integer other$additionRequests = other.additionRequests;
        if (this$additionRequests == null ? other$additionRequests != null : !((Object)this$additionRequests).equals(other$additionRequests)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<Long> this$additionsTimes = this.additionsTimes;
        List<Long> other$additionsTimes = other.additionsTimes;
        if (this$additionsTimes == null ? other$additionsTimes != null : !((Object)this$additionsTimes).equals(other$additionsTimes)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Add;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $additionsDone = this.additionsDone;
        result = result * 59 + ($additionsDone == null ? 43 : ((Object)$additionsDone).hashCode());
        Integer $additionRequests = this.additionRequests;
        result = result * 59 + ($additionRequests == null ? 43 : ((Object)$additionRequests).hashCode());
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<Long> $additionsTimes = this.additionsTimes;
        result = result * 59 + ($additionsTimes == null ? 43 : ((Object)$additionsTimes).hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    @Generated
    public List<String> getInputs() {
        return this.inputs;
    }

    @Generated
    public Add() {
        this.additionsDone = Add.$default$additionsDone();
        this.additionRequests = Add.$default$additionRequests();
        this.additionsTimes = Add.$default$additionsTimes();
        this.logger = Add.$default$logger();
    }

    @Generated
    public static abstract class AddBuilder<C extends Add, B extends AddBuilder<C, B>>
    extends LdapConnection.LdapConnectionBuilder<C, B> {
        @Generated
        private List<String> inputs;
        @Generated
        private boolean additionsDone$set;
        @Generated
        private Integer additionsDone$value;
        @Generated
        private boolean additionRequests$set;
        @Generated
        private Integer additionRequests$value;
        @Generated
        private boolean additionsTimes$set;
        @Generated
        private List<Long> additionsTimes$value;
        @Generated
        private boolean logger$set;
        @Generated
        private Logger logger$value;

        @Generated
        public B inputs(List<String> inputs) {
            this.inputs = inputs;
            return (B)((Object)this.self());
        }

        @Generated
        public B additionsDone(Integer additionsDone) {
            this.additionsDone$value = additionsDone;
            this.additionsDone$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B additionRequests(Integer additionRequests) {
            this.additionRequests$value = additionRequests;
            this.additionRequests$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B additionsTimes(List<Long> additionsTimes) {
            this.additionsTimes$value = additionsTimes;
            this.additionsTimes$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B logger(Logger logger) {
            this.logger$value = logger;
            this.logger$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Add.AddBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", additionsDone$value=" + this.additionsDone$value + ", additionRequests$value=" + this.additionRequests$value + ", additionsTimes$value=" + String.valueOf(this.additionsTimes$value) + ", logger$value=" + String.valueOf(this.logger$value) + ")";
        }
    }

    @Generated
    private static final class AddBuilderImpl
    extends AddBuilder<Add, AddBuilderImpl> {
        @Generated
        private AddBuilderImpl() {
        }

        @Override
        @Generated
        protected AddBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Add build() {
            return new Add(this);
        }
    }
}

