/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.vertica;

import com.vertica.jdbc.Driver;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractJdbcBaseQuery;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AbstractJdbcTrigger;
import io.kestra.plugin.jdbc.vertica.Query;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import lombok.Generated;

@Schema(title="Wait for query on a Vertica database.")
@Plugin(examples={@Example(title="Wait for a SQL query to return results, and then iterate through rows.", full=true, code={"id: jdbc_trigger\nnamespace: company.team\n\ntasks:\n  - id: each\n    type: io.kestra.plugin.core.flow.ForEach\n    values: \"{{ trigger.rows }}\"\n    tasks:\n      - id: return\n        type: io.kestra.plugin.core.debug.Return\n        format: \"{{ json(taskrun.value) }}\"\n\ntriggers:\n  - id: watch\n    type: io.kestra.plugin.jdbc.vertica.Trigger\n    interval: \"PT5M\"\n    url: jdbc:vertica://127.0.0.1:56982/db\n    username: vertica_user\n    password: vertica_password\n    sql: \"SELECT * FROM my_table\"\n    fetchType: FETCH\n"})})
public class Trigger
extends AbstractJdbcTrigger {
    @Override
    protected AbstractJdbcBaseQuery.Output runQuery(RunContext runContext) throws Exception {
        AbstractJdbcQuery query = ((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Object)((Query.QueryBuilder)((Query.QueryBuilder)Query.builder().id(this.id)).type(Query.class.getName())).url(this.getUrl()))).username(this.getUsername()))).password(this.getPassword()))).timeZoneId(this.getTimeZoneId()))).sql(this.getSql()))).fetch(this.isFetch()))).store(this.isStore()))).fetchOne(this.isFetchOne()))).fetchType((Property<FetchType>)Property.of((Object)this.renderFetchType(runContext))))).additionalVars(this.additionalVars))).parameters(this.getParameters()))).build();
        return ((Query)query).run(runContext);
    }

    @Override
    public void registerDriver() throws SQLException {
        DriverManager.registerDriver(new Driver());
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Trigger() {
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends AbstractJdbcTrigger.AbstractJdbcTriggerBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ")";
        }
    }
}

