/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.vertica;

import com.vertica.jdbc.Driver;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQueries;
import io.kestra.plugin.jdbc.vertica.VerticaCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;

@Schema(title="Perform multiple queries on a Vertica server.")
@Plugin(examples={@Example(title="Send SQL queries to a Vertica database, and fetch a row as output.", full=true, code={"id: vertica_queries\nnamespace: company.team\n\ntasks:\n  - id: queries\n    type: io.kestra.plugin.jdbc.vertica.Queries\n    url: jdbc:vertica://127.0.0.1:56982/db\n    username: vertica_user\n    password: vertica_password\n    sql: select * from customer\n    fetchType: FETCH_ONE\n"})})
public class Queries
extends AbstractJdbcQueries
implements RunnableTask<AbstractJdbcQueries.MultiQueryOutput> {
    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new VerticaCellConverter(zoneId);
    }

    @Override
    public void registerDriver() throws SQLException {
        DriverManager.registerDriver(new Driver());
    }

    @Generated
    protected Queries(QueriesBuilder<?, ?> b) {
        super((AbstractJdbcQueries.AbstractJdbcQueriesBuilder<?, ?>)b);
    }

    @Generated
    public static QueriesBuilder<?, ?> builder() {
        return new QueriesBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Queries(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queries)) {
            return false;
        }
        Queries other = (Queries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Queries;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Queries() {
    }

    @Generated
    private static final class QueriesBuilderImpl
    extends QueriesBuilder<Queries, QueriesBuilderImpl> {
        @Generated
        private QueriesBuilderImpl() {
        }

        @Override
        @Generated
        protected QueriesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Queries build() {
            return new Queries(this);
        }
    }

    @Generated
    public static abstract class QueriesBuilder<C extends Queries, B extends QueriesBuilder<C, B>>
    extends AbstractJdbcQueries.AbstractJdbcQueriesBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Queries.QueriesBuilder(super=" + super.toString() + ")";
        }
    }
}

