/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.JdbcStatementInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public abstract class AbstractJdbcBatch
extends Task
implements JdbcStatementInterface {
    private Property<String> url;
    private Property<String> username;
    private Property<String> password;
    private Property<String> timeZoneId;
    @NotNull
    @Schema(title="Source file URI")
    private Property<String> from;
    @NotNull
    @Schema(title="Insert query to be executed.", description="The query must have as many question marks as the number of columns in the table.\nExample: 'insert into <table_name> values( ? , ? , ? )' for 3 columns.\nIn case you do not want all columns, you need to specify it in the query in the columns property\nExample: 'insert into <table_name> (id, name) values( ? , ? )' for inserting data into 2 columns: 'id' and 'name'.")
    private Property<String> sql;
    @Schema(title="The size of chunk for every bulk request.")
    @NotNull
    private Property<Integer> chunk;
    @Schema(title="The columns to be inserted.", description="If not provided, `?` count need to match the `from` number of columns.")
    private Property<List<String>> columns;
    @Schema(title="The table from which column names will be retrieved.", description="This property specifies the table name which will be used to retrieve the columns for the inserted values.\nYou can use it instead of specifying manually the columns in the `columns` property. In this case, the `sql` property can also be omitted, an INSERT statement would be generated automatically.")
    private Property<String> table;

    protected abstract AbstractCellConverter getCellConverter(ZoneId var1);

    /*
     * Exception decompiling
     */
    public Output run(RunContext runContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String constructInsertStatement(RunContext runContext, String table, List<String> columns) throws IllegalVariableEvaluationException {
        return String.format("INSERT INTO %s (%s) VALUES (%s)", runContext.render(table), String.join((CharSequence)", ", columns), String.join((CharSequence)", ", Collections.nCopies(columns.size(), "?")));
    }

    private List<String> fetchColumnsFromTable(RunContext runContext, String table) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        try (Connection connection = this.connection(runContext);){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, null, table, null);){
                while (resultSet.next()) {
                    columns.add(resultSet.getString("COLUMN_NAME"));
                }
            }
        }
        return columns;
    }

    private void addBatch(PreparedStatement ps, ParameterType parameterMetaData, Object o, AbstractCellConverter cellConverter, Connection connection, RunContext runContext) throws Exception {
        if (o instanceof Map) {
            Map map = (Map)o;
            ListIterator iterKeys = new ArrayList(map.keySet()).listIterator();
            int index = 0;
            List columnsValue = (List)runContext.render(this.columns).asList(String.class);
            while (iterKeys.hasNext()) {
                String col = (String)iterKeys.next();
                if (!columnsValue.isEmpty() && !columnsValue.contains(col)) continue;
                ps = cellConverter.addPreparedStatementValue(ps, parameterMetaData, map.get(col), ++index, connection);
            }
        } else if (o instanceof Collection) {
            ListIterator iter = ((List)o).listIterator();
            while (iter.hasNext()) {
                ps = cellConverter.addPreparedStatementValue(ps, parameterMetaData, iter.next(), iter.nextIndex(), connection);
            }
        }
        ps.addBatch();
    }

    @Generated
    private static Property<Integer> $default$chunk() {
        return Property.of((Object)1000);
    }

    @Generated
    protected AbstractJdbcBatch(AbstractJdbcBatchBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.username = b.username;
        this.password = b.password;
        this.timeZoneId = b.timeZoneId;
        this.from = b.from;
        this.sql = b.sql;
        this.chunk = b.chunk$set ? b.chunk$value : AbstractJdbcBatch.$default$chunk();
        this.columns = b.columns;
        this.table = b.table;
    }

    @Generated
    public String toString() {
        return "AbstractJdbcBatch(super=" + super.toString() + ", url=" + String.valueOf(this.getUrl()) + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", timeZoneId=" + String.valueOf(this.getTimeZoneId()) + ", from=" + String.valueOf(this.getFrom()) + ", sql=" + String.valueOf(this.getSql()) + ", chunk=" + String.valueOf(this.getChunk()) + ", columns=" + String.valueOf(this.getColumns()) + ", table=" + String.valueOf(this.getTable()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcBatch)) {
            return false;
        }
        AbstractJdbcBatch other = (AbstractJdbcBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$url = this.getUrl();
        Property<String> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Property<String> this$username = this.getUsername();
        Property<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Property<String> this$password = this.getPassword();
        Property<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Property<String> this$timeZoneId = this.getTimeZoneId();
        Property<String> other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        Property<String> this$from = this.getFrom();
        Property<String> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Property<String> this$sql = this.getSql();
        Property<String> other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Property<Integer> this$chunk = this.getChunk();
        Property<Integer> other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        Property<List<String>> this$columns = this.getColumns();
        Property<List<String>> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        Property<String> this$table = this.getTable();
        Property<String> other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcBatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Property<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Property<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Property<String> $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        Property<String> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Property<String> $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Property<Integer> $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        Property<List<String>> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        Property<String> $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<String> getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Property<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Property<String> getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public Property<String> getFrom() {
        return this.from;
    }

    @Generated
    public Property<String> getSql() {
        return this.sql;
    }

    @Generated
    public Property<Integer> getChunk() {
        return this.chunk;
    }

    @Generated
    public Property<List<String>> getColumns() {
        return this.columns;
    }

    @Generated
    public Property<String> getTable() {
        return this.table;
    }

    @Generated
    public AbstractJdbcBatch() {
        this.chunk = AbstractJdbcBatch.$default$chunk();
    }

    private /* synthetic */ Integer lambda$run$1(PreparedStatement ps, ParameterType parameterMetaData, AbstractCellConverter cellConverter, Connection connection, RunContext runContext, AtomicLong queryCount, List buffer) throws Exception {
        for (Object row : buffer) {
            this.addBatch(ps, parameterMetaData, row, cellConverter, connection, runContext);
        }
        int[] updatedRows = ps.executeBatch();
        connection.commit();
        queryCount.incrementAndGet();
        return Arrays.stream(updatedRows).sum();
    }

    private static /* synthetic */ void lambda$run$0(AtomicLong count, Object docWriteRequest) {
        count.incrementAndGet();
    }

    public static class ParameterType {
        private final Map<Integer, Class<?>> cls = new HashMap();
        private final Map<Integer, Integer> types = new HashMap<Integer, Integer>();
        private final Map<Integer, String> typesName = new HashMap<Integer, String>();

        public static ParameterType of(ParameterMetaData parameterMetaData) throws SQLException, ClassNotFoundException {
            ParameterType parameterType = new ParameterType();
            for (int i = 1; i <= parameterMetaData.getParameterCount(); ++i) {
                parameterType.cls.put(i, Class.forName(parameterMetaData.getParameterClassName(i)));
                parameterType.types.put(i, parameterMetaData.getParameterType(i));
                parameterType.typesName.put(i, parameterMetaData.getParameterTypeName(i));
            }
            return parameterType;
        }

        public Class<?> getClass(int index) {
            return this.cls.get(index);
        }

        public Integer getType(int index) {
            return this.types.get(index);
        }

        public String getTypeName(int index) {
            return this.typesName.get(index);
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The rows count.")
        private final Long rowCount;
        @Schema(title="The updated rows count.")
        private final Integer updatedCount;

        @ConstructorProperties(value={"rowCount", "updatedCount"})
        @Generated
        Output(Long rowCount, Integer updatedCount) {
            this.rowCount = rowCount;
            this.updatedCount = updatedCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getRowCount() {
            return this.rowCount;
        }

        @Generated
        public Integer getUpdatedCount() {
            return this.updatedCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long rowCount;
            @Generated
            private Integer updatedCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder rowCount(Long rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            @Generated
            public OutputBuilder updatedCount(Integer updatedCount) {
                this.updatedCount = updatedCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.rowCount, this.updatedCount);
            }

            @Generated
            public String toString() {
                return "AbstractJdbcBatch.Output.OutputBuilder(rowCount=" + this.rowCount + ", updatedCount=" + this.updatedCount + ")";
            }
        }
    }

    @Generated
    public static abstract class AbstractJdbcBatchBuilder<C extends AbstractJdbcBatch, B extends AbstractJdbcBatchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> url;
        @Generated
        private Property<String> username;
        @Generated
        private Property<String> password;
        @Generated
        private Property<String> timeZoneId;
        @Generated
        private Property<String> from;
        @Generated
        private Property<String> sql;
        @Generated
        private boolean chunk$set;
        @Generated
        private Property<Integer> chunk$value;
        @Generated
        private Property<List<String>> columns;
        @Generated
        private Property<String> table;

        @Generated
        public B url(Property<String> url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(Property<String> username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(Property<String> password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(Property<String> timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B from(Property<String> from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B sql(Property<String> sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Generated
        public B chunk(Property<Integer> chunk) {
            this.chunk$value = chunk;
            this.chunk$set = true;
            return (B)this.self();
        }

        @Generated
        public B columns(Property<List<String>> columns) {
            this.columns = columns;
            return (B)this.self();
        }

        @Generated
        public B table(Property<String> table) {
            this.table = table;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcBatch.AbstractJdbcBatchBuilder(super=" + super.toString() + ", url=" + String.valueOf(this.url) + ", username=" + String.valueOf(this.username) + ", password=" + String.valueOf(this.password) + ", timeZoneId=" + String.valueOf(this.timeZoneId) + ", from=" + String.valueOf(this.from) + ", sql=" + String.valueOf(this.sql) + ", chunk$value=" + String.valueOf(this.chunk$value) + ", columns=" + String.valueOf(this.columns) + ", table=" + String.valueOf(this.table) + ")";
        }
    }
}

