/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.conv;

import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.ConverterConstants;
import com.vertica.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegralConverter {
    private IntegralConverter() {
    }

    public static String bitToChar(boolean input, long targetLength, ConversionResult out_result) {
        return IntegralConverter.toChar(input ? 1 : 0, targetLength, out_result);
    }

    public static String booleanToChar(boolean input, long targetLength, ConversionResult out_result) {
        String result = String.valueOf(input);
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static boolean toBit(long inputData, ConversionResult cr) {
        if (0L == inputData) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (1L == inputData) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (inputData < 0L) {
            cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return false;
        }
        cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        return false;
    }

    public static boolean toBit(BigInteger inputData, ConversionResult cr) {
        if (BigInteger.ZERO.equals(inputData)) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (BigInteger.ONE.equals(inputData)) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (inputData.compareTo(BigInteger.ZERO) < 0) {
            cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return false;
        }
        cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        return false;
    }

    public static BigDecimal toBigDecimal(long val, short precision, short scale, ConversionResult out_convRes) {
        return ExactNumConverter.setPrecScale(new BigDecimal(val), precision, scale, out_convRes);
    }

    public static BigDecimal toBigDecimal(BigInteger val, short precision, short scale, ConversionResult out_convRes) {
        return ExactNumConverter.setPrecScale(new BigDecimal(val), precision, scale, out_convRes);
    }

    public static BigDecimal toBigDecimal(boolean val, short precision, short scale, ConversionResult out_convRes) {
        if (precision < 1 || scale > precision || scale < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (!val) {
            out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
            return BigDecimal.ZERO;
        }
        if (precision == scale) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
        return BigDecimal.ONE;
    }

    public static String toChar(BigInteger input, long targetLength, ConversionResult out_result) {
        String result = input.toString();
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static String toChar(long input, long targetLength, ConversionResult out_result) {
        String result = String.valueOf(input);
        if ((long)result.length() <= targetLength) {
            out_result.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            out_result.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            result = result.substring(0, (int)targetLength);
        }
        return result;
    }

    public static BigInteger toBigInt(long source, boolean targetSigned, ConversionResult cr) {
        if (!targetSigned && 0L > source) {
            cr.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        return BigInteger.valueOf(source);
    }

    public static BigInteger toBigInt(BigInteger source, boolean targetSigned, ConversionResult cr) {
        BigInteger max;
        BigInteger min;
        if (targetSigned) {
            min = ConverterConstants.SIGNED_BIGINT_MIN;
            max = ConverterConstants.SIGNED_BIGINT_MAX;
        } else {
            min = BigInteger.ZERO;
            max = ConverterConstants.UNSIGNED_BIGINT_MAX;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return source;
    }

    public static double toDouble(BigInteger source, ConversionResult cr) {
        int compMax = source.compareTo(ConverterConstants.MAX_INTEGRAL_IN_DOUBLE_INVARIANT);
        int compMin = source.compareTo(ConverterConstants.MIN_INTEGRAL_IN_DOUBLE_INVARIANT);
        if (compMax <= 0 && compMin >= 0) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return source.longValue();
        }
        double dub = source.doubleValue();
        IntegralConverter.checkIntegralToDoubleExact(source, dub, cr);
        return dub;
    }

    public static float toFloat(BigInteger source, ConversionResult cr) {
        int compMax = source.compareTo(ConverterConstants.MAX_INTEGRAL_IN_FLOAT_INVARIANT);
        int compMin = source.compareTo(ConverterConstants.MIN_INTEGRAL_IN_FLOAT_INVARIANT);
        if (compMax <= 0 && compMin >= 0) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
            return source.longValue();
        }
        float f = (float)source.doubleValue();
        IntegralConverter.checkIntegralToFloatExact(source, f, cr);
        return f;
    }

    public static float toFloat(long source, ConversionResult cr) {
        float result = source;
        if (source <= ConverterConstants.MAX_INTEGRAL_IN_FLOAT_INVARIANT.longValue() || source >= ConverterConstants.MIN_INTEGRAL_IN_FLOAT_INVARIANT.longValue()) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            IntegralConverter.checkIntegralToFloatExact(BigInteger.valueOf(source), result, cr);
        }
        return result;
    }

    public static long toInteger(long source, boolean targetSigned, ConversionResult cr) {
        long max;
        long min;
        if (targetSigned) {
            min = Integer.MIN_VALUE;
            max = Integer.MAX_VALUE;
        } else {
            min = 0L;
            max = 0xFFFFFFFFL;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return source;
    }

    public static long toInteger(BigInteger source, boolean targetSigned, ConversionResult cr) {
        BigInteger max;
        BigInteger min;
        if (targetSigned) {
            min = ConverterConstants.SIGNED_INT_MIN;
            max = ConverterConstants.SIGNED_INT_MAX;
        } else {
            min = BigInteger.ZERO;
            max = ConverterConstants.UNSIGNED_INT_MAX;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return source.longValue();
    }

    public static int toSmallInt(long source, boolean targetSigned, ConversionResult cr) {
        long max;
        long min;
        if (targetSigned) {
            min = -32768L;
            max = 32767L;
        } else {
            min = 0L;
            max = 65535L;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return (int)source;
    }

    public static int toSmallInt(BigInteger source, boolean targetSigned, ConversionResult cr) {
        BigInteger max;
        BigInteger min;
        if (targetSigned) {
            min = ConverterConstants.SIGNED_SMALLINT_MIN;
            max = ConverterConstants.SIGNED_SMALLINT_MAX;
        } else {
            min = BigInteger.ZERO;
            max = ConverterConstants.UNSIGNED_SMALLINT_MAX;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return source.intValue();
    }

    public static short toTinyInt(long source, boolean targetSigned, ConversionResult cr) {
        long max;
        long min;
        if (targetSigned) {
            min = -128L;
            max = 127L;
        } else {
            min = 0L;
            max = 255L;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return (short)source;
    }

    public static short toTinyInt(BigInteger source, boolean targetSigned, ConversionResult cr) {
        BigInteger max;
        BigInteger min;
        if (targetSigned) {
            min = ConverterConstants.SIGNED_TINYINT_MIN;
            max = ConverterConstants.SIGNED_TINYINT_MAX;
        } else {
            min = BigInteger.ZERO;
            max = ConverterConstants.UNSIGNED_TINYINT_MAX;
        }
        IntegralConverter.checkRange(source, min, max, cr);
        return source.shortValue();
    }

    private static void checkIntegralToDoubleExact(BigInteger source, double dub, ConversionResult cr) {
        BigDecimal bd = new BigDecimal(dub);
        if (source.equals(bd.toBigInteger())) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            cr.setState(ConversionResult.TypeConversionState.INTEGRAL_PRECISION_LOSS);
        }
    }

    private static void checkIntegralToFloatExact(BigInteger source, float f, ConversionResult cr) {
        BigDecimal bd = new BigDecimal(f);
        if (source.equals(bd.toBigInteger())) {
            cr.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            cr.setState(ConversionResult.TypeConversionState.INTEGRAL_PRECISION_LOSS);
        }
    }

    private static void checkRange(BigInteger value, BigInteger min, BigInteger max, ConversionResult out_convRes) {
        assert (max.compareTo(min) >= 0);
        if (value.compareTo(min) < 0) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else if (value.compareTo(max) > 0) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else {
            out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
    }

    private static void checkRange(long value, long min, long max, ConversionResult out_convRes) {
        assert (max >= min);
        if (value < min) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else if (value > max) {
            out_convRes.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else {
            out_convRes.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
    }
}

