/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SimbaSupportClassLoader
extends ClassLoader {
    private JarFile m_jarFile = new JarFile(SimbaSupportClassLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath());

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            JarEntry entry = this.m_jarFile.getJarEntry(className.replace(".", "/") + ".class");
            InputStream lInput = this.m_jarFile.getInputStream(entry);
            ByteArrayOutputStream lOutput = new ByteArrayOutputStream();
            int i = 0;
            while ((i = lInput.read()) >= 0) {
                lOutput.write(i);
            }
            byte[] lBytes = lOutput.toByteArray();
            String packageName = className.substring(0, className.lastIndexOf(46));
            if (this.getPackage(packageName) == null) {
                this.definePackage(packageName, "", "", "", "", "", "", null);
            }
            return this.defineClass(className, lBytes, 0, lBytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Class: " + className + " could not be found");
        }
    }

    @Override
    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> lClass = this.findLoadedClass(className);
        if (lClass == null) {
            try {
                lClass = this.findClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                ClassLoader lparent = this.getParent();
                lClass = lparent == null ? SimbaSupportClassLoader.getSystemClassLoader().loadClass(className) : lparent.loadClass(className);
            }
        }
        return lClass;
    }
}

