/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultsetinput.AbstractDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ExceptionType;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class CharacterDataStream
extends AbstractDataStream {
    private Reader m_reader = null;

    public CharacterDataStream(Reader reader, long streamLength, int type, IWarningListener warningListener) {
        super(null, streamLength, type, warningListener);
        this.m_reader = reader;
    }

    @Override
    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    @Override
    public Pair<DataWrapper, Long> getNextValue() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (!this.hasMoreData()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_EMPTY, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        int numCharsToFetch = this.getNumToFetch();
        StringBuffer charBuffer = new StringBuffer();
        int numCharsRead = 0;
        int unicodeChar = Integer.MAX_VALUE;
        while (-1L == this.m_streamLength && -1 != unicodeChar || -1L != this.m_streamLength && numCharsRead + this.m_numRead < numCharsToFetch) {
            try {
                unicodeChar = this.m_reader.read();
            }
            catch (IOException e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
            }
            if ((-1L != this.m_streamLength || -1 == unicodeChar) && -1L == this.m_streamLength) continue;
            charBuffer.append((char)unicodeChar);
            ++numCharsRead;
        }
        if (-1 == unicodeChar) {
            if (-1L != this.m_streamLength) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_UNEXPECTED_END, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_lastChunkReadSize = -1L;
        } else {
            this.m_lastChunkReadSize = numCharsRead;
        }
        this.m_numRead += numCharsRead;
        DataWrapper data = new DataWrapper();
        try {
            if (12 == this.m_type) {
                data.setVarChar(charBuffer.toString());
            } else {
                data.setLongVarChar(charBuffer.toString());
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CORRUPT_UTF, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        return new Pair<DataWrapper, Long>(data, Long.valueOf(numCharsRead * 2));
    }

    @Override
    protected boolean isClosed() {
        return null == this.m_reader;
    }
}

