/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common.utilities;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.SQLException;

public final class WrapperUtilities {
    private WrapperUtilities() {
    }

    public static boolean isWrapperFor(Class<?> iface, Object checkedClass) {
        return iface.isInstance(checkedClass);
    }

    public static <T> T unwrap(Class<T> iface, Object wrapClass) throws SQLException {
        try {
            return iface.cast(wrapClass);
        }
        catch (Exception e) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException("HY000", e.getMessage(), 0, ExceptionType.DEFAULT);
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }
}

