/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.streams.resultsetinput.AbstractDataStream;
import com.vertica.streams.resultsetinput.AsciiDataStream;
import com.vertica.streams.resultsetinput.BinaryDataStream;
import com.vertica.streams.resultsetinput.CharacterDataStream;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class SUpdatableForwardResultSet
extends SForwardResultSet {
    private boolean m_isOnInsertRow = false;
    protected boolean m_hasUpdateValues = false;
    protected List<DataWrapper> m_updateValues = new ArrayList<DataWrapper>();
    protected List<AbstractDataStream> m_updateStreamValues = new ArrayList<AbstractDataStream>();
    private long m_updatableSupport;

    protected SUpdatableForwardResultSet(SStatement statement, IResultSet resultSet, ILogger logger) throws SQLException {
        super(statement, resultSet, logger);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, statement, resultSet, logger);
            Variant var = statement.getStatement().getParentConnection().getProperty(1001);
            this.m_updatableSupport = var.getLong();
            for (int i = this.getMetaData().getColumnCount(); i > 0; --i) {
                this.m_updateValues.add(null);
                this.m_updateStreamValues.add(null);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.absolute(row);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        super.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        super.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        super.clearWarnings();
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_isOnInsertRow) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            if (0L == (this.m_updatableSupport & 1L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_DELETE_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_resultSet.deleteRow();
            this.resetUpdateValues();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.first();
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1008;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getRow() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isOnInsertRow) {
            return 0;
        }
        return super.getRow();
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (0L == (this.m_updatableSupport & 2L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_INSERT_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkForInvalidNulls(JDBCMessageKey.INVALID_NULL_INSERT, true);
            this.m_resultSet.appendRow();
            this.writeRow();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        return super.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        return super.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        return super.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        return super.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.resetUpdateValues();
            this.m_isOnInsertRow = false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.resetUpdateValues();
            this.m_isOnInsertRow = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.next();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        this.resetUpdateValues();
        return super.relative(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.m_isOnInsertRow) {
            return false;
        }
        return super.rowUpdated();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        super.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.m_isOnInsertRow) {
            SQLException e = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ACTION_ON_INSERT_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
        super.setFetchSize(rows);
    }

    @Override
    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        this.updateAsciiStreamImpl(columnIndex, columnValue, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setNumeric(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        this.updateBinaryStreamImpl(columnIndex, columnValue, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setBoolean(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            DataWrapper data = new DataWrapper();
            data.setTinyInt(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setVarBinary(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        this.updateCharacterStreamImpl(columnIndex, columnValue, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setDate(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setDouble(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, Float.valueOf(columnValue));
            DataWrapper data = new DataWrapper();
            data.setReal(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            DataWrapper data = new DataWrapper();
            data.setInteger(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setBigInt(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            this.checkIfValidRowNumber();
            this.clearStream(columnIndex);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
            try {
                DataWrapper data = new DataWrapper();
                data.setNull(typeMetadata.getType());
                this.m_updateValues.set(columnIndex - 1, TypeConverter.toType(data, typeMetadata, (IWarningListener)this.m_warningListener));
                this.m_hasUpdateValues = true;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(typeMetadata.getType()));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            this.clearStream(columnIndex);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
            DataWrapper data = new DataWrapper();
            if (null == columnValue) {
                data.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper valueData = new DataWrapper();
                    valueData.setData(TypeConverter.getSqlType(columnValue), columnValue);
                    data = TypeConverter.toType(valueData, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException e) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(columnValue));
                }
            }
            this.m_updateValues.set(columnIndex - 1, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, scale);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            this.clearStream(columnIndex);
            TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
            DataWrapper data = new DataWrapper();
            if (null == columnValue) {
                data.setNull(typeMetadata.getType());
            } else {
                try {
                    DataWrapper valueData = new DataWrapper();
                    valueData.setData(TypeConverter.getSqlType(columnValue), columnValue);
                    data = TypeConverter.toType(valueData, typeMetadata, (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException e) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(columnValue));
                }
            }
            if (2 == data.getType() || 3 == data.getType()) {
                BigDecimal decimalValue = (BigDecimal)data.getObject();
                data.setData(data.getType(), decimalValue.setScale(scale, 4));
            }
            this.m_updateValues.set(columnIndex - 1, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (0L == (this.m_updatableSupport & 4L)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULT_UPDATE_NOT_SUPPORTED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkForInvalidNulls(JDBCMessageKey.INVALID_NULL_UPDATE, false);
            this.m_resultSet.onStartRowUpdate();
            this.writeRow();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setSmallInt(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateString(int columnIndex, String columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setVarChar(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setTime(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            DataWrapper data = new DataWrapper();
            data.setTimestamp(columnValue);
            this.setValue(columnIndex, data);
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected DataWrapper getData(int columnIndex, long fetchSize) throws SQLException {
        if (!this.m_isOnInsertRow) {
            return super.getData(columnIndex, fetchSize);
        }
        this.checkIfValidColumnNumber(columnIndex);
        if (0L == this.m_currentRow) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_BEFORE_FIRST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
        }
        DataWrapper data = this.m_updateValues.get(columnIndex - 1);
        if (null != data) {
            return data;
        }
        if (null != this.m_updateStreamValues.get(columnIndex - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_GET_UPDATE_STREAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        try {
            data = new DataWrapper();
            this.m_resultSet.getData(columnIndex - 1, 0L, fetchSize, data);
            return data;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private void checkForInvalidNulls(JDBCMessageKey key, boolean createNulls) throws SQLException {
        ResultSetMetaData metadata = this.getMetaData();
        for (int i = 0; i < this.m_updateValues.size(); ++i) {
            DataWrapper value = this.m_updateValues.get(i);
            if (null != value && !value.isNull()) continue;
            AbstractDataStream stream = this.m_updateStreamValues.get(i);
            if (null == stream && 0 == metadata.isNullable(i + 1)) {
                throw ExceptionConverter.getInstance().toSQLException(key, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(i + 1));
            }
            if (!createNulls || null != value || null != stream) continue;
            this.m_updateValues.set(i, new DataWrapper());
        }
    }

    protected void clearStream(int columnIndex) {
        AbstractDataStream stream = this.m_updateStreamValues.get(columnIndex - 1);
        if (null != stream) {
            stream.close();
        }
        this.m_updateStreamValues.set(columnIndex - 1, null);
    }

    private void resetUpdateValues() {
        if (this.m_hasUpdateValues) {
            for (int i = 0; i < this.m_updateValues.size(); ++i) {
                this.m_updateValues.set(i, null);
                this.clearStream(i + 1);
            }
            this.m_hasUpdateValues = false;
        }
    }

    private void setStream(int columnIndex, AbstractDataStream stream) throws SQLException, ErrorException {
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        this.checkIfValidRowNumber();
        this.clearStream(columnIndex);
        this.m_updateStreamValues.set(columnIndex - 1, stream);
    }

    private void setValue(int columnIndex, DataWrapper data) throws SQLException, ErrorException {
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        if (!this.m_isOnInsertRow) {
            this.checkIfValidRowNumber();
        }
        TypeMetadata typeMetadata = this.m_resultSet.getSelectColumns().get(columnIndex - 1).getTypeMetadata();
        this.clearStream(columnIndex);
        try {
            this.m_updateValues.set(columnIndex - 1, TypeConverter.toType(data, typeMetadata, (IWarningListener)this.m_warningListener));
        }
        catch (IncorrectTypeException e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(typeMetadata.getType()));
        }
    }

    protected void updateAsciiStreamImpl(int columnIndex, InputStream columnValue, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, length);
            this.checkIfOpen();
            int type = this.m_resultMetaData.getColumnType(columnIndex);
            if (!TypeConverter.canConvertStreamTo(-1, type)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex));
            }
            if (null == columnValue) {
                this.updateNull(columnIndex);
            } else {
                this.setStream(columnIndex, new AsciiDataStream(columnValue, length, type, this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    protected void updateBinaryStreamImpl(int columnIndex, InputStream columnValue, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, length);
            this.checkIfOpen();
            int type = this.m_resultMetaData.getColumnType(columnIndex);
            if (!TypeConverter.canConvertStreamTo(-4, type)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex));
            }
            if (null == columnValue) {
                this.updateNull(columnIndex);
            } else {
                this.setStream(columnIndex, new BinaryDataStream(columnValue, length, type, this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    protected void updateCharacterStreamImpl(int columnIndex, Reader columnValue, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, length);
            this.checkIfOpen();
            int type = this.m_resultMetaData.getColumnType(columnIndex);
            if (!TypeConverter.canConvertStreamTo(-1, type)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex));
            }
            if (null == columnValue) {
                this.updateNull(columnIndex);
            } else {
                this.setStream(columnIndex, new CharacterDataStream(columnValue, length, type, (IWarningListener)this.m_warningListener));
            }
            this.m_hasUpdateValues = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    private void writeRow() throws SQLException {
        try {
            for (int i = 0; i < this.m_updateValues.size(); ++i) {
                if (null != this.m_updateValues.get(i)) {
                    if (!this.m_resultSet.writeData(i, this.m_updateValues.get(i), 0L, false)) continue;
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DATA_TRUNCATED_ERR, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(i));
                }
                if (null == this.m_updateStreamValues.get(i)) continue;
                this.writeStream(i);
            }
            this.m_resultSet.onFinishRowUpdate();
        }
        catch (ErrorException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        this.resetUpdateValues();
    }

    private void writeStream(int columnIndex) throws ErrorException, SQLException {
        AbstractDataStream stream = this.m_updateStreamValues.get(columnIndex);
        long offset = 0L;
        while (stream.hasMoreData()) {
            Pair<DataWrapper, Long> dataChunk = stream.getNextValue();
            if (this.m_resultSet.writeData(columnIndex, dataChunk.key(), offset, false)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DATA_TRUNCATED_ERR, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex + 1));
            }
            offset += dataChunk.value().longValue();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getResultSetHoldability();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return !this.m_isOpen || null == this.m_parentStatement;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        this.updateAsciiStream(columnIndex, x, -1);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        this.updateAsciiStreamImpl(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x);
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x, length);
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStreamImpl(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, -1);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        this.updateBinaryStreamImpl(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, inputStream);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, inputStream, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, inputStream);
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, inputStream, length);
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStream(columnIndex, x, -1);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStreamImpl(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        this.updateCharacterStreamImpl(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, nClob);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, nClob);
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, nString);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, nString);
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, x);
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, xmlObject);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, xmlObject);
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }
}

