/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.ConnectionSetting;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.core.utilities.Variants;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogLevel;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.SettingReader;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ExceptionBuilder;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.ExceptionUtilities;
import com.vertica.support.security.ICredentialFactory;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.PropertyTypeConverter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class BaseConnectionFactory {
    public static final String URL_SEPARATOR = ":";
    public static final String CONNECTION_LOCALE_KEY = "Locale";
    public static ExceptionBuilder s_Messages = new ExceptionBuilder(1);

    protected boolean acceptsSubProtocol(String givenSubProtocol) {
        String subProtocol = this.getSubProtocol();
        if (null == subProtocol) {
            return false;
        }
        return subProtocol.equals(givenSubProtocol);
    }

    protected final boolean acceptsURL(String url, Properties properties) {
        try {
            StringTokenizer strTokenizer = new StringTokenizer(url, URL_SEPARATOR);
            String givenProtocol = strTokenizer.nextToken();
            String givenSubProtocol = strTokenizer.nextToken();
            if ("jdbc".equals(givenProtocol) && this.acceptsSubProtocol(givenSubProtocol)) {
                int givenSubNameIndex = url.indexOf(givenSubProtocol) + givenSubProtocol.length() + 1;
                String givenSubName = "";
                if (givenSubNameIndex < url.length()) {
                    givenSubName = url.substring(givenSubNameIndex);
                }
                SettingReader.clearAllSettings();
                if (SettingReader.isSuccessfulLoad()) {
                    properties.putAll((Map<?, ?>)SettingReader.retrieveAllSettings());
                }
                return this.parseSubName(givenSubName, properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected abstract JDBCObjectFactory createJDBCObjectFactory();

    protected SConnection doConnect(Pair<IConnection, ConnSettingRequestMap> connInfo, String url) throws SQLException {
        assert (null != connInfo);
        IConnection con = connInfo.key();
        IWarningListener warningListener = con.getWarningListener();
        try {
            if (null == JDBCObjectFactory.getInstance()) {
                JDBCObjectFactory.setInstance(this.createJDBCObjectFactory());
            }
            ConnSettingResponseMap responseMap = null;
            if (null == warningListener) {
                warningListener = new SWarningListener(con.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                con.registerWarningListener(warningListener);
            }
            responseMap = con.updateConnectionSettings(connInfo.value());
            this.checkResponseMap(responseMap, warningListener);
            con.connect(connInfo.value());
            for (Warning warning : warningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            return JDBCObjectFactory.getInstance().createConnection(con, url);
        }
        catch (Exception e) {
            ILogger log = null;
            try {
                log = connInfo.key().getConnectionLog();
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (null == log) {
                throw ExceptionConverter.getInstance().toSQLException(e, warningListener);
            }
            throw ExceptionConverter.getInstance().toSQLException(e, warningListener, log);
        }
    }

    protected Pair<IConnection, ConnSettingRequestMap> getConnection(Properties info) throws SQLException {
        assert (null != info);
        IDriver driver = DSIDriverSingleton.getInstance();
        SWarningListener warningListener = new SWarningListener(driver.getMessageSource(), FunctionID.BEFORE_CONNECTION);
        try {
            ILogger logger;
            this.mapJDBCtoODBCAuthentication(info);
            this.saveLoggingAttributes(info);
            PrintWriter dmWriter = DriverManager.getLogWriter();
            if (null != dmWriter) {
                SettingReader.storeAdditionalSetting("LogPrintWriter", dmWriter);
            }
            if ((logger = driver.getDriverLog()) instanceof DSILogger) {
                ((DSILogger)logger).prepareSettings(((DSILogger)logger).getFileName());
            }
            if (LogUtilities.shouldLogLevel(LogLevel.INFO, logger)) {
                LogUtilities.logInfo("SDK Version: 10.1.17.1129", logger);
                Variant var = driver.getProperty(5);
                LogUtilities.logInfo("Driver Version: " + var.getString(), logger);
                LogUtilities.logInfo("JVM Name: " + System.getProperty("java.vm.name"), logger);
                LogUtilities.logInfo("JVM Specification Version: " + System.getProperty("java.vm.specification.version"), logger);
                LogUtilities.logInfo("JVM Implementation Version: " + System.getProperty("java.vm.version"), logger);
                LogUtilities.logInfo("JVM Vendor: " + System.getProperty("java.vm.specification.vendor"), logger);
                LogUtilities.logInfo("Operating System Name: " + System.getProperty("os.name"), logger);
                LogUtilities.logInfo("Operating System Version: " + System.getProperty("os.version"), logger);
                LogUtilities.logInfo("Operating System Architecture: " + System.getProperty("os.arch"), logger);
                LogUtilities.logInfo("Locale Name: " + driver.getLocale().toString(), logger);
                LogUtilities.logInfo("Default Charset Encoding: " + Charset.defaultCharset().displayName(), logger);
            }
            IConnection conn = null;
            try {
                ICredentialFactory credFactory;
                long supportIS = driver.getProperty(20).getLong();
                IEnvironment env = driver.createEnvironment();
                env.registerWarningListener(warningListener);
                conn = (supportIS & 1L) != 0L ? ((credFactory = driver.createCredentialFactory()) != null ? env.createConnection(credFactory.getLocalCredentials()) : env.createConnection()) : env.createConnection();
            }
            catch (Exception e) {
                try {
                    throw ExceptionConverter.getInstance().toSQLException(e, warningListener, logger);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            ConnSettingRequestMap requestMap = PropertyTypeConverter.toConnSettingRequestMap(info);
            SettingReader.storeSettings(info);
            if (requestMap.containsKey(CONNECTION_LOCALE_KEY)) {
                Variant locale = requestMap.getProperty(CONNECTION_LOCALE_KEY);
                conn.setLocale(ExceptionUtilities.createLocale(locale.getString()));
            }
            if (DriverManager.getLoginTimeout() >= 0) {
                conn.setProperty(23, Variants.makeUInt32(DriverManager.getLoginTimeout()));
            }
            return new Pair<IConnection, ConnSettingRequestMap>(conn, requestMap);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, warningListener);
        }
    }

    protected abstract String getSubProtocol();

    protected abstract boolean parseSubName(String var1, Properties var2);

    private void checkResponseMap(ConnSettingResponseMap responseMap, IWarningListener warningListener) throws SQLException {
        ArrayList<String> requiredKeys = new ArrayList<String>();
        ArrayList<String> optionalKeys = new ArrayList<String>();
        ArrayList<String> processedKeys = new ArrayList<String>();
        Iterator<String> keyItr = responseMap.getKeysIterator();
        while (keyItr.hasNext()) {
            String key = keyItr.next();
            ConnectionSetting connSetting = responseMap.getProperty(key);
            if (connSetting.isRequired()) {
                requiredKeys.add(key);
                continue;
            }
            if (connSetting.isOptional()) {
                optionalKeys.add(key);
                continue;
            }
            processedKeys.add(key);
        }
        if (requiredKeys.isEmpty()) {
            return;
        }
        StringBuilder errorString = new StringBuilder(JDBCMessageBuilder.getMessage(JDBCMessageKey.REQUIRED_KEYS_MSG, warningListener, false, false));
        errorString.append(": ");
        keyItr = requiredKeys.iterator();
        while (keyItr.hasNext()) {
            errorString.append(keyItr.next());
            if (!keyItr.hasNext()) continue;
            errorString.append(", ");
        }
        if (!optionalKeys.isEmpty()) {
            errorString.append("; ");
            errorString.append(JDBCMessageBuilder.getMessage(JDBCMessageKey.OPTIONAL_KEYS_MSG, warningListener, false, false));
            errorString.append(": ");
            keyItr = optionalKeys.iterator();
            while (keyItr.hasNext()) {
                errorString.append(keyItr.next());
                if (!keyItr.hasNext()) continue;
                errorString.append(", ");
            }
        }
        if (!processedKeys.isEmpty()) {
            errorString.append("; ");
            errorString.append(JDBCMessageBuilder.getMessage(JDBCMessageKey.PROCESSED_KEYS_MSG, warningListener, false, false));
            errorString.append(": ");
            keyItr = processedKeys.iterator();
            while (keyItr.hasNext()) {
                errorString.append(keyItr.next());
                if (!keyItr.hasNext()) continue;
                errorString.append(", ");
            }
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_REFUSED, warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, errorString.toString());
    }

    private void mapJDBCtoODBCAuthentication(Properties connectionProperties) {
        IDriver driver = DSIDriverSingleton.getInstance();
        assert (null != driver);
        try {
            Variant var = driver.getProperty(1000);
            if (1 != var.getShort()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Enumeration<Object> keys = connectionProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equalsIgnoreCase("USER")) {
                String user = connectionProperties.getProperty(key);
                connectionProperties.remove(key);
                connectionProperties.setProperty("UID", user);
                continue;
            }
            if (!key.equalsIgnoreCase("PASSWORD")) continue;
            String pwd = connectionProperties.getProperty(key);
            connectionProperties.remove(key);
            connectionProperties.setProperty("PWD", pwd);
        }
    }

    private void saveLoggingAttributes(Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.regionMatches(true, 0, "log", 0, 3)) continue;
            SettingReader.storeSetting(key, properties.get(key).toString());
        }
    }
}

