/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import com.vertica.util.ProtocolUtils;
import java.io.IOException;

public final class AuthOAuthResponseMessage
extends ResponseMessage {
    ProtocolUtils.ProtocolVersion protocolVersion;
    String authUrl;
    String tokenUrl;
    String clientId;
    String scope;
    String validateHostname;

    protected AuthOAuthResponseMessage(VStream vStream) {
        super(vStream);
    }

    public AuthOAuthResponseMessage(VStream vStream, ProtocolUtils.ProtocolVersion protocolVersion) {
        super(vStream);
        this.protocolVersion = protocolVersion;
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        if (this.protocolVersion.isAtLeast(ProtocolUtils.ProtocolVersion.PROTOCOL_VERSION_3_15)) {
            this.authUrl = this.m_vStream.ReceiveString();
            this.tokenUrl = this.m_vStream.ReceiveString();
            this.clientId = this.m_vStream.ReceiveString();
            if (this.protocolVersion.isAtLeast(ProtocolUtils.ProtocolVersion.PROTOCOL_VERSION_3_16)) {
                this.scope = this.m_vStream.ReceiveString();
                this.validateHostname = this.m_vStream.ReceiveString();
            }
        } else if (n != 0) {
            throw new IOException("Protocol Error. Received more data than expected.");
        }
    }

    @Override
    public MessageType getType() {
        return MessageType.AuthOAuth;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getScope() {
        return this.scope;
    }

    public String getValidateHostname() {
        return this.validateHostname;
    }
}

