/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.exceptions.jdbc4;

import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.dsi.exceptions.InvalidArgumentException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.AbstractDriver;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.DataException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FailedPropertiesReason;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import com.vertica.support.exceptions.IntegrityConstraintViolationException;
import com.vertica.support.exceptions.InvalidAuthorizationException;
import com.vertica.support.exceptions.NonTransientConnectionException;
import com.vertica.support.exceptions.NonTransientException;
import com.vertica.support.exceptions.RecoverableException;
import com.vertica.support.exceptions.SyntaxErrorException;
import com.vertica.support.exceptions.TimeOutException;
import com.vertica.support.exceptions.TransactionRollbackException;
import com.vertica.support.exceptions.TransientConnectionException;
import com.vertica.support.exceptions.TransientException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.HashMap;
import java.util.Map;

public class JDBC4ExceptionConverter
extends ExceptionConverter {
    @Override
    public SQLException toSQLException(Exception exception, IWarningListener warningListener) {
        if (exception instanceof SQLException) {
            return (SQLException)exception;
        }
        IMessageSource msgSrc = warningListener.getMessageSource();
        SQLException se = null;
        if (exception instanceof NullPointerException) {
            String errMsg = msgSrc.loadMessage(warningListener.getLocale(), 1, JDBCMessageKey.NULL_ERROR.name());
            se = new SQLException(errMsg, JDBCMessageKey.NULL_ERROR.getSQLState(), 0);
        } else if (exception instanceof InputOutputException) {
            InputOutputException ioEx = (InputOutputException)exception;
            ioEx.loadMessage(warningListener.getMessageSource(), warningListener.getLocale());
            se = new SQLException(ioEx.getMessage(), "HY000", ioEx.getErrorCode());
        } else if (exception instanceof InvalidArgumentException) {
            InvalidArgumentException iaEx = (InvalidArgumentException)exception;
            iaEx.loadMessage(warningListener.getMessageSource(), warningListener.getLocale());
            se = new SQLException(iaEx.getMessage(), "HY000", iaEx.getErrorCode());
        } else if (exception instanceof ErrorException) {
            ErrorException ex = (ErrorException)exception;
            int nativeCode = ex.getNativeErrorCode(msgSrc, warningListener.getLocale());
            String state = ex.hasCustomState() ? ex.getCustomState() : ex.getDiagState().getSqlState();
            se = exception instanceof ClientInfoException ? this.convertToSQLClientInfoException(((ClientInfoException)exception).getFailedProperties(), ex.getMessage(), state, ex.getNativeErrorCode(null, null)) : this.convertToJDBC4Exception(ex.getMessage(), state, nativeCode, ex.getClass());
            for (ErrorException e : ex.getSuppressedCustom()) {
                se.setNextException(this.toSQLException(e, warningListener));
            }
        } else {
            se = new SQLException(AbstractDriver.getErrorMessageComponentName() + exception.getLocalizedMessage(), "HY000", 0);
        }
        se.initCause(exception);
        se.setStackTrace(exception.getStackTrace());
        return se;
    }

    @Override
    protected SQLException createSQLException(String sqlState, String message, int nativeErrorCode, StackTraceElement[] stackTrace, ExceptionType exceptionType, Map<String, FailedPropertiesReason> failedProperties) {
        SQLException sqlException = null;
        switch (exceptionType) {
            case CLIENT_INFO: {
                sqlException = new SQLClientInfoException(message, sqlState, nativeErrorCode, this.convertFailedPropertiesReasonToClientInfoStatus(failedProperties));
                break;
            }
            case DATA: {
                sqlException = new SQLDataException(message, sqlState, nativeErrorCode);
                break;
            }
            case FEATURE_NOT_IMPLEMENTED: {
                sqlException = new SQLFeatureNotSupportedException(message, sqlState, nativeErrorCode);
                break;
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                sqlException = new SQLIntegrityConstraintViolationException(message, sqlState, nativeErrorCode);
                break;
            }
            case INVALID_AUTHORIZATION: {
                sqlException = new SQLInvalidAuthorizationSpecException(message, sqlState, nativeErrorCode);
                break;
            }
            case NON_TRANSIENT: {
                sqlException = new SQLNonTransientException(message, sqlState, nativeErrorCode);
                break;
            }
            case NON_TRANSIENT_CONNECTION: {
                sqlException = new SQLNonTransientConnectionException(message, sqlState, nativeErrorCode);
                break;
            }
            case RECOVERABLE: {
                sqlException = new SQLRecoverableException(message, sqlState, nativeErrorCode);
                break;
            }
            case SYNTAX_ERROR: {
                sqlException = new SQLSyntaxErrorException(message, sqlState, nativeErrorCode);
                break;
            }
            case TIME_OUT: {
                sqlException = new SQLTimeoutException(message, sqlState, nativeErrorCode);
                break;
            }
            case TRANSACTION_ROLLBACK: {
                sqlException = new SQLTransactionRollbackException(message, sqlState, nativeErrorCode);
                break;
            }
            case TRANSIENT: {
                sqlException = new SQLTransientException(message, sqlState, nativeErrorCode);
                break;
            }
            case TRANSIENT_CONNECTION: {
                sqlException = new SQLTransientConnectionException(message, sqlState, nativeErrorCode);
                break;
            }
            default: {
                sqlException = new SQLException(message, sqlState, nativeErrorCode);
            }
        }
        sqlException.setStackTrace(stackTrace);
        return sqlException;
    }

    private Map<String, ClientInfoStatus> convertFailedPropertiesReasonToClientInfoStatus(Map<String, FailedPropertiesReason> failedProperties) {
        if (null != failedProperties) {
            HashMap<String, ClientInfoStatus> failureList = new HashMap<String, ClientInfoStatus>(failedProperties.size());
            for (Map.Entry<String, FailedPropertiesReason> mapEntry : failedProperties.entrySet()) {
                ClientInfoStatus status = this.convertFailedPropertyReasonToClientInfoStatus(mapEntry.getValue());
                failureList.put(mapEntry.getKey(), status);
            }
            return failureList;
        }
        return null;
    }

    private ClientInfoStatus convertFailedPropertyReasonToClientInfoStatus(FailedPropertiesReason reason) {
        switch (reason) {
            case UNKNOWN: {
                return ClientInfoStatus.REASON_UNKNOWN;
            }
            case UNKNOWN_PROPERTY: {
                return ClientInfoStatus.REASON_UNKNOWN_PROPERTY;
            }
            case VALUE_INVALID: {
                return ClientInfoStatus.REASON_VALUE_INVALID;
            }
            case VALUE_TRUNCATED: {
                return ClientInfoStatus.REASON_VALUE_TRUNCATED;
            }
        }
        return null;
    }

    private SQLException convertToJDBC4Exception(String reason, String SQLState, int vendorCode, Class<? extends ErrorException> exceptionClass) {
        if (DataException.class.isAssignableFrom(exceptionClass)) {
            return new SQLDataException(reason, SQLState, vendorCode);
        }
        if (FeatureNotSupportedException.class.isAssignableFrom(exceptionClass)) {
            return new SQLFeatureNotSupportedException(reason, SQLState, vendorCode);
        }
        if (IntegrityConstraintViolationException.class.isAssignableFrom(exceptionClass)) {
            return new SQLIntegrityConstraintViolationException(reason, SQLState, vendorCode);
        }
        if (InvalidAuthorizationException.class.isAssignableFrom(exceptionClass)) {
            return new SQLInvalidAuthorizationSpecException(reason, SQLState, vendorCode);
        }
        if (NonTransientConnectionException.class.isAssignableFrom(exceptionClass)) {
            return new SQLNonTransientConnectionException(reason, SQLState, vendorCode);
        }
        if (NonTransientException.class.isAssignableFrom(exceptionClass)) {
            return new SQLNonTransientException(reason, SQLState, vendorCode);
        }
        if (RecoverableException.class.isAssignableFrom(exceptionClass)) {
            return new SQLRecoverableException(reason, SQLState, vendorCode);
        }
        if (SyntaxErrorException.class.isAssignableFrom(exceptionClass)) {
            return new SQLSyntaxErrorException(reason, SQLState, vendorCode);
        }
        if (TimeOutException.class.isAssignableFrom(exceptionClass)) {
            return new SQLTimeoutException(reason, SQLState, vendorCode);
        }
        if (TransactionRollbackException.class.isAssignableFrom(exceptionClass)) {
            return new SQLTransactionRollbackException(reason, SQLState, vendorCode);
        }
        if (TransientConnectionException.class.isAssignableFrom(exceptionClass)) {
            return new SQLTransientConnectionException(reason, SQLState, vendorCode);
        }
        if (TransientException.class.isAssignableFrom(exceptionClass)) {
            return new SQLTransientException(reason, SQLState, vendorCode);
        }
        return new SQLException(reason, SQLState, vendorCode);
    }

    private SQLException convertToSQLClientInfoException(Map<String, FailedPropertiesReason> failedProperties, String reason, String SQLState, int vendorCode) {
        Map<String, ClientInfoStatus> clientInfoStatusList = this.convertFailedPropertiesReasonToClientInfoStatus(failedProperties);
        return new SQLClientInfoException(reason, SQLState, vendorCode, clientInfoStatusList);
    }
}

