/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.exceptions;

import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.support.exceptions.FailedPropertiesReason;
import java.sql.SQLException;
import java.util.Map;

public abstract class ExceptionConverter {
    private static ExceptionConverter s_converter = null;

    protected ExceptionConverter() {
    }

    public static ExceptionConverter getInstance() {
        return s_converter;
    }

    public static void setInstance(ExceptionConverter converter) {
        if (null != converter) {
            s_converter = converter;
        }
    }

    public abstract SQLException toSQLException(Exception var1, IWarningListener var2);

    public SQLException toSQLException(Exception exception, IWarningListener warningListener, ILogger logger) {
        SQLException se = this.toSQLException(exception, warningListener);
        LogUtilities.logError(se, logger);
        return se;
    }

    public SQLException toSQLException(JDBCMessageKey messageKey, IWarningListener warningListener, ExceptionType exceptionType, Object ... arguments) {
        return this.toSQLException(messageKey, warningListener, exceptionType, null, arguments);
    }

    public SQLException toSQLException(JDBCMessageKey messageKey, IWarningListener warningListener, ExceptionType exceptionType, Map<String, FailedPropertiesReason> failedProperties, Object ... arguments) {
        int indexOfClosingParen;
        IMessageSource msgSrc = warningListener.getMessageSource();
        String errorMsg = msgSrc.loadMessage(warningListener.getLocale(), 1, messageKey.name(), arguments);
        int nativeErrorCode = 0;
        int indexOfOpeningParen = errorMsg.indexOf(40);
        if (indexOfOpeningParen < (indexOfClosingParen = errorMsg.indexOf(41)) && -1 != indexOfOpeningParen) {
            String errorCode = errorMsg.substring(++indexOfOpeningParen, indexOfClosingParen);
            try {
                nativeErrorCode = Integer.valueOf(errorCode);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        StackTraceElement[] sourceStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[sourceStackTrace.length - 2];
        System.arraycopy(sourceStackTrace, 2, stackTrace, 0, stackTrace.length);
        return this.createSQLException(messageKey.getSQLState(), errorMsg, nativeErrorCode, stackTrace, exceptionType, failedProperties);
    }

    public SQLException toSQLException(String sqlState, String message, int nativeErrorCode, ExceptionType exceptionType) {
        return this.toSQLException(sqlState, message, nativeErrorCode, exceptionType, null);
    }

    public SQLException toSQLException(String sqlState, String message, int nativeErrorCode, ExceptionType exceptionType, Map<String, FailedPropertiesReason> failedProperties) {
        StackTraceElement[] sourceStackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTrace = new StackTraceElement[sourceStackTrace.length - 2];
        System.arraycopy(sourceStackTrace, 2, stackTrace, 0, stackTrace.length);
        return this.createSQLException(sqlState, message, nativeErrorCode, stackTrace, exceptionType, failedProperties);
    }

    protected abstract SQLException createSQLException(String var1, String var2, int var3, StackTraceElement[] var4, ExceptionType var5, Map<String, FailedPropertiesReason> var6);
}

