/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;

public final class TypeMetadata {
    public static final String TN_ARRAY = "SQL_ARRAY";
    public static final String TN_BIGINT = "SQL_BIGINT";
    public static final String TN_BINARY = "SQL_BINARY";
    public static final String TN_BIT = "SQL_BIT";
    public static final String TN_BOOLEAN = "SQL_BOOLEAN";
    public static final String TN_CHAR = "SQL_CHAR";
    public static final String TN_DECIMAL = "SQL_DECIMAL";
    public static final String TN_DOUBLE = "SQL_DOUBLE";
    public static final String TN_FLOAT = "SQL_FLOAT";
    public static final String TN_GUID = "SQL_GUID";
    public static final String TN_INTEGER = "SQL_INTEGER";
    public static final String TN_INTERVAL_DAY = "SQL_INTERVAL_DAY";
    public static final String TN_INTERVAL_DAY_TO_HOUR = "SQL_INTERVAL_DAY_TO_HOUR";
    public static final String TN_INTERVAL_DAY_TO_MINUTE = "SQL_INTERVAL_DAY_TO_MINUTE";
    public static final String TN_INTERVAL_DAY_TO_SECOND = "SQL_INTERVAL_DAY_TO_SECOND";
    public static final String TN_INTERVAL_HOUR = "SQL_INTERVAL_HOUR";
    public static final String TN_INTERVAL_HOUR_TO_MINUTE = "SQL_INTERVAL_HOUR_TO_MINUTE";
    public static final String TN_INTERVAL_HOUR_TO_SECOND = "SQL_INTERVAL_HOUR_TO_SECOND";
    public static final String TN_INTERVAL_MINUTE = "SQL_INTERVAL_MINUTE";
    public static final String TN_INTERVAL_MINUTE_TO_SECOND = "SQL_INTERVAL_MINUTE_TO_SECOND";
    public static final String TN_INTERVAL_MONTH = "SQL_INTERVAL_MONTH";
    public static final String TN_INTERVAL_SECOND = "SQL_INTERVAL_SECOND";
    public static final String TN_INTERVAL_YEAR = "SQL_INTERVAL_YEAR";
    public static final String TN_INTERVAL_YEAR_TO_MONTH = "SQL_INTERVAL_YEAR_TO_MONTH";
    public static final String TN_LONGVARBINARY = "SQL_LONGVARBINARY";
    public static final String TN_LONGVARCHAR = "SQL_LONGVARCHAR";
    public static final String TN_MAP = "MAP";
    public static final String TN_NULL = "NULL";
    public static final String TN_NUMERIC = "SQL_NUMERIC";
    public static final String TN_JAVA_OBJECT = "JAVA_OBJECT";
    public static final String TN_OTHER = "SQL_OTHER";
    public static final String TN_REAL = "SQL_REAL";
    public static final String TN_SMALLINT = "SQL_SMALLINT";
    public static final String TN_STRUCT = "SQL_STRUCT";
    public static final String TN_TINYINT = "SQL_TINYINT";
    public static final String TN_TYPE_DATE = "SQL_TYPE_DATE";
    public static final String TN_TYPE_TIME = "SQL_TYPE_TIME";
    public static final String TN_TYPE_TIMESTAMP = "SQL_TYPE_TIMESTAMP";
    public static final String TN_VARBINARY = "SQL_VARBINARY";
    public static final String TN_VARCHAR = "SQL_VARCHAR";
    public static final String TN_WCHAR = "SQL_WCHAR";
    public static final String TN_WLONGVARCHAR = "SQL_WLONGVARCHAR";
    public static final String TN_WVARCHAR = "SQL_WVARCHAR";
    public static final String TN_SQL92_CHARACTER = "CHARACTER";
    public static final String TN_SQL92_CHAR = "CHAR";
    public static final String TN_SQL92_CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String TN_SQL92_CHAR_VARYING = "CHAR VARYING";
    public static final String TN_SQL92_VARCHAR = "VARCHAR";
    public static final String TN_SQL92_BIT = "BIT";
    public static final String TN_SQL92_BIT_VARYING = "BIT VARYING";
    public static final String TN_SQL92_NUMERIC = "NUMERIC";
    public static final String TN_SQL92_DECIMAL = "DECIMAL";
    public static final String TN_SQL92_DEC = "DEC";
    public static final String TN_SQL92_INTEGER = "INTEGER";
    public static final String TN_SQL92_INT = "INT";
    public static final String TN_SQL92_SMALLINT = "SMALLINT";
    public static final String TN_SQL92_DATE = "DATE";
    public static final String TN_SQL92_TIME = "TIME";
    public static final String TN_SQL92_TIMESTAMP = "TIMESTAMP";
    public static final String TN_SQL92_FLOAT = "FLOAT";
    public static final String TN_SQL92_REAL = "REAL";
    public static final String TN_SQL92_DOUBLE = "DOUBLE";
    public static final String TN_SQL92_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String TN_SQL92_INTERVAL_DAY = "INTERVAL DAY";
    public static final String TN_SQL92_INTERVAL_DAY_TO_HOUR = "INTERVAL DAY TO HOUR";
    public static final String TN_SQL92_INTERVAL_DAY_TO_MINUTE = "INTERVAL DAY TO MINUTE";
    public static final String TN_SQL92_INTERVAL_DAY_TO_SECOND = "INTERVAL_DAY TO SECOND";
    public static final String TN_SQL92_INTERVAL_HOUR = "INTERVAL HOUR";
    public static final String TN_SQL92_INTERVAL_HOUR_TO_MINUTE = "INTERVAL HOUR TO MINUTE";
    public static final String TN_SQL92_INTERVAL_HOUR_TO_SECOND = "INTERVAL_HOUR TO SECOND";
    public static final String TN_SQL92_INTERVAL_MINUTE = "INTERVAL MINUTE";
    public static final String TN_SQL92_INTERVAL_MINUTE_TO_SECOND = "INTERVAL MINUTE TO SECOND";
    public static final String TN_SQL92_INTERVAL_MONTH = "INTERVAL MONTH";
    public static final String TN_SQL92_INTERVAL_SECOND = "INTERVAL SECOND";
    public static final String TN_SQL92_INTERVAL_YEAR = "INTERVAL YEAR";
    public static final String TN_SQL92_INTERVAL_YEAR_TO_MONTH = "INTERVAL YEAR TO MONTH";
    private short m_type;
    private String m_localTypeName;
    private String m_typeName;
    private short m_scale;
    private short m_precision;
    private int m_intervalPrecision;
    private boolean m_isSigned;
    private boolean m_isApproximateNumericType;
    private boolean m_isBinaryType;
    private boolean m_isBooleanType;
    private boolean m_isCharacterType;
    private boolean m_isExactNumericType;
    private boolean m_isIntegerType;
    private boolean m_isIntervalType;
    private boolean m_isCurrency = false;
    private boolean m_isSortable = true;
    private ArrayList<IColumn> m_nestedColumnList = null;

    public static TypeMetadata createTypeMetadata(int sqlType) throws ErrorException {
        switch (sqlType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return TypeMetadata.createTypeMetadata(sqlType, true);
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return TypeMetadata.createTypeMetadata(sqlType, false);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(sqlType), ExceptionType.DATA);
    }

    public static TypeMetadata createTypeMetadata(int sqlType, boolean isSigned) throws ErrorException {
        switch (sqlType) {
            case 2003: {
                ArrayList<IColumn> temp = new ArrayList<IColumn>();
                TypeMetadata tm = new TypeMetadata((short)sqlType, TN_ARRAY.substring(4), 0, 0, 0, isSigned, temp);
                tm.setIsSortable(false);
                return tm;
            }
            case -5: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)19, (short)0, 19, isSigned);
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)1, (short)0, 1, isSigned);
            }
            case -7: 
            case 16: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)1, (short)0, 0, isSigned);
            }
            case 2: 
            case 3: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)38, (short)0, 38, isSigned);
            }
            case 6: 
            case 8: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)15, (short)0, 53, isSigned);
            }
            case -11: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)36, (short)0, 36, isSigned);
            }
            case 4: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)10, (short)0, 0, isSigned);
            }
            case 0: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 0, isSigned);
            }
            case 7: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)7, (short)0, 24, isSigned);
            }
            case 5: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)5, (short)0, 5, isSigned);
            }
            case -6: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)3, (short)0, 3, isSigned);
            }
            case 91: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 10, isSigned);
            }
            case 92: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 8, isSigned);
            }
            case 93: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)6, (short)6, 0, isSigned);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 111: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 2, isSigned);
            }
            case 106: 
            case 110: 
            case 112: 
            case 113: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)6, (short)6, 2, isSigned);
            }
            case -10: 
            case -9: 
            case -8: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 0, isSigned);
            }
            case 2002: {
                ArrayList<IColumn> temp = new ArrayList<IColumn>();
                TypeMetadata tm = new TypeMetadata((short)sqlType, TN_STRUCT.substring(4), 0, 0, 0, isSigned, temp);
                tm.setIsSortable(false);
                return tm;
            }
            case 1111: 
            case 2000: {
                return TypeMetadata.createTypeMetadata(sqlType, (short)0, (short)0, 0, isSigned);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(sqlType), ExceptionType.DATA);
    }

    public static TypeMetadata createTypeMetadata(int sqlType, short precision, short scale, int intervalPrecision, boolean isSigned) throws ErrorException {
        String typeName = TypeUtilities.sqlTypeToString((short)sqlType);
        if (null == typeName) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(sqlType), ExceptionType.DATA);
        }
        if (typeName.startsWith("SQL_")) {
            typeName = typeName.substring(4);
        }
        return new TypeMetadata((short)sqlType, typeName, precision, scale, intervalPrecision, isSigned);
    }

    public TypeMetadata(short sqlType, String typeName, short precision, short scale, int intervalPrecision) {
        this(sqlType, typeName, precision, scale, intervalPrecision, false, null);
    }

    public TypeMetadata(short sqlType, String typeName, short precision, short scale, int intervalPrecision, boolean isSigned) {
        this(sqlType, typeName, precision, scale, intervalPrecision, isSigned, null);
    }

    public TypeMetadata(short sqlType, String typeName, short precision, short scale, int intervalPrecision, boolean isSigned, ArrayList<IColumn> nestedColumnList) {
        this.m_type = sqlType;
        this.m_typeName = typeName;
        this.m_localTypeName = typeName;
        this.m_precision = precision;
        this.m_scale = scale;
        this.m_intervalPrecision = intervalPrecision;
        this.m_isSigned = isSigned;
        this.m_nestedColumnList = nestedColumnList;
        this.m_isApproximateNumericType = TypeUtilities.isApproximateNumericType(this.m_type);
        this.m_isBinaryType = TypeUtilities.isBinaryType(this.m_type);
        this.m_isCharacterType = TypeUtilities.isCharacterType(this.m_type);
        this.m_isExactNumericType = TypeUtilities.isExactNumericType(this.m_type);
        this.m_isIntegerType = TypeUtilities.isIntegerType(this.m_type);
        this.m_isIntervalType = TypeUtilities.isIntervalType(this.m_type);
        this.m_isBooleanType = TypeUtilities.isBooleanType(this.m_type);
    }

    public static TypeMetadata copyOf(TypeMetadata typeMeta) {
        TypeMetadata copy = new TypeMetadata(typeMeta.getType(), typeMeta.getTypeName(), typeMeta.getPrecision(), typeMeta.getScale(), typeMeta.getIntervalPrecision(), typeMeta.isSigned());
        ArrayList<IColumn> nestedColumn = null;
        if (null != typeMeta.getNestedColumnList()) {
            nestedColumn = new ArrayList<IColumn>(typeMeta.getNestedColumnList());
        }
        copy.setNestedColumnList(nestedColumn);
        copy.setIsCurrency(typeMeta.isCurrency());
        copy.setIsSortable(typeMeta.isSortable());
        return copy;
    }

    public int getIntervalPrecision() {
        return this.m_intervalPrecision;
    }

    public String getLocalTypeName() {
        return this.m_localTypeName;
    }

    public short getPrecision() {
        return this.m_precision;
    }

    public short getScale() {
        return this.m_scale;
    }

    public short getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isApproximateNumericType() {
        return this.m_isApproximateNumericType;
    }

    public boolean isBooleanType() {
        return this.m_isBooleanType;
    }

    public boolean isBinaryType() {
        return this.m_isBinaryType;
    }

    public boolean isCharacterOrBinaryType() {
        return this.m_isCharacterType || this.m_isBinaryType;
    }

    public boolean isCharacterType() {
        return this.m_isCharacterType;
    }

    public boolean isCurrency() {
        return this.m_isCurrency;
    }

    public boolean isExactNumericType() {
        return this.m_isExactNumericType;
    }

    public boolean isIntegerType() {
        return this.m_isIntegerType;
    }

    public boolean isIntervalType() {
        return this.m_isIntervalType;
    }

    public boolean isSigned() {
        return this.m_isSigned;
    }

    public boolean isSortable() {
        return this.m_isSortable;
    }

    public void setIntervalPrecision(int intervalPrecision) {
        this.m_intervalPrecision = intervalPrecision;
    }

    public void setIsCurrency(boolean isCurrency) {
        this.m_isCurrency = isCurrency;
    }

    public void setIsSortable(boolean isSortable) {
        this.m_isSortable = isSortable;
    }

    public void setLocalTypeName(String in_localTypeName) {
        this.m_localTypeName = in_localTypeName;
    }

    public void setPrecision(short precision) {
        this.m_precision = precision;
    }

    public void setScale(short scale) {
        this.m_scale = scale;
    }

    public void setSigned(boolean isSigned) {
        this.m_isSigned = isSigned;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_intervalPrecision;
        result = 31 * result + (this.m_isApproximateNumericType ? 1231 : 1237);
        result = 31 * result + (this.m_isBinaryType ? 1231 : 1237);
        result = 31 * result + (this.m_isBooleanType ? 1231 : 1237);
        result = 31 * result + (this.m_isCharacterType ? 1231 : 1237);
        result = 31 * result + (this.m_isExactNumericType ? 1231 : 1237);
        result = 31 * result + (this.m_isIntegerType ? 1231 : 1237);
        result = 31 * result + (this.m_isIntervalType ? 1231 : 1237);
        result = 31 * result + (this.m_isSigned ? 1231 : 1237);
        result = 31 * result + this.m_precision;
        result = 31 * result + this.m_scale;
        result = 31 * result + this.m_type;
        result = 31 * result + (this.m_typeName == null ? 0 : this.m_typeName.hashCode());
        result = 31 * result + (this.m_nestedColumnList == null ? 0 : this.m_nestedColumnList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeMetadata other = (TypeMetadata)obj;
        if (this.m_intervalPrecision != other.m_intervalPrecision) {
            return false;
        }
        if (this.m_isApproximateNumericType != other.m_isApproximateNumericType) {
            return false;
        }
        if (this.m_isBinaryType != other.m_isBinaryType) {
            return false;
        }
        if (this.m_isBooleanType != other.m_isBooleanType) {
            return false;
        }
        if (this.m_isCharacterType != other.m_isCharacterType) {
            return false;
        }
        if (this.m_isExactNumericType != other.m_isExactNumericType) {
            return false;
        }
        if (this.m_isIntegerType != other.m_isIntegerType) {
            return false;
        }
        if (this.m_isIntervalType != other.m_isIntervalType) {
            return false;
        }
        if (this.m_isSigned != other.m_isSigned) {
            return false;
        }
        if (this.m_precision != other.m_precision) {
            return false;
        }
        if (this.m_scale != other.m_scale) {
            return false;
        }
        if (this.m_type != other.m_type) {
            return false;
        }
        if (this.m_typeName == null ? other.m_typeName != null : !this.m_typeName.equals(other.m_typeName)) {
            return false;
        }
        if (this.m_nestedColumnList == null && other.m_nestedColumnList != null) {
            return false;
        }
        return this.m_nestedColumnList == null || this.m_nestedColumnList.equals(other.m_nestedColumnList);
    }

    public ArrayList<IColumn> getNestedColumnList() {
        return this.m_nestedColumnList;
    }

    public void setNestedColumnList(ArrayList<IColumn> in_nestedColumnList) {
        this.m_nestedColumnList = in_nestedColumnList;
    }
}

