/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.IncorrectTypeException;

public class DSITypeUtilities {
    public static boolean outputCharStringData(String value, DataWrapper retrievedData, long charOffset, long maxChars) {
        try {
            return DSITypeUtilities.outputString(value, retrievedData, charOffset, maxChars, 1);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputVarCharStringData(String value, DataWrapper retrievedData, long charOffset, long maxChars) {
        try {
            return DSITypeUtilities.outputString(value, retrievedData, charOffset, maxChars, 12);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputLongVarCharStringData(String value, DataWrapper retrievedData, long charOffset, long maxChars) {
        try {
            return DSITypeUtilities.outputString(value, retrievedData, charOffset, maxChars, -1);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputBinary(byte[] value, DataWrapper retrievedData, long offset, long maxSize) {
        try {
            return DSITypeUtilities.outputBytes(value, retrievedData, offset, maxSize, -2);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputVarBinary(byte[] value, DataWrapper retrievedData, long offset, long maxSize) {
        try {
            return DSITypeUtilities.outputBytes(value, retrievedData, offset, maxSize, -3);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputLongVarBinary(byte[] value, DataWrapper retrievedData, long offset, long maxSize) {
        try {
            return DSITypeUtilities.outputBytes(value, retrievedData, offset, maxSize, -4);
        }
        catch (IncorrectTypeException e) {
            return true;
        }
    }

    public static boolean outputString(String value, DataWrapper retrievedData, long charOffset, long maxChars, int sqlType) throws IncorrectTypeException {
        assert (1 == sqlType || 12 == sqlType || -1 == sqlType || -8 == sqlType || -9 == sqlType || -10 == sqlType);
        assert (charOffset >= 0L && charOffset <= Integer.MAX_VALUE);
        if (value != null) {
            String offsetColumn = value.substring((int)charOffset);
            if (maxChars == -1L) {
                retrievedData.setData(sqlType, offsetColumn);
                return false;
            }
            int copySize = Math.min((int)maxChars, offsetColumn.length());
            retrievedData.setData(sqlType, offsetColumn.substring(0, copySize));
            return copySize < offsetColumn.length();
        }
        retrievedData.setNull(sqlType);
        return false;
    }

    public static boolean outputBytes(byte[] value, DataWrapper retrievedData, long offset, long maxSize, int sqlType) throws IncorrectTypeException {
        assert (-2 == sqlType || -3 == sqlType || -4 == sqlType);
        assert (0L <= offset);
        if (value != null) {
            boolean moreData;
            byte[] result;
            long byteLength = value.length;
            long maxOutputLength = byteLength - offset;
            if (-1L == maxSize || maxOutputLength <= maxSize) {
                result = new byte[(int)maxOutputLength];
                System.arraycopy(value, (int)offset, result, 0, (int)maxOutputLength);
                moreData = false;
            } else {
                result = new byte[(int)maxSize];
                System.arraycopy(value, (int)offset, result, 0, (int)maxSize);
                moreData = true;
            }
            retrievedData.setData(sqlType, result);
            return moreData;
        }
        retrievedData.setNull(sqlType);
        return false;
    }
}

